/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOMultiNotch;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GPMultiNotch
extends GPluginFrame {
    private JComboBox presets;
    private UiControlText q;
    private JTable frequency;
    private JButton apply;
    private EventDispatcher eventDispatcher;
    private String[] presetsName;
    private float[] qPresets;
    private float[][] frequencyPresets;
    private static final int maxRows = 20;

    public GPMultiNotch(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "multiNotch";
    }

    private void initGui() {
        PersistenceDefaultImpl persistenceDefaultImpl = new PersistenceDefaultImpl();
        try {
            ((Persistence)persistenceDefaultImpl).restore(this.getName() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = ((Persistence)persistenceDefaultImpl).getInt("numberOfPresets");
        int n2 = ((Persistence)persistenceDefaultImpl).getInt("numberOfFrequencies");
        this.presetsName = new String[n];
        this.qPresets = new float[n];
        this.frequencyPresets = new float[n][];
        for (int i = 0; i < n; ++i) {
            this.presetsName[i] = GLanguage.translate(((Persistence)persistenceDefaultImpl).getString("name_" + i));
            this.qPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("q_" + i);
            this.frequencyPresets[i] = new float[n2];
            for (int j = 0; j < n2; ++j) {
                this.frequencyPresets[i][j] = ((Persistence)persistenceDefaultImpl).getFloat("frequency_" + i + "_" + j);
            }
        }
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 8);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("presets")), 0, 0, 4, 1);
        this.presets = new JComboBox<String>(this.presetsName);
        uiCartesianLayout.add(this.presets, 4, 0, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("quality")), 0, 1, 4, 1);
        this.q = new GControlTextA(7, true, true);
        this.q.setDataRange(1.0, 100.0);
        this.q.setData(1.0);
        uiCartesianLayout.add(this.q, 4, 1, 6, 1);
        Object[] objectArray = new String[]{GLanguage.translate("frequency") + "[Hz]"};
        this.frequency = new JTable(new Object[20][1], objectArray);
        JScrollPane jScrollPane = new JScrollPane(this.frequency);
        this.frequency.setPreferredScrollableViewportSize(new Dimension(200, 70));
        uiCartesianLayout.add(jScrollPane, 0, 2, 10, 5);
        this.onPresets();
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 7, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
        this.presets.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.q.refresh();
    }

    private void loadFrequencies(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.frequency.setValueAt(String.valueOf(fArray[i]), i, 0);
        }
    }

    private void onPresets() {
        int n = this.presets.getSelectedIndex();
        this.q.setData(this.qPresets[n]);
        this.loadFrequencies(this.frequencyPresets[n]);
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float[] fArray = new float[this.frequency.getRowCount()];
        for (int i = 0; i < this.frequency.getRowCount(); ++i) {
            try {
                fArray[i] = Float.parseFloat((String)this.frequency.getValueAt(i, 0)) / this.getFocussedClip().getSampleRate();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        aLayerSelection.operateEachChannel(new AOMultiNotch(fArray, (float)this.q.getData()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPMultiNotch.this.apply) {
                LProgressViewer.getInstance().entrySubProgress(GPMultiNotch.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPMultiNotch.this.getName() + " [apply] clicked");
                GPMultiNotch.this.onApply();
                GPMultiNotch.this.updateHistory(GLanguage.translate(GPMultiNotch.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPMultiNotch.this.reloadFocussedClipEditor();
                GPMultiNotch.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPMultiNotch.this.presets) {
                Debug.println(1, "plugin " + GPMultiNotch.this.getName() + " [presets] clicked");
                GPMultiNotch.this.onPresets();
            }
        }
    }
}

