/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOPan;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChannelChooser;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPPan
extends GPluginFrame {
    private GClipLayerChannelChooser panChannel;
    private JTabbedPane tab;
    private JComboBox mode;
    private JComboBox shape;
    private UiControlText pan;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPPan(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "pan";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 8);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.tab = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 4);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("pan")), 0, 1, 5, 1);
        this.pan = new GControlTextA(7, true, true);
        this.pan.setDataRange(1.0, 2.0);
        this.pan.setData(1.5);
        this.pan.setEditable(true);
        uiCartesianLayout2.add(this.pan, 5, 1, 5, 1);
        this.tab.add((Component)jPanel2, GLanguage.translate("constant"));
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 4);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        this.panChannel = new GClipLayerChannelChooser(Laoe.getInstance(), "panCurve");
        uiCartesianLayout3.add(this.panChannel, 0, 0, 10, 4);
        this.tab.add((Component)jPanel3, GLanguage.translate("f(time)"));
        uiCartesianLayout.add(this.tab, 0, 0, 10, 5);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("mode")), 0, 5, 5, 1);
        String[] stringArray = new String[]{GLanguage.translate("half"), GLanguage.translate("full"), GLanguage.translate("mixEnds")};
        this.mode = new JComboBox<String>(stringArray);
        this.mode.setSelectedIndex(0);
        uiCartesianLayout.add(this.mode, 5, 5, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("shape")), 0, 6, 5, 1);
        String[] stringArray2 = new String[]{GLanguage.translate("squareRoot"), GLanguage.translate("linear"), GLanguage.translate("square")};
        this.shape = new JComboBox<String>(stringArray2);
        this.shape.setSelectedIndex(1);
        uiCartesianLayout.add(this.shape, 5, 6, 5, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 7, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
    }

    private void onApply() {
        int n;
        int n2;
        switch (this.mode.getSelectedIndex()) {
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        switch (this.shape.getSelectedIndex()) {
            case 0: {
                n = -1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 1;
            }
        }
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        ALayerSelection aLayerSelection2 = new ALayerSelection(new ALayer());
        aLayerSelection2.addChannelSelection(aLayerSelection.getChannelSelection(0));
        aLayerSelection2.addChannelSelection(aLayerSelection.getChannelSelection(1));
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                aLayerSelection2.operateChannel0WithChannel1(new AOPan(n2, n, (float)this.pan.getData()));
                break;
            }
            case 1: {
                aLayerSelection2.addChannelSelection(this.panChannel.getSelectedChannel().getSelection());
                aLayerSelection2.operateChannel0WithChannel1WithChannel2(new AOPan(n2, n));
            }
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.panChannel.reload();
        this.pan.refresh();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LProgressViewer.getInstance().entrySubProgress(GPPan.this.getName());
            LProgressViewer.getInstance().entrySubProgress(0.7);
            if (actionEvent.getSource() == GPPan.this.apply) {
                Debug.println(1, "plugin " + GPPan.this.getName() + " [apply] clicked");
                GPPan.this.onApply();
                GPPan.this.autoCloseNow();
            }
            GPPan.this.updateHistory(GLanguage.translate(GPPan.this.getName()));
            LProgressViewer.getInstance().exitSubProgress();
            LProgressViewer.getInstance().exitSubProgress();
            GPPan.this.reloadFocussedClipEditor();
        }
    }
}

