/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPMeasure;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlEvent;
import ch.oli4.ui.control.UiControlListener;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GPSampleEditor
extends GPluginFrame {
    private JComboBox offsetSetting;
    private UiControlText sampleOffset;
    private JTable sampleTable;
    private JButton apply;
    private EventDispatcher eventDispatcher;
    private static final int maxRows = 20;

    public GPSampleEditor(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "sampleEditor";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 10);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        String[] stringArray = new String[]{GLanguage.translate("begin"), GLanguage.translate("end"), GLanguage.translate("zoomBegin"), GLanguage.translate("loopBegin"), GLanguage.translate("measureBegin"), GLanguage.translate("selectionBegin")};
        this.offsetSetting = new JComboBox<String>(stringArray);
        this.offsetSetting.setSelectedIndex(0);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("offsetSetting")), 0, 0, 4, 1);
        uiCartesianLayout.add(this.offsetSetting, 4, 0, 6, 1);
        this.sampleOffset = new GControlTextX(Laoe.getInstance(), 9, true, true);
        this.sampleOffset.setDataRange(0.0, 1.0E9);
        this.sampleOffset.setData(0.0);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("sampleOffset")), 0, 1, 4, 1);
        uiCartesianLayout.add(this.sampleOffset, 4, 1, 6, 1);
        Object[] objectArray = new String[]{GLanguage.translate("sample") + " [1]", GLanguage.translate("value") + " [1]"};
        this.sampleTable = new JTable(new Object[20][2], objectArray);
        JScrollPane jScrollPane = new JScrollPane(this.sampleTable);
        this.sampleTable.setPreferredScrollableViewportSize(new Dimension(200, 70));
        uiCartesianLayout.add(jScrollPane, 0, 2, 10, 7);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 9, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
        this.offsetSetting.addActionListener(this.eventDispatcher);
        this.sampleOffset.addControlListener(this.eventDispatcher);
    }

    private void onApply() {
        this.tableToSample();
    }

    @Override
    public void reload() {
        super.reload();
        this.sampleToTable();
    }

    private void sampleToTable() {
        AClip aClip = this.getFocussedClip();
        ALayer aLayer = aClip.getSelectedLayer();
        AChannel aChannel = aLayer.getSelectedChannel();
        int n = (int)this.sampleOffset.getData();
        if (n < 0) {
            n = 0;
        } else if (n > aChannel.getSampleLength() - 1 - 20) {
            n = aChannel.getSampleLength() - 1 - 20;
        }
        this.sampleOffset.setData(n);
        for (int i = 0; i < 20; ++i) {
            this.sampleTable.setValueAt(String.valueOf(n + i), i, 0);
            this.sampleTable.setValueAt(String.valueOf(aChannel.getSamples().get(n + i)), i, 1);
        }
    }

    private void tableToSample() {
        AClip aClip = this.getFocussedClip();
        ALayer aLayer = aClip.getSelectedLayer();
        AChannel aChannel = aLayer.getSelectedChannel();
        for (int i = 0; i < 20; ++i) {
            aChannel.getSamples().set((int)Double.parseDouble((String)this.sampleTable.getValueAt(i, 0)), (float)Double.parseDouble((String)this.sampleTable.getValueAt(i, 1)));
        }
    }

    private class EventDispatcher
    implements ActionListener,
    UiControlListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSampleEditor.this.apply) {
                LProgressViewer.getInstance().entrySubProgress(GPSampleEditor.this.getName());
                Debug.println(1, "plugin " + GPSampleEditor.this.getName() + " [apply] clicked");
                GPSampleEditor.this.onApply();
                GPSampleEditor.this.updateHistory(GLanguage.translate(GPSampleEditor.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                GPSampleEditor.this.reloadFocussedClipEditor();
                GPSampleEditor.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPSampleEditor.this.offsetSetting) {
                Debug.println(1, "plugin " + GPSampleEditor.this.getName() + " [offset setting] clicked");
                AClip aClip = GPSampleEditor.this.getFocussedClip();
                ALayer aLayer = aClip.getSelectedLayer();
                AChannel aChannel = aLayer.getSelectedChannel();
                AChannelPlotter aChannelPlotter = aChannel.getPlotter();
                AChannelSelection aChannelSelection = aChannel.getSelection();
                switch (GPSampleEditor.this.offsetSetting.getSelectedIndex()) {
                    case 0: {
                        GPSampleEditor.this.sampleOffset.setData(0.0);
                        break;
                    }
                    case 1: {
                        GPSampleEditor.this.sampleOffset.setData(aChannel.getSampleLength() - 1 - 20);
                        break;
                    }
                    case 2: {
                        GPSampleEditor.this.sampleOffset.setData((int)aChannelPlotter.getXOffset());
                        break;
                    }
                    case 3: {
                        GPSampleEditor.this.sampleOffset.setData(aClip.getAudio().getLoopStartPointer());
                        break;
                    }
                    case 4: {
                        GPSampleEditor.this.sampleOffset.setData((int)GPMeasure.getLowerCursor());
                        break;
                    }
                    case 5: {
                        GPSampleEditor.this.sampleOffset.setData(aChannelSelection.getOffset());
                    }
                }
                GPSampleEditor.this.sampleToTable();
            }
        }

        @Override
        public void onDataChanging(UiControlEvent uiControlEvent) {
        }

        @Override
        public void onDataChanged(UiControlEvent uiControlEvent) {
            Debug.println(1, "plugin " + GPSampleEditor.this.getName() + " [sample offset] changed");
            GPSampleEditor.this.sampleToTable();
        }

        @Override
        public void onValidate(UiControlEvent uiControlEvent) {
            Debug.println(1, "plugin " + GPSampleEditor.this.getName() + " [sample offset] changed");
            GPSampleEditor.this.sampleToTable();
        }
    }
}

