/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GCookie;
import ch.laoe.ui.GEditableArea;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPSpectrogramSelect
extends GPluginFrame {
    private GEditableArea area;
    private AChannel actualChannel;
    private UiControlText brushSize;
    private JCheckBox inversed;
    private JComboBox drawMode;
    private EventDispatcher eventDispatcher;
    private GEditableArea clipBoardArea;

    public GPSpectrogramSelect(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
        this.updateCookie();
    }

    @Override
    public String getName() {
        return "spectrogramSelect";
    }

    @Override
    public void start() {
        super.start();
        this.updateCookie();
    }

    @Override
    public void reload() {
        super.reload();
        this.updateCookie();
        this.brushSize.refresh();
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    private void updateCookie() {
        try {
            ALayer aLayer = this.getSelectedLayer();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                if (aLayer.getChannel(i).getCookies().getCookie(this.getName()) != null) continue;
                AChannel aChannel = aLayer.getChannel(i);
                aChannel.getCookies().setCookie(new Cookie(aChannel), this.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateActualArea(MouseEvent mouseEvent) {
        try {
            AChannel aChannel = this.getSelectedLayer().getChannel(mouseEvent.getPoint());
            if (aChannel != null) {
                this.actualChannel = this.getSelectedLayer().getChannel(mouseEvent.getPoint());
                this.area = ((Cookie)this.actualChannel.getCookies().getCookie((String)this.getName())).area;
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    private void updateActualArea() {
        try {
            this.actualChannel = this.getSelectedLayer().getSelectedChannel();
            this.area = ((Cookie)this.actualChannel.getCookies().getCookie((String)this.getName())).area;
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    private void wideCopySpectrogramSelection(MouseEvent mouseEvent, GEditableArea gEditableArea) {
        if (GToolkit.isCtrlKey(mouseEvent)) {
            this.getFocussedClip().getSelectedLayer().wideCopySpectrogramSelection(gEditableArea);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.updateActualArea(mouseEvent);
            this.area.mousePressed(mouseEvent);
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.area.mouseReleased(mouseEvent);
        this.wideCopySpectrogramSelection(mouseEvent, this.area);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            this.updateActualArea(mouseEvent);
            switch (this.drawMode.getSelectedIndex()) {
                case 0: {
                    this.area.setDrawMode(1);
                    break;
                }
                case 1: {
                    this.area.setDrawMode(2);
                    break;
                }
                case 2: {
                    this.area.setDrawMode(3);
                }
            }
            this.area.setBrushSize((int)this.brushSize.getData());
            this.area.mouseMoved(mouseEvent);
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.area.mouseDragged(mouseEvent);
        this.wideCopySpectrogramSelection(mouseEvent, this.area);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.area.mouseClicked(mouseEvent);
        if (mouseEvent.getClickCount() == 1) {
            Debug.println(6, "mouse clicked: unselect");
            this.area.clear();
        } else if (mouseEvent.getClickCount() == 2) {
            Debug.println(6, "mouse double-clicked: create marked selection");
            this.area.selectAll();
        } else if (mouseEvent.getClickCount() == 3) {
            Debug.println(6, "mouse tripple-clicked: create channel selection");
            this.area.selectAll();
        }
        this.updateHistory(GLanguage.translate(this.getName()) + " " + GLanguage.translate("range"));
        this.repaintFocussedClipEditor();
        this.wideCopySpectrogramSelection(mouseEvent, this.area);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateActualArea(mouseEvent);
        this.area.mouseEntered(mouseEvent);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        try {
            ALayer aLayer = this.getSelectedLayer();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                ((Cookie)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).area.paintOntoClip(graphics2D, rectangle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 3);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("drawMode")), 0, 0, 5, 1);
        String[] stringArray = new String[]{GLanguage.translate("rectangle"), GLanguage.translate("line"), GLanguage.translate("shape")};
        this.drawMode = new JComboBox<String>(stringArray);
        this.drawMode.setSelectedIndex(0);
        uiCartesianLayout.add(this.drawMode, 5, 0, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("brushSize")), 0, 1, 5, 1);
        this.brushSize = new UiControlText(9, true, true);
        this.brushSize.setDataRange(2.0, 50.0);
        this.brushSize.setData(8.0);
        uiCartesianLayout.add(this.brushSize, 5, 1, 5, 1);
        this.inversed = new JCheckBox(GLanguage.translate("inversed"));
        uiCartesianLayout.add(this.inversed, 0, 2, 7, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.inversed.addActionListener(this.eventDispatcher);
        this.drawMode.addActionListener(this.eventDispatcher);
        this.updateComponents();
    }

    private void updateComponents() {
        this.brushSize.setEnabled(this.drawMode.getSelectedIndex() == 1);
    }

    private void onInverse(ActionEvent actionEvent) {
        this.updateActualArea();
        if (GToolkit.isCtrlKey(actionEvent)) {
            ALayer aLayer = this.getSelectedLayer();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                ((Cookie)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).area.setInversed(this.inversed.isSelected());
            }
        } else {
            this.area.setInversed(this.inversed.isSelected());
        }
        this.repaintFocussedClipEditor();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSpectrogramSelect.this.inversed) {
                Debug.println(1, "plugin " + GPSpectrogramSelect.this.getName() + " [inversed] clicked");
                GPSpectrogramSelect.this.onInverse(actionEvent);
            } else if (actionEvent.getSource() == GPSpectrogramSelect.this.drawMode) {
                Debug.println(1, "plugin " + GPSpectrogramSelect.this.getName() + " [draw mode] clicked");
                GPSpectrogramSelect.this.updateComponents();
            }
            GPSpectrogramSelect.this.repaintFocussedClipEditor();
        }
    }

    public static class Cookie
    extends GCookie {
        public GEditableArea area = new GEditableArea();

        public Cookie(AChannel aChannel) {
            this.area.setChannel(aChannel);
        }
    }
}

