/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.plugin.GPlugin;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.Laoe;
import ch.oli4.persistence.Persistence;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public abstract class GPluginFrame
extends GPlugin
implements WindowListener {
    protected JFrame frame = new JFrame();
    private boolean visibleOnExit;

    public GPluginFrame(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        ImageIcon imageIcon = this.loadIcon();
        if (imageIcon != null) {
            this.frame.setIconImage(imageIcon.getImage());
        } else {
            URL uRL = this.getClass().getResource("laoe.gif");
            if (uRL != null) {
                this.frame.setIconImage(new ImageIcon(uRL).getImage());
            }
        }
        this.frame.setAlwaysOnTop(this.persistance.getBoolean("pluginFrame.alwaysOnTop"));
        this.frame.addWindowListener(this);
        this.frame.setTitle(GLanguage.translate(this.getName()));
        this.restoreLocation();
    }

    @Override
    public void onBackup(Persistence persistence) {
        this.backupLocation();
    }

    @Override
    public boolean isVisible() {
        return this.frame.isVisible();
    }

    protected void pack() {
        this.frame.pack();
        this.frame.setResizable(false);
    }

    protected void autoCloseNow() {
        if (this.persistance.getBoolean("plugin.autoclose")) {
            this.frame.setVisible(false);
        }
        Laoe.getInstance().getPluginHandler().setLastPerformingPlugin(this);
    }

    public boolean wasVisibleOnExit() {
        return this.visibleOnExit;
    }

    public void restoreLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(this.persistance.getInt("plugin." + this.getName() + ".frameLocation.x"), dimension.width - 100);
        int n2 = Math.min(this.persistance.getInt("plugin." + this.getName() + ".frameLocation.y"), dimension.height - 100);
        this.frame.setLocation(n, n2);
        this.visibleOnExit = this.persistance.getBoolean("plugin." + this.getName() + ".visible");
    }

    public void backupLocation() {
        this.persistance.setInt("plugin." + this.getName() + ".frameLocation.x", this.frame.getLocation().x);
        this.persistance.setInt("plugin." + this.getName() + ".frameLocation.y", this.frame.getLocation().y);
        this.persistance.setBoolean("plugin." + this.getName() + ".visible", this.frame.isVisible());
    }

    public void showErrorDialog(String string, String string2) {
        GDialog.showErrorDialog(this.frame, string, string2);
    }

    @Override
    public void start() {
        super.start();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void focuss() {
        super.focuss();
        this.frame.setVisible(true);
        this.frame.setState(0);
        this.frame.toFront();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.start();
        if (this.getFocussedClip() != null) {
            this.reload();
            this.repaintFocussedClipEditor();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Debug.println(2, "close plugin-frame " + this.getName());
        this.frame.setVisible(false);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public void setState(int n) {
        this.frame.setState(n);
    }

    public int getState() {
        return this.frame.getState();
    }
}

