/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOSegmentGenerator;
import ch.laoe.operation.AOSpline;
import ch.laoe.operation.AOToolkit;
import ch.laoe.ui.GToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;

public class GEditableSegments {
    private Color color;
    private boolean pointsVisible = true;
    private boolean highlightActivePoint = true;
    private boolean editable = true;
    private boolean lockMode = false;
    private boolean coverAllXRange = false;
    private int yDomain;
    public static final int SAMPLE_DOMAIN = 1;
    public static final int PERCENT_DOMAIN = 2;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private ArrayList<FPoint> segmentPoints = new ArrayList(25);
    private int activePointIndex;
    private FPoint selectedPoint;
    private FPoint leftPoint;
    private FPoint rightPoint;
    private AOSpline spline = AOToolkit.createSpline();
    private int actualOperation = 0;
    private static final int IDLE = 0;
    private static final int DRAW = 1;
    private static final int REMOVE = 2;
    private int segmentMode = 1;
    public static final int SINGLE_POINTS = -1;
    public static final int ORDER_0 = 0;
    public static final int ORDER_1 = 1;
    public static final int SPLINE = 4;
    private AChannel actualChannel;
    private Cursor penCursor;
    private Cursor eraseCursor;
    private Cursor actualCursor;
    private MMArray x;
    private MMArray y;
    private Stroke segmentSroke = new BasicStroke();
    private MMArray grX = null;
    private MMArray grY = null;

    public GEditableSegments() {
        this.color = Color.yellow;
        this.setYDomain(1);
        this.clearXRange();
        this.clearYRange();
        this.penCursor = GToolkit.createCustomCursor(this, "penCursor");
        this.eraseCursor = GToolkit.createCustomCursor(this, "eraseCursor");
        this.actualCursor = this.penCursor;
    }

    public GEditableSegments(GEditableSegments gEditableSegments) {
        this();
        this.color = gEditableSegments.color;
        this.pointsVisible = gEditableSegments.pointsVisible;
        this.highlightActivePoint = gEditableSegments.highlightActivePoint;
        this.segmentMode = gEditableSegments.segmentMode;
        this.editable = gEditableSegments.editable;
        this.xMin = gEditableSegments.xMin;
        this.xMax = gEditableSegments.xMax;
        this.yMin = gEditableSegments.yMin;
        this.yMax = gEditableSegments.yMax;
        this.color = gEditableSegments.color;
        this.yDomain = gEditableSegments.yDomain;
        this.coverAllXRange = gEditableSegments.coverAllXRange;
        for (int i = 0; i < gEditableSegments.segmentPoints.size(); ++i) {
            this.segmentPoints.add(new FPoint(gEditableSegments.segmentPoints.get(i)));
        }
    }

    public void copy(GEditableSegments gEditableSegments) {
        if (gEditableSegments == this) {
            return;
        }
        this.color = gEditableSegments.color;
        this.pointsVisible = gEditableSegments.pointsVisible;
        this.segmentMode = gEditableSegments.segmentMode;
        this.editable = gEditableSegments.editable;
        this.xMin = gEditableSegments.xMin;
        this.xMax = gEditableSegments.xMax;
        this.yMin = gEditableSegments.yMin;
        this.yMax = gEditableSegments.yMax;
        this.yDomain = gEditableSegments.yDomain;
        this.segmentPoints.clear();
        for (int i = 0; i < gEditableSegments.segmentPoints.size(); ++i) {
            this.segmentPoints.add(new FPoint(gEditableSegments.segmentPoints.get(i)));
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPointsVisible(boolean bl) {
        this.pointsVisible = bl;
    }

    public void setHighlightActivePointEnabled(boolean bl) {
        this.highlightActivePoint = bl;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setLockMode(boolean bl) {
        this.lockMode = bl;
    }

    public void setCoverAllXRangeEnabled(boolean bl) {
        this.coverAllXRange = bl;
    }

    public void setYDomain(int n) {
        switch (n) {
            case 1: 
            case 2: {
                this.yDomain = n;
                break;
            }
            default: {
                this.yDomain = 1;
            }
        }
    }

    public int getYDomain() {
        return this.yDomain;
    }

    public void setXRange(double d, double d2) {
        this.xMin = d;
        this.xMax = d + d2;
    }

    public void setYRange(double d, double d2) {
        this.yMin = d;
        this.yMax = d + d2;
    }

    public void clearXRange() {
        this.xMin = -1.7976931348623157E308;
        this.xMax = Double.MAX_VALUE;
    }

    public void clearYRange() {
        this.yMin = -1.7976931348623157E308;
        this.yMax = Double.MAX_VALUE;
    }

    public void setComplementary() {
        for (int i = 0; i < this.segmentPoints.size(); ++i) {
            FPoint fPoint = this.segmentPoints.get(i);
            fPoint.y = 1.0 - fPoint.y;
        }
    }

    public double getActivePointX() {
        try {
            return this.segmentPoints.get((int)this.activePointIndex).x;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public double getActivePointY() {
        try {
            return this.segmentPoints.get((int)this.activePointIndex).y;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public void setSegmentMode(int n) {
        this.segmentMode = n;
    }

    public int getSegmentMode() {
        return this.segmentMode;
    }

    public void setChannel(AChannel aChannel) {
        this.actualChannel = aChannel;
    }

    private int searchNearest(FPoint fPoint) {
        double d = Double.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.segmentPoints.size(); ++i) {
            double d2 = fPoint.getGraphSquareDistance(this.segmentPoints.get(i));
            if (!(d2 < d) || !(d2 < 400.0)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    private int searchInsertIndex(FPoint fPoint) {
        for (int i = 0; i < this.segmentPoints.size(); ++i) {
            if (!(fPoint.x < this.segmentPoints.get((int)i).x)) continue;
            return i;
        }
        return this.segmentPoints.size();
    }

    public void clear() {
        this.segmentPoints.clear();
    }

    public int getNumberOfPoints() {
        return this.segmentPoints.size();
    }

    public void addPoint(double d, double d2) {
        this.segmentPoints.add(new FPoint(d, d2));
    }

    public double getPointX(int n) {
        return this.segmentPoints.get((int)n).x;
    }

    public double getPointY(int n) {
        return this.segmentPoints.get((int)n).y;
    }

    public void convertToSamples(int n) {
        if (this.segmentPoints.size() > 0) {
            MMArray mMArray = new MMArray(this.segmentPoints.size(), 0.0f);
            MMArray mMArray2 = new MMArray(mMArray.getLength(), 0.0f);
            for (int i = 0; i < mMArray.getLength(); ++i) {
                mMArray.set(i, (float)this.segmentPoints.get((int)i).x);
                mMArray2.set(i, (float)this.segmentPoints.get((int)i).y);
            }
            AChannelSelection aChannelSelection = this.actualChannel.createSelection();
            aChannelSelection.operateChannel(new AOSegmentGenerator(mMArray, mMArray2, this.segmentMode, n, true));
        }
    }

    public void convertToSelectedSamples(int n) {
        if (this.segmentPoints.size() > 0) {
            MMArray mMArray = new MMArray(this.segmentPoints.size(), 0.0f);
            MMArray mMArray2 = new MMArray(mMArray.getLength(), 0.0f);
            for (int i = 0; i < mMArray.getLength(); ++i) {
                mMArray.set(i, (float)this.segmentPoints.get((int)i).x);
                mMArray2.set(i, (float)this.segmentPoints.get((int)i).y);
            }
            AChannelSelection aChannelSelection = this.actualChannel.getSelection();
            aChannelSelection.operateChannel(new AOSegmentGenerator(mMArray, mMArray2, this.segmentMode, n, false));
        }
    }

    public void prepareResults() {
        if (this.x == null) {
            this.x = new MMArray(this.segmentPoints.size(), 0.0f);
        }
        this.x.setLength(this.segmentPoints.size());
        if (this.y == null) {
            this.y = new MMArray(this.segmentPoints.size(), 0.0f);
        }
        this.y.setLength(this.segmentPoints.size());
        for (int i = 0; i < this.x.getLength(); ++i) {
            this.x.set(i, (float)this.segmentPoints.get((int)i).x);
            this.y.set(i, (float)this.segmentPoints.get((int)i).y);
        }
        AOSpline aOSpline = AOToolkit.createSpline();
        aOSpline.load(this.x, this.y);
    }

    public float getSample(int n) {
        switch (this.segmentMode) {
            case -1: {
                for (int i = 0; i < this.x.getLength(); ++i) {
                    if (n != (int)this.x.get(i)) continue;
                    return this.y.get(i);
                }
                return 0.0f;
            }
            case 0: {
                return AOToolkit.interpolate0(this.x, this.y, n);
            }
            case 1: {
                return AOToolkit.interpolate1(this.x, this.y, (float)n);
            }
            case 4: {
                return this.spline.getResult(n);
            }
        }
        return 0.0f;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            AChannelPlotter aChannelPlotter = this.actualChannel.getPlotter();
            this.setXRange(aChannelPlotter.getXOffset(), aChannelPlotter.getXLength());
            this.actualOperation = 0;
            FPoint fPoint = new FPoint();
            fPoint.toSampleDomain(mouseEvent.getPoint());
            fPoint.limitRange();
            this.actualOperation = GToolkit.isShiftKey(mouseEvent) ? 2 : 1;
            if (this.actualOperation == 1) {
                int n = this.searchNearest(fPoint);
                if (n >= 0) {
                    this.actualOperation = 1;
                    this.selectedPoint = this.segmentPoints.get(n);
                    this.leftPoint = n > 0 ? this.segmentPoints.get(n - 1) : null;
                    this.rightPoint = n < this.segmentPoints.size() - 1 ? this.segmentPoints.get(n + 1) : null;
                } else {
                    this.actualOperation = 0;
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        if (this.actualChannel != null && this.editable) {
            object = new FPoint();
            ((FPoint)object).toSampleDomain(mouseEvent.getPoint());
            ((FPoint)object).limitRange();
            this.activePointIndex = this.searchNearest((FPoint)object);
        }
        if ((object = GToolkit.isShiftKey(mouseEvent) ? this.eraseCursor : this.penCursor) != this.actualCursor) {
            this.actualCursor = object;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            FPoint fPoint = new FPoint();
            fPoint.toSampleDomain(mouseEvent.getPoint());
            fPoint.limitRange();
            if (this.actualOperation == 1) {
                this.selectedPoint.x = this.leftPoint != null && fPoint.x < this.leftPoint.x + 1.0 ? this.leftPoint.x + 1.0 : (this.rightPoint != null && fPoint.x > this.rightPoint.x - 1.0 ? this.rightPoint.x - 1.0 : fPoint.x);
                this.selectedPoint.y = this.lockMode && GToolkit.isCtrlKey(mouseEvent) ? (double)this.actualChannel.getSample((int)fPoint.x) : fPoint.y;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            FPoint fPoint = new FPoint();
            fPoint.toSampleDomain(mouseEvent.getPoint());
            fPoint.limitRange();
            switch (this.actualOperation) {
                case 0: 
                case 1: {
                    this.segmentPoints.add(this.searchInsertIndex(fPoint), fPoint);
                    break;
                }
                case 2: {
                    int n = this.searchNearest(fPoint);
                    if (n < 0) break;
                    this.segmentPoints.remove(n);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.actualChannel != null) {
            try {
                int n;
                AChannelPlotter aChannelPlotter = this.actualChannel.getPlotter();
                Rectangle rectangle2 = aChannelPlotter.getRectangle();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                graphics2D.setStroke(this.segmentSroke);
                graphics2D.setColor(this.color);
                graphics2D.setClip(rectangle2.x - 5, rectangle2.y - 5, rectangle2.width + 10, rectangle2.height + 10);
                switch (this.segmentMode) {
                    case -1: {
                        int n2;
                        n = aChannelPlotter.sampleToGraphY(0.0f);
                        for (n2 = 0; n2 < this.segmentPoints.size(); ++n2) {
                            Point point = this.segmentPoints.get(n2).toGraphicDomain();
                            graphics2D.drawLine(point.x, point.y, point.x, n);
                        }
                        break;
                    }
                    case 0: {
                        int n2;
                        for (n2 = 0; n2 < this.segmentPoints.size() - 1; ++n2) {
                            Point point = this.segmentPoints.get(n2).toGraphicDomain();
                            Point point2 = this.segmentPoints.get(n2 + 1).toGraphicDomain();
                            graphics2D.drawLine(point.x, point.y, point2.x, point.y);
                            graphics2D.drawLine(point2.x, point.y, point2.x, point2.y);
                        }
                        break;
                    }
                    case 1: {
                        int n2;
                        for (n2 = 0; n2 < this.segmentPoints.size() - 1; ++n2) {
                            Point point = this.segmentPoints.get(n2).toGraphicDomain();
                            Point point3 = this.segmentPoints.get(n2 + 1).toGraphicDomain();
                            graphics2D.drawLine(point.x, point.y, point3.x, point3.y);
                        }
                        break;
                    }
                    case 4: {
                        int n3;
                        int n2 = this.segmentPoints.size();
                        if (n2 <= 3) break;
                        if (this.grX == null) {
                            this.grX = new MMArray(n2, 0.0f);
                        }
                        if (this.grY == null) {
                            this.grY = new MMArray(n2, 0.0f);
                        }
                        if (this.grX.getLength() != n2) {
                            this.grX.setLength(n2);
                        }
                        if (this.grY.getLength() != n2) {
                            this.grY.setLength(n2);
                        }
                        for (n3 = 0; n3 < this.grX.getLength(); ++n3) {
                            Point point = this.segmentPoints.get(n3).toGraphicDomain();
                            this.grX.set(n3, point.x);
                            this.grY.set(n3, point.y);
                        }
                        this.spline.load(this.grX, this.grY);
                        n3 = Math.max(rectangle.x, (int)this.grX.get(0));
                        int n4 = Math.min(rectangle.x + rectangle.width, (int)this.grX.get(this.grX.getLength() - 1));
                        int n5 = n3;
                        int n6 = (int)this.spline.getResult(n3);
                        for (int i = n3 + 1; i < n4; i += 3) {
                            int n7 = i;
                            int n8 = (int)this.spline.getResult(i);
                            graphics2D.drawLine(n5, n6, n7, n8);
                            n5 = n7;
                            n6 = n8;
                        }
                        break;
                    }
                }
                if (this.coverAllXRange) {
                    Point point = this.segmentPoints.get(0).toGraphicDomain();
                    graphics2D.drawLine(rectangle.x, point.y, point.x, point.y);
                    point = this.segmentPoints.get(this.getNumberOfPoints() - 1).toGraphicDomain();
                    graphics2D.drawLine(point.x, point.y, rectangle.x + rectangle.width, point.y);
                }
                if (this.pointsVisible) {
                    for (n = 0; n < this.segmentPoints.size(); ++n) {
                        Point point = this.segmentPoints.get(n).toGraphicDomain();
                        if (n == this.activePointIndex && this.highlightActivePoint) {
                            graphics2D.setColor(Color.red);
                            graphics2D.drawRect(point.x - 4, point.y - 4, 8, 8);
                        } else {
                            graphics2D.setColor(this.color);
                        }
                        graphics2D.fillRect(point.x - 2, point.y - 2, 5, 5);
                        double d = this.getPointY(n);
                        NumberFormat numberFormat = NumberFormat.getInstance();
                        numberFormat.setMaximumFractionDigits(3);
                        numberFormat.setGroupingUsed(false);
                        String string = numberFormat.format(d);
                        AChannelPlotter.paintText(graphics2D, string, 10, point.x, d > 0.5 ? point.y + 10 : point.y - 10, false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class FPoint {
        public double x;
        public double y;

        public FPoint() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public FPoint(FPoint fPoint) {
            this.x = fPoint.x;
            this.y = fPoint.y;
        }

        public FPoint(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        private void toSampleDomain(Point point) {
            AChannelPlotter aChannelPlotter = GEditableSegments.this.actualChannel.getPlotter();
            this.x = aChannelPlotter.graphToSampleX(point.x);
            switch (GEditableSegments.this.yDomain) {
                case 2: {
                    this.y = aChannelPlotter.graphToPercentY(point.y);
                    break;
                }
                default: {
                    this.y = aChannelPlotter.graphToSampleY(point.y);
                }
            }
        }

        private Point toGraphicDomain() {
            int n;
            AChannelPlotter aChannelPlotter = GEditableSegments.this.actualChannel.getPlotter();
            int n2 = aChannelPlotter.sampleToGraphX(this.x);
            switch (GEditableSegments.this.yDomain) {
                case 2: {
                    n = aChannelPlotter.percentToGraphY((float)this.y);
                    break;
                }
                default: {
                    n = aChannelPlotter.sampleToGraphY((float)this.y);
                }
            }
            return new Point(n2, n);
        }

        private int getGraphSquareDistance(FPoint fPoint) {
            Point point = this.toGraphicDomain();
            Point point2 = fPoint.toGraphicDomain();
            return (int)(Math.pow(point.x - point2.x, 2.0) + Math.pow(point.y - point2.y, 2.0));
        }

        private double getSampleXDistance(FPoint fPoint) {
            return Math.abs(this.x - fPoint.x);
        }

        private void limitRange() {
            if (this.x > GEditableSegments.this.xMax) {
                this.x = GEditableSegments.this.xMax;
            } else if (this.x < GEditableSegments.this.xMin) {
                this.x = GEditableSegments.this.xMin;
            }
            if (this.y > GEditableSegments.this.yMax) {
                this.y = GEditableSegments.this.yMax;
            } else if (this.y < GEditableSegments.this.yMin) {
                this.y = GEditableSegments.this.yMin;
            }
        }
    }
}

