/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GToolkit;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class LProgressViewer
extends JFrame
implements Runnable {
    private JPanel panel;
    private JLabel note;
    private JProgressBar progress;
    private JToggleButton cancel;
    private String title;
    private static LProgressViewer instance = null;
    private volatile boolean started = false;
    private final Timer startTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    });
    private final Timer finishTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LProgressViewer.this.setVisible(false);
            LProgressViewer.this.finishTimer.stop();
            LProgressViewer.this.refresh();
        }
    });
    private long timeStamp;
    private ArrayList<SubProgress> progressChain = new ArrayList();
    private volatile double totalProgress;
    private volatile String totalNote;
    private volatile int dotStep = 0;

    private LProgressViewer() {
        this.setDefaultCloseOperation(1);
        this.panel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(this.panel, 10, 3);
        uiCartesianLayout.setPreferredCellSize(new Dimension(35, 25));
        this.panel.setLayout(uiCartesianLayout);
        this.note = new JLabel("...", 0);
        uiCartesianLayout.add(this.note, 0, 0, 10, 1);
        this.progress = new JProgressBar(0, 0, 100);
        this.progress.setStringPainted(true);
        uiCartesianLayout.add(this.progress, 0, 1, 10, 1);
        this.cancel = new JToggleButton(GLanguage.translate("cancel"));
        uiCartesianLayout.add(this.cancel, 3, 2, 4, 1);
        this.getContentPane().add(this.panel);
        this.pack();
        this.setLocation((int)(this.getToolkit().getScreenSize().getWidth() - (double)this.getWidth()) / 2, (int)(this.getToolkit().getScreenSize().getHeight() - (double)this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(false);
    }

    public static LProgressViewer getInstance() {
        if (instance == null) {
            instance = new LProgressViewer();
        }
        return instance;
    }

    public void entrySubProgress(String string) {
        this.entrySubProgress(1.0, string);
    }

    public void entrySubProgress(double d) {
        this.entrySubProgress(d, "");
    }

    public void entrySubProgress(double d, String string) {
        this.entrySubProgress(d, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entrySubProgress(double d, String string, boolean bl) {
        if (this.progressChain.size() == 0 || !this.isVisible()) {
            LProgressViewer lProgressViewer = this;
            synchronized (lProgressViewer) {
                this.title = string;
                this.totalProgress = 0.0;
                this.totalNote = "";
                this.progressChain.clear();
                this.progressChain.add(new SubProgress(0.0, 1.0, ""));
                this.startTimer.start();
            }
            if (bl) {
                this.setTitle(GLanguage.translate(this.title) + "...");
                this.cancel.setSelected(false);
                this.setState(0);
                this.setVisible(true);
            }
            this.startTimer.stop();
            this.started = true;
            this.refresh();
        } else {
            LProgressViewer lProgressViewer = this;
            synchronized (lProgressViewer) {
                this.progressChain.add(new SubProgress(0.0, d, string));
            }
            if (this.isEnoughTimeElapsed()) {
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitSubProgress() {
        if (this.progressChain.size() == 1) {
            LProgressViewer lProgressViewer = this;
            synchronized (lProgressViewer) {
                this.started = false;
                this.startTimer.stop();
                this.finishTimer.start();
                this.progressChain.clear();
            }
            this.progress.setValue(100);
            this.progress.setString("100%");
            this.note.setText(GLanguage.translate("ok"));
            this.paintImmediately();
        } else {
            LProgressViewer lProgressViewer = this;
            synchronized (lProgressViewer) {
                if (this.progressChain.size() > 1) {
                    this.progressChain.get(this.progressChain.size() - 2).value += this.progressChain.get(this.progressChain.size() - 1).weight;
                    this.progressChain.remove(this.progressChain.size() - 1);
                }
            }
            if (this.isEnoughTimeElapsed()) {
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String string) {
        LProgressViewer lProgressViewer = this;
        synchronized (lProgressViewer) {
            if (this.progressChain.size() > 0) {
                this.progressChain.get(this.progressChain.size() - 1).note = string;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProgress(double d) {
        if (this.isEnoughTimeElapsed()) {
            LProgressViewer lProgressViewer = this;
            synchronized (lProgressViewer) {
                if (this.progressChain.size() > 0) {
                    this.progressChain.get(this.progressChain.size() - 1).value = Math.min(1.0, d);
                }
            }
            this.refresh();
            if (this.cancel.isSelected()) {
                lProgressViewer = this;
                synchronized (lProgressViewer) {
                    this.progressChain.clear();
                }
                this.setNote("canceled");
                this.finishTimer.start();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUnknownProgress() {
        if (this.isEnoughTimeElapsed()) {
            LProgressViewer lProgressViewer = this;
            synchronized (lProgressViewer) {
                if (this.progressChain.size() > 0) {
                    this.progressChain.get(this.progressChain.size() - 1).value = -1.0;
                }
            }
            this.refresh();
            if (this.cancel.isSelected()) {
                lProgressViewer = this;
                synchronized (lProgressViewer) {
                    this.progressChain.clear();
                }
                this.setNote("canceled");
                this.finishTimer.start();
                return true;
            }
        }
        return false;
    }

    private boolean isEnoughTimeElapsed() {
        long l = System.currentTimeMillis();
        if (l - this.timeStamp > 222L) {
            this.timeStamp = l;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        int n = 0;
        String string = "";
        LProgressViewer lProgressViewer = this;
        synchronized (lProgressViewer) {
            double d = 1.0;
            double d2 = 0.0;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.progressChain.size(); ++i) {
                d2 += (d *= this.progressChain.get(i).weight) * this.progressChain.get(i).value;
                stringBuffer.append(GLanguage.translate(this.progressChain.get(i).note));
                stringBuffer.append(" ");
            }
            this.totalProgress = Math.min(1.0, Math.max(this.totalProgress, d2));
            this.totalNote = stringBuffer.toString();
            if (this.progressChain.size() > 0 && this.progressChain.get(this.progressChain.size() - 1).value == -1.0) {
                n = 100;
                this.dotStep = (this.dotStep + 1) % 20;
                StringBuffer stringBuffer2 = new StringBuffer();
                if (this.dotStep < 10) {
                    for (int i = 0; i < this.dotStep; ++i) {
                        stringBuffer2.append("*");
                    }
                } else {
                    for (int i = 0; i < 20 - this.dotStep; ++i) {
                        stringBuffer2.append("*");
                    }
                }
                string = stringBuffer2.toString();
            } else {
                n = (int)(this.totalProgress * 100.0);
                string = "" + n + "%";
            }
        }
        this.progress.setValue(n);
        this.progress.setString(string);
        this.note.setText(this.totalNote);
        this.paintImmediately();
    }

    @Override
    public void run() {
    }

    private void paintImmediately() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cancel.setEnabled(false);
            this.panel.paintImmediately(0, 0, this.panel.getWidth(), this.panel.getHeight());
        } else {
            this.cancel.setEnabled(true);
            this.repaint();
        }
    }

    private static void f() {
        LProgressViewer.getInstance().entrySubProgress("work");
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(0.2);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(0.3);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().entrySubProgress(0.35, "phuu");
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(0.1);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(0.2);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(0.3);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(0.6);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().entrySubProgress(0.4, "uiuiui");
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(0.2);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(0.4);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 2000; ++i) {
            LProgressViewer.getInstance().setProgress(0.4 + 0.2 * (double)i / 2000.0);
            try {
                Thread.sleep(3L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LProgressViewer.getInstance().setProgress(0.8)) {
            return;
        }
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(1.0);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().exitSubProgress();
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setProgress(1.0);
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().exitSubProgress();
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().entrySubProgress(0.35, "phaaaaa");
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setUnknownProgress();
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setUnknownProgress();
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setUnknownProgress();
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().setUnknownProgress();
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 2000; ++i) {
            LProgressViewer.getInstance().setUnknownProgress();
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LProgressViewer.getInstance().setUnknownProgress();
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().exitSubProgress();
        try {
            Thread.sleep(666L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LProgressViewer.getInstance().exitSubProgress();
    }

    public static void main(String[] stringArray) {
        String string = GToolkit.getLaoeUserHomePath() + "laoe.properties";
        GPersistence.createPersistance(string);
        GLanguage.createLanguage("language");
        GLanguage.setLanguage("en", "");
        JFrame jFrame = new JFrame("test");
        JButton jButton = new JButton("hallo");
        jFrame.getContentPane().add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LProgressViewer.f();
            }
        });
        jFrame.setSize(new Dimension(300, 300));
        jFrame.setVisible(true);
    }

    private class SubProgress {
        private double value;
        private double weight;
        private String note;

        public SubProgress(double d, double d2, String string) {
            this.value = d;
            this.weight = d2;
            this.note = string;
        }
    }
}

