/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.SoundOutputStreamImpl;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.system.Log;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class GaplessSoundOutputStreamImpl
extends SoundOutputStreamImpl {
    public GaplessSoundOutputStreamImpl() {
    }

    public GaplessSoundOutputStreamImpl(AudioFormat audioFormat, AudioProcessor audioProcessor, File file, boolean bl, boolean bl2) {
        super(audioFormat, audioProcessor, file, bl, bl2);
    }

    @Override
    protected synchronized void openSourceLine() {
        try {
            if (this.audioFormat != null && (this.sourceLine == null || this.sourceLine != null && !this.sourceLine.getFormat().matches(this.audioFormat))) {
                this.closeSourceLine();
                this.closeAudioProcessor();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
                if (AudioSystem.isLineSupported(info)) {
                    this.sourceLine = (SourceDataLine)AudioSystem.getLine(info);
                    this.openAudioProcessor();
                } else {
                    Log.info("Audioformat is not supported");
                }
            }
            if (this.sourceLine != null) {
                if (!this.sourceLine.isOpen()) {
                    this.sourceLine.open();
                }
                if (!this.sourceLine.isRunning()) {
                    this.sourceLine.start();
                }
            }
        }
        catch (Exception exception) {
            this.sourceLine = null;
            Log.error("Error occured when opening audio device", exception);
        }
    }

    @Override
    public synchronized void open() {
        this.close();
        if (this.playDuringExport || this.exportFile == null) {
            this.openSourceLine();
        } else {
            this.openAudioProcessor();
        }
        this.openExportFile();
    }

    @Override
    public synchronized void close() {
        if (!this.playDuringExport && this.exportFile != null) {
            this.closeAudioProcessor();
        }
        this.closeExportFile();
    }

    @Override
    public synchronized void closeAllDevices() {
        super.close();
    }

    @Override
    public synchronized void changeAudioFormatTo(AudioFormat audioFormat) {
        if (this.audioFormat == null) {
            this.audioFormat = audioFormat;
        } else if (!this.audioFormat.matches(audioFormat)) {
            boolean bl = this.sourceLine != null && this.sourceLine.isOpen();
            this.closeSourceLine();
            this.audioFormat = audioFormat;
            if (bl) {
                this.openSourceLine();
            }
        }
    }
}

