/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class PowerPackerFile {
    private byte[] buffer;

    public PowerPackerFile(RandomAccessInputStream randomAccessInputStream) throws IOException {
        this.buffer = this.readAndUnpack(randomAccessInputStream);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public static boolean isPowerPacker(RandomAccessInputStream randomAccessInputStream) throws IOException {
        long l = randomAccessInputStream.getFilePointer();
        randomAccessInputStream.seek(0L);
        byte[] byArray = new byte[4];
        randomAccessInputStream.read(byArray, 0, 4);
        randomAccessInputStream.seek(l);
        return Helpers.retrieveAsString(byArray, 0, 4).equals("PP20");
    }

    private void pp20DoUnpack(RandomAccessInputStream randomAccessInputStream, byte[] byArray) throws IOException {
        BitBuffer bitBuffer = new BitBuffer(randomAccessInputStream, (int)randomAccessInputStream.getLength() - 4);
        randomAccessInputStream.seek(randomAccessInputStream.getLength() - 1L);
        int n = randomAccessInputStream.read();
        bitBuffer.getBits(n);
        int n2 = byArray.length;
        block0: while (n2 > 0) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (bitBuffer.getBits(1) == 0) {
                n6 = 1;
                while (n6 < n2) {
                    n5 = bitBuffer.getBits(2);
                    n6 += n5;
                    if (n5 != 3) break;
                }
                n5 = 0;
                while (n5 < n6) {
                    byArray[--n2] = (byte)bitBuffer.getBits(8);
                    ++n5;
                }
                if (n2 == 0) break;
            }
            n6 = bitBuffer.getBits(2) + 1;
            randomAccessInputStream.seek(n6 + 3);
            n5 = randomAccessInputStream.read();
            if (n6 == 4) {
                n4 = bitBuffer.getBits(bitBuffer.getBits(1) != 0 ? n5 : 7);
                while (n6 < n2) {
                    n3 = bitBuffer.getBits(3);
                    n6 += n3;
                    if (n3 == 7) {
                        continue;
                    }
                    break;
                }
            } else {
                n4 = bitBuffer.getBits(n5);
            }
            n3 = 0;
            while (n3 <= n6) {
                byte by = byArray[n2 - 1] = n2 + n4 < byArray.length ? byArray[n2 + n4] : (byte)0;
                if (--n2 == 0) continue block0;
                ++n3;
            }
        }
    }

    private byte[] readAndUnpack(RandomAccessInputStream randomAccessInputStream) throws IOException {
        randomAccessInputStream.seek(0L);
        int n = randomAccessInputStream.read() << 24 | randomAccessInputStream.read() << 16 | randomAccessInputStream.read() << 8 | randomAccessInputStream.read();
        int n2 = (int)randomAccessInputStream.getLength();
        if (n2 < 256 || n != 1347433008) {
            throw new IOException("Not a powerpacker file!");
        }
        randomAccessInputStream.seek(n2 - 4);
        int n3 = randomAccessInputStream.read() << 16 | randomAccessInputStream.read() << 8 | randomAccessInputStream.read();
        if (n3 < 512 || n3 > 0x400000 || n3 > n2 << 3) {
            throw new IOException("Length of " + n2 + " is not supported!");
        }
        byte[] byArray = new byte[n3];
        this.pp20DoUnpack(randomAccessInputStream, byArray);
        return byArray;
    }

    private static class BitBuffer {
        private RandomAccessInputStream source;
        private int filePointer;
        private int bitCount;
        private int bitBuffer;

        public BitBuffer(RandomAccessInputStream randomAccessInputStream, int n) {
            this.source = randomAccessInputStream;
            this.filePointer = n;
            this.bitCount = 0;
            this.bitBuffer = 0;
        }

        public int getBits(int n) throws IOException {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (this.bitCount == 0) {
                    this.bitCount = 8;
                    if (this.filePointer > 3) {
                        --this.filePointer;
                    }
                    this.source.seek(this.filePointer);
                    this.bitBuffer = this.source.read();
                }
                n2 = n2 << 1 | this.bitBuffer & 1;
                this.bitBuffer >>= 1;
                --this.bitCount;
                ++n3;
            }
            return n2;
        }
    }
}

