/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.applet;

import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.applet.Applet;
import java.awt.HeadlessException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class JavaModAppletBase
extends Applet
implements PlayThreadEventListener {
    private static final long serialVersionUID = 7586730327373678282L;
    protected URL[] modFileName = null;
    protected boolean shuffle;
    protected boolean repeat;
    protected boolean autostart;
    protected float initialVolume;
    protected MultimediaContainer currentContainer;
    protected PlayThread playerThread = null;
    protected PlayList currentPlayList = null;

    static {
        try {
            Helpers.registerAllClasses();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.error("JavaModMainBase: a class moved?!", classNotFoundException);
        }
    }

    @Override
    public void init() {
        try {
            this.parseParameters();
            this.initGui();
            this.loadMultimediaOrPlayListFile(this.modFileName);
            if (this.autostart) {
                this.doStartPlaying();
            }
        }
        catch (Exception exception) {
            Log.error("Error occured:", exception);
        }
    }

    @Override
    public abstract void playThreadEventOccured(PlayThread var1);

    protected abstract void setPlayListIcons();

    protected abstract void setNewSongName(String var1);

    protected abstract void initGui();

    protected PlayList getCurrentPlayList() {
        return this.currentPlayList;
    }

    public URL[] getModFileNames() {
        return this.modFileName;
    }

    public MultimediaContainer getCurrentContainer() {
        return this.currentContainer;
    }

    protected void parseParameters() {
        Properties properties = new Properties();
        String string = this.getParameter("i");
        if (string != null) {
            properties.setProperty("javamod.player.ISP", Integer.toString(Integer.parseInt(string)));
        }
        if ((string = this.getParameter("s")) != null) {
            properties.setProperty("javamod.player.stereo", string.charAt(0) == '+' ? "2" : "1");
        }
        if ((string = this.getParameter("w")) != null) {
            properties.setProperty("javamod.player.widestereomix", string.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((string = this.getParameter("n")) != null) {
            properties.setProperty("javamod.player.noisereduction", string.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((string = this.getParameter("l")) != null) {
            properties.setProperty("javamod.player.noloops", Integer.toString(Integer.parseInt(string)));
        }
        if ((string = this.getParameter("m")) != null) {
            properties.setProperty("javamod.player.megabass", string.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((string = this.getParameter("r")) != null) {
            properties.setProperty("javamod.player.frequency", Integer.toString(Integer.parseInt(string)));
        }
        if ((string = this.getParameter("h")) != null) {
            boolean bl = this.shuffle = string.charAt(0) == '+';
        }
        if ((string = this.getParameter("j")) != null) {
            boolean bl = this.repeat = string.charAt(0) == '+';
        }
        this.autostart = (string = this.getParameter("a")) != null ? string.charAt(0) == '+' : true;
        string = this.getParameter("v");
        this.initialVolume = string != null ? Float.parseFloat(string) : 1.0f;
        string = this.getParameter("b");
        if (string != null) {
            int n = Integer.parseInt(string);
            if (n != 8 && n != 16 && n != 24) {
                throw new RuntimeException("samplesize of " + n + " is not supported");
            }
            properties.setProperty("javamod.player.bitspersample", Integer.toString(n));
        }
        MultimediaContainerManager.configureContainer(properties);
        string = this.getParameter("file");
        try {
            if (string != null) {
                ArrayList<URL> arrayList = new ArrayList<URL>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    URL uRL = Helpers.createURLfromString(stringTokenizer.nextToken().trim());
                    if (uRL == null) continue;
                    arrayList.add(uRL);
                }
                this.modFileName = arrayList.toArray(new URL[arrayList.size()]);
            }
        }
        catch (Throwable throwable) {
            Log.error("[Applet::parseParameters]", throwable);
        }
    }

    protected Mixer createNewMixer() {
        Mixer mixer = this.currentContainer.createNewMixer();
        if (mixer != null) {
            mixer.setVolume(this.initialVolume);
        }
        return mixer;
    }

    protected void removeMixer() {
    }

    protected boolean loadMultimediaOrPlayListFile(URL[] uRLArray) {
        this.currentPlayList = null;
        try {
            this.currentPlayList = PlayList.createNewListWithFiles(uRLArray, this.shuffle, this.repeat);
            return this.doNextPlayListEntry();
        }
        catch (Throwable throwable) {
            Log.error("[Applet::loadMultimediaOrPlayListFile]", throwable);
            this.currentPlayList = null;
            return false;
        }
    }

    protected boolean loadMultimediaFile(URL uRL) {
        try {
            MultimediaContainer multimediaContainer;
            if (uRL != null && (multimediaContainer = MultimediaContainerManager.getMultimediaContainer(uRL)) != null) {
                this.currentContainer = multimediaContainer;
                this.setNewSongName(this.currentContainer.getSongName());
            }
        }
        catch (Throwable throwable) {
            Log.error("[Applet::loadMultimediaFile] Loading of " + uRL + " failed!", throwable);
            return false;
        }
        this.setPlayListIcons();
        if (this.playerThread != null) {
            this.doStartPlaying();
        }
        return true;
    }

    public boolean doNextPlayListEntry() {
        boolean bl = false;
        while (this.currentPlayList != null && this.currentPlayList.hasNext() && !bl) {
            this.currentPlayList.next();
            bl = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
        }
        return bl;
    }

    public boolean doPrevPlayListEntry() {
        boolean bl = false;
        while (this.currentPlayList != null && this.currentPlayList.hasPrevious() && !bl) {
            this.currentPlayList.previous();
            bl = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
        }
        return bl;
    }

    public void doStartPlaying() {
        if (this.currentContainer != null) {
            this.doStopPlaying();
            this.playerThread = new PlayThread(this.createNewMixer(), this);
            this.playerThread.start();
        }
    }

    public void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.playerThread = null;
            this.removeMixer();
        }
    }

    public void doPausePlaying() {
        if (this.playerThread != null) {
            this.playerThread.pausePlay();
        }
    }

    public void clearPlaylist() {
        this.currentPlayList = null;
        this.setPlayListIcons();
    }

    public void addFileToPlayList(String string) {
        URL uRL = Helpers.createURLfromString(string);
        if (uRL != null) {
            if (this.currentPlayList == null) {
                this.loadMultimediaOrPlayListFile(new URL[]{uRL});
            } else {
                this.currentPlayList.addEntry(new PlayListEntry(uRL, this.currentPlayList));
            }
        }
    }

    public void playFile(String string) {
        URL uRL = Helpers.createURLfromString(string);
        if (uRL != null) {
            this.loadMultimediaOrPlayListFile(new URL[]{uRL});
        }
    }
}

