/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.applet;

import de.quippy.javamod.main.applet.JavaModAppletBase;
import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.components.LEDScrollPanel;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class JavaModAppletGui
extends JavaModAppletBase {
    private static final long serialVersionUID = 1908155835317607193L;
    private JButton button_GIF = null;
    private LEDScrollPanel ledScrollPanel = null;
    protected URL guiFileName;
    private URL guiUrl = null;
    private Insets[] dim_Buttons = null;
    private Insets dim_LEDScroller = null;
    private Color dim_LEDScroller_light = null;
    private Color dim_LEDScroller_dark = null;
    private static final String PROPERTY_UI_URL = "ui.skin";
    private static final String PROPERTY_UI_LED = "ui.led";
    private static final String PROPERTY_UI_LED_LIGHTCOLOR = "ui.led.lightcolor";
    private static final String PROPERTY_UI_LED_DARKCOLOR = "ui.led.darkcolor";
    private static final String[] PROPERTY_UI_BUTTONS = new String[]{"ui.stop", "ui.pause", "ui.start", "ui.prev", "ui.next"};

    private JButton getButton_GIF() {
        if (this.button_GIF == null) {
            ImageIcon imageIcon = new ImageIcon(this.guiUrl);
            this.button_GIF = new JButton();
            this.button_GIF.setName("button_GIF");
            this.button_GIF.setText("");
            this.button_GIF.setFocusPainted(false);
            this.button_GIF.setBorderPainted(false);
            this.button_GIF.setIcon(imageIcon);
            this.button_GIF.setBounds(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
            this.button_GIF.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    boolean bl = false;
                    Point point = mouseEvent.getPoint();
                    int n = 0;
                    while (n < PROPERTY_UI_BUTTONS.length) {
                        if (point.x >= ((JavaModAppletGui)JavaModAppletGui.this).dim_Buttons[n].left && point.x <= ((JavaModAppletGui)JavaModAppletGui.this).dim_Buttons[n].right && point.y >= ((JavaModAppletGui)JavaModAppletGui.this).dim_Buttons[n].top && point.y <= ((JavaModAppletGui)JavaModAppletGui.this).dim_Buttons[n].bottom) {
                            JavaModAppletGui.this.button_GIF.setCursor(Cursor.getPredefinedCursor(12));
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        JavaModAppletGui.this.button_GIF.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            this.button_GIF.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = 0;
                    while (n < PROPERTY_UI_BUTTONS.length) {
                        if (point.x >= ((JavaModAppletGui)JavaModAppletGui.this).dim_Buttons[n].left && point.x <= ((JavaModAppletGui)JavaModAppletGui.this).dim_Buttons[n].right && point.y >= ((JavaModAppletGui)JavaModAppletGui.this).dim_Buttons[n].top && point.y <= ((JavaModAppletGui)JavaModAppletGui.this).dim_Buttons[n].bottom) {
                            switch (n) {
                                case 0: {
                                    JavaModAppletGui.this.doStopPlaying();
                                    break;
                                }
                                case 1: {
                                    JavaModAppletGui.this.doPausePlaying();
                                    break;
                                }
                                case 2: {
                                    JavaModAppletGui.this.doStartPlaying();
                                    break;
                                }
                                case 3: {
                                    JavaModAppletGui.this.doPrevPlayListEntry();
                                    break;
                                }
                                case 4: {
                                    JavaModAppletGui.this.doNextPlayListEntry();
                                }
                            }
                            break;
                        }
                        ++n;
                    }
                }
            });
        }
        return this.button_GIF;
    }

    public LEDScrollPanel getLEDScrollPanel() {
        if (this.ledScrollPanel == null) {
            Dimension dimension = new Dimension(this.dim_LEDScroller.right - this.dim_LEDScroller.left, this.dim_LEDScroller.bottom - this.dim_LEDScroller.top);
            int n = (int)(dimension.getWidth() / 6.0);
            this.ledScrollPanel = new LEDScrollPanel(30, "Java Mod Player V2.0 \u00a9 by Daniel Becker since 2006                  ", n, this.dim_LEDScroller_light, this.dim_LEDScroller_dark);
            this.ledScrollPanel.setBorder(BorderFactory.createEmptyBorder());
            this.ledScrollPanel.setBounds(this.dim_LEDScroller.left, this.dim_LEDScroller.top, this.dim_LEDScroller.right - this.dim_LEDScroller.left, this.dim_LEDScroller.bottom - this.dim_LEDScroller.top);
        }
        return this.ledScrollPanel;
    }

    @Override
    protected void parseParameters() {
        super.parseParameters();
        String string = this.getParameter("ui-properties");
        try {
            if (string != null) {
                this.guiFileName = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Log.error("[Applet::parseParameters]", malformedURLException);
        }
    }

    @Override
    public void initGui() {
        this.parseGuiFile(this.guiFileName);
        this.setLayout(null);
        this.add(this.getButton_GIF());
        this.add(this.getLEDScrollPanel());
    }

    private void parseGuiFile(URL uRL) {
        try {
            Properties properties = new Properties();
            properties.load(uRL.openStream());
            this.guiUrl = new URL(properties.getProperty(PROPERTY_UI_URL));
            this.dim_LEDScroller = Helpers.getInsetsFromString(properties.getProperty(PROPERTY_UI_LED, "0,0,0,0"));
            this.dim_LEDScroller_light = Helpers.getColorFromString(properties.getProperty(PROPERTY_UI_LED_LIGHTCOLOR, "0,0,0"));
            this.dim_LEDScroller_dark = Helpers.getColorFromString(properties.getProperty(PROPERTY_UI_LED_DARKCOLOR, "0,0,0"));
            this.dim_Buttons = new Insets[PROPERTY_UI_BUTTONS.length];
            int n = 0;
            while (n < PROPERTY_UI_BUTTONS.length) {
                this.dim_Buttons[n] = Helpers.getInsetsFromString(properties.getProperty(PROPERTY_UI_BUTTONS[n], "0,0,0,0"));
                ++n;
            }
        }
        catch (Throwable throwable) {
            Log.error("[JavaModAppletGui::parseGuiFile]", throwable);
        }
    }

    @Override
    public void doPausePlaying() {
        if (this.playerThread != null) {
            this.playerThread.pausePlay();
        } else {
            this.doStartPlaying();
        }
    }

    @Override
    public void playThreadEventOccured(PlayThread playThread) {
    }

    @Override
    protected void setPlayListIcons() {
    }

    @Override
    protected void setNewSongName(String string) {
        this.getLEDScrollPanel().setScrollTextTo(String.valueOf(string) + "     ");
    }
}

