/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class PlayerConfigPanel
extends JPanel {
    private static final long serialVersionUID = -923697640128200718L;
    private JTabbedPane tabbedPane = null;

    public PlayerConfigPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName("playerSetUpTabbedPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTabbedPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 10, 1.0, 1.0));
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1, 1);
            this.tabbedPane.setFont(Helpers.DIALOG_FONT);
            ArrayList<MultimediaContainer> arrayList = MultimediaContainerManager.getContainerArray();
            int n = 0;
            while (n < arrayList.size()) {
                MultimediaContainer multimediaContainer = arrayList.get(n);
                JPanel jPanel = multimediaContainer.getConfigPanel();
                if (jPanel != null) {
                    JScrollPane jScrollPane = new JScrollPane();
                    jScrollPane.setName("scrollPane_Config_" + multimediaContainer.getName());
                    jScrollPane.setViewportView(jPanel);
                    this.tabbedPane.add(multimediaContainer.getName(), jScrollPane);
                }
                ++n;
            }
        }
        return this.tabbedPane;
    }

    public void selectTabForContainer(MultimediaContainer multimediaContainer) {
        int n = 0;
        while (n < this.getTabbedPane().getTabCount()) {
            if (this.getTabbedPane().getTitleAt(n).equals(multimediaContainer.getName())) {
                this.getTabbedPane().setSelectedIndex(n);
                return;
            }
            ++n;
        }
    }
}

