/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.MeterPanelBase;
import de.quippy.javamod.mixer.dsp.FFT;
import de.quippy.javamod.system.FastMath;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SAMeterPanel
extends MeterPanelBase {
    private static final long serialVersionUID = 3032239961770238793L;
    private static final int FFT_SAMPLE_SIZE = 512;
    protected static final int DRAW_SA_METER = 0;
    protected static final int DRAW_WAVE_METER = 1;
    protected static final int DRAW_SK_METER = 2;
    private FFT fftCalc;
    private Color[] color;
    private Color[] SKcolor;
    private int SKMax;
    private float[] fftLevels;
    private float[] maxFFTLevels;
    private float[] floatSamples;
    private int anzSamples;
    private int bands;
    private int multiplier;
    private float rampDownValue;
    private float[] maxPeakLevelRampDownValue;
    private float maxPeakLevelRampDownDelay;
    private int myBottom;
    private float myHalfHeight;
    private int barWidth;
    private int drawWhat;
    private boolean switched;

    public SAMeterPanel(int n, int n2) {
        super(n);
        this.bands = n2;
        this.fftCalc = new FFT(512);
        this.multiplier = 256 / n2;
        this.fftLevels = new float[this.bands];
        this.maxFFTLevels = new float[this.bands];
        this.maxPeakLevelRampDownValue = new float[this.bands];
        this.drawWhat = 0;
        this.switched = true;
        this.prepareDisplayToggleListener();
        this.startThread();
    }

    private void prepareDisplayToggleListener() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    SAMeterPanel sAMeterPanel = SAMeterPanel.this;
                    sAMeterPanel.drawWhat = sAMeterPanel.drawWhat + 1;
                    if (SAMeterPanel.this.drawWhat > 2) {
                        SAMeterPanel.this.drawWhat = 0;
                    }
                    SAMeterPanel.this.switched = true;
                }
            }
        });
    }

    protected void setDrawWhatTo(int n) {
        this.drawWhat = n;
    }

    @Override
    protected void componentWasResized(int n, int n2, int n3, int n4) {
        this.rampDownValue = (float)this.getDesiredFPS() / 2000.0f;
        this.maxPeakLevelRampDownDelay = this.rampDownValue / 50.0f;
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            return;
        }
        this.myBottom = n + n4;
        this.myHalfHeight = (float)n4 / 2.0f;
        this.barWidth = n3 / this.bands;
        this.color = new Color[n4 + 1];
        int n5 = 0;
        while (n5 <= n4) {
            int n6 = n5 * 255 / n4;
            int n7 = 255 - n6;
            this.color[n5] = new Color(n6, n7, 0);
            ++n5;
        }
        this.SKMax = 1024;
        this.SKcolor = new Color[this.SKMax];
        n5 = 0;
        while (n5 < 256) {
            this.SKcolor[n5] = new Color(0, 0, n5);
            ++n5;
        }
        n5 = 256;
        while (n5 < 512) {
            this.SKcolor[n5] = new Color(0, n5 - 256, 511 - n5);
            ++n5;
        }
        n5 = 512;
        while (n5 < 768) {
            this.SKcolor[n5] = new Color(n5 - 512, 767 - n5, 0);
            ++n5;
        }
        n5 = 768;
        while (n5 < 1024) {
            this.SKcolor[n5] = new Color(255, n5 - 768, 0);
            ++n5;
        }
    }

    public void setMeter(float[] fArray) {
        if (fArray != null) {
            this.anzSamples = fArray.length;
            if (this.floatSamples == null || this.floatSamples.length != this.anzSamples) {
                this.floatSamples = new float[this.anzSamples];
            }
            System.arraycopy(fArray, 0, this.floatSamples, 0, this.anzSamples);
            float[] fArray2 = this.fftCalc.calculate(this.floatSamples);
            int n = 0;
            int n2 = 0;
            while (n2 < this.bands) {
                float f = fArray2[n];
                int n3 = 1;
                while (n3 < this.multiplier) {
                    f += fArray2[n + n3];
                    ++n3;
                }
                if ((f *= (float)FastMath.log(n2 + 2)) > 1.0f) {
                    f = 1.0f;
                }
                if (f > this.fftLevels[n2]) {
                    this.fftLevels[n2] = f;
                }
                n += this.multiplier;
                ++n2;
            }
        } else {
            this.floatSamples = null;
        }
    }

    @Override
    protected void drawMeter(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawMeter(graphics, n, n2, n3, n4, true);
    }

    protected void drawMeter(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        while (n5 < this.bands) {
            int n6 = n5;
            this.fftLevels[n6] = this.fftLevels[n6] - this.rampDownValue;
            if (this.fftLevels[n5] < 0.0f) {
                this.fftLevels[n5] = 0.0f;
            }
            int n7 = n5;
            this.maxFFTLevels[n7] = this.maxFFTLevels[n7] - this.maxPeakLevelRampDownValue[n5];
            if (this.maxFFTLevels[n5] < 0.0f) {
                this.maxFFTLevels[n5] = 0.0f;
            } else {
                int n8 = n5;
                this.maxPeakLevelRampDownValue[n8] = this.maxPeakLevelRampDownValue[n8] + this.maxPeakLevelRampDownDelay;
            }
            ++n5;
        }
        if (graphics == null) {
            return;
        }
        switch (this.drawWhat) {
            default: {
                this.drawSAMeter(graphics, n, n2, n3, n4, bl);
                break;
            }
            case 1: {
                this.drawWaveMeter(graphics, n, n2, n3, n4, bl);
                break;
            }
            case 2: {
                this.drawSKMeter(graphics, n, n2, n3, n4);
            }
        }
    }

    private void drawWaveMeter(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(n2, n, n3, n4);
        }
        graphics.setColor(Color.GREEN);
        graphics.drawLine(n2, n + (int)this.myHalfHeight, n2 + n3, n + (int)this.myHalfHeight);
        if (this.floatSamples == null) {
            return;
        }
        int n5 = this.anzSamples / n3 >> 1;
        if (n5 <= 0) {
            n5 = 1;
        }
        int n6 = 0;
        int n7 = (int)(this.myHalfHeight - this.floatSamples[0] * this.myHalfHeight);
        if (n7 < 0) {
            n7 = 0;
        } else if (n7 > n4) {
            n7 = n4;
        }
        graphics.setColor(Color.WHITE);
        int n8 = n5;
        while (n8 < this.anzSamples) {
            int n9 = n8 * n3 / this.anzSamples;
            if (n9 < 0) {
                n9 = 0;
            } else if (n9 > n3) {
                n9 = n3;
            }
            int n10 = (int)(this.myHalfHeight - this.floatSamples[n8] * this.myHalfHeight);
            if (n10 < 0) {
                n10 = 0;
            } else if (n10 > n4) {
                n10 = n4;
            }
            graphics.drawLine(n2 + n6, n + n7, n2 + n9, n + n10);
            n6 = n9;
            n7 = n10;
            n8 += n5;
        }
    }

    private void drawSAMeter(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(n2, n, n3, n4);
        }
        int n5 = 0;
        while (n5 < this.bands) {
            if (this.fftLevels[n5] > this.maxFFTLevels[n5]) {
                this.maxFFTLevels[n5] = this.fftLevels[n5];
                this.maxPeakLevelRampDownValue[n5] = this.maxPeakLevelRampDownDelay;
            }
            int n6 = n5 * this.barWidth;
            int n7 = n6 + this.barWidth - 2;
            int n8 = (int)((float)n4 * this.fftLevels[n5]);
            int n9 = (int)((float)n4 * this.maxFFTLevels[n5]);
            int n10 = n8;
            int n11 = this.myBottom - n8;
            while (n11 < this.myBottom) {
                graphics.setColor(this.color[n10--]);
                graphics.drawLine(n2 + n6, n + n11, n2 + n7, n + n11);
                ++n11;
            }
            if (n9 > n8) {
                graphics.setColor(this.color[n9]);
                graphics.drawLine(n2 + n6, n + this.myBottom - n9, n2 + n7, n + this.myBottom - n9);
            }
            ++n5;
        }
    }

    private void drawSKMeter(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.switched) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(n2, n, n3, n4);
            this.switched = false;
        }
        graphics.copyArea(n2, n, n3 - 1, n4, 1, 0);
        int n5 = this.bands - 1;
        int n6 = 0;
        while (n6 <= n5) {
            int n7 = n4 * (n5 - n6) / this.bands;
            graphics.setColor(this.SKcolor[(int)((float)(this.SKMax - 1) * this.fftLevels[n6])]);
            graphics.drawLine(n2, n + n7, n2, n + n7 + 2);
            ++n6;
        }
    }
}

