/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.system.Log;

public abstract class BasicMixer
extends Mixer {
    private static final int ISNOTHING = 0;
    private static final int ISDOING = 1;
    private static final int ISDONE = 2;
    private int paused;
    private int stopped;
    private int seeking;
    private long seekPosition;
    private boolean hasFinished;

    public BasicMixer() {
        this.setIsStopped();
    }

    @Override
    public boolean isPaused() {
        return this.paused == 2;
    }

    @Override
    public boolean isPausing() {
        return this.paused == 1;
    }

    @Override
    public boolean isStopped() {
        return this.stopped == 2;
    }

    @Override
    public boolean isStopping() {
        return this.stopped == 1;
    }

    @Override
    public boolean isNotPausingNorPaused() {
        return this.paused == 0;
    }

    @Override
    public boolean isNotStoppingNorStopped() {
        return this.stopped == 0;
    }

    @Override
    public boolean isPlaying() {
        return !this.isStopped();
    }

    @Override
    public boolean hasFinished() {
        return this.hasFinished;
    }

    protected void setIsPausing() {
        this.paused = 1;
        this.stopped = 0;
        this.seeking = 0;
    }

    protected void setIsPaused() {
        this.paused = 2;
        this.stopped = 0;
        this.seeking = 0;
    }

    protected void setIsStopping() {
        this.paused = 0;
        this.stopped = 1;
        this.seeking = 0;
    }

    protected void setIsStopped() {
        this.paused = 0;
        this.stopped = 2;
        this.seeking = 0;
    }

    protected void setIsPlaying() {
        this.paused = 0;
        this.stopped = 0;
        this.seeking = 0;
    }

    protected void setHasFinished() {
        this.hasFinished = true;
    }

    protected abstract void seek(long var1);

    protected long getSeekPosition() {
        return this.seekPosition;
    }

    @Override
    public boolean isNotSeeking() {
        return this.seeking == 0;
    }

    @Override
    public boolean isInSeeking() {
        return this.seeking != 0;
    }

    @Override
    public boolean isSeeking() {
        return this.seeking == 2;
    }

    public void setIsSeeking() {
        this.seeking = 2;
    }

    @Override
    public void setMillisecondPosition(long l) {
        if (!this.isPlaying()) {
            this.seekPosition = l;
        } else if (this.isNotSeeking()) {
            try {
                try {
                    this.seeking = 1;
                    while (this.seeking == 1) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.seek(l);
                }
                catch (Exception exception) {
                    Log.error("[BasicMixer]", exception);
                    this.seeking = 0;
                }
            }
            finally {
                this.seeking = 0;
            }
        }
    }

    @Override
    public void stopPlayback() {
        if (this.isNotStoppingNorStopped()) {
            this.setIsStopping();
            while (!this.isStopped()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.stopLine();
        }
    }

    @Override
    public void pausePlayback() {
        if (this.isNotPausingNorPaused() && this.isNotStoppingNorStopped()) {
            this.setIsPausing();
            while (!this.isPaused() && !this.isStopped()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.stopLine();
        } else if (this.isPaused()) {
            this.startLine();
            this.setIsPlaying();
        }
    }
}

