/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp;

import de.quippy.javamod.mixer.dsp.DSPEffekt;
import de.quippy.javamod.mixer.dsp.DspProcessorCallBack;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;

public class AudioProcessor {
    private final Object lock = new Object();
    private final int desiredBufferSize;
    private final long waitForNanos;
    private final ArrayList<DspProcessorCallBack> callBacks;
    private final ArrayList<DSPEffekt> effectCallBacks;
    private static final int SAMPLEBUFFERSIZE = 96000;
    private SourceDataLine sourceDataLine;
    private volatile long internalFramePosition;
    private volatile boolean useInternalCounter;
    private int sampleBufferSize;
    private float[] sampleBuffer;
    private byte[] resultSampleBuffer;
    private int currentWritePosition;
    private ProcessorTask processorThread;
    private AudioFormat audioFormat;
    private boolean isBigEndian;
    private boolean isSigned;
    private int sampleSizeInBits;
    private int bytesPerChannel;
    private int mask;
    private int neg_Bit;
    private int neg_mask;
    private int minSample;
    private int maxSample;
    private boolean dspEnabled;

    public AudioProcessor(int n, int n2) {
        this.desiredBufferSize = n;
        this.waitForNanos = 1000000000L / (long)n2;
        this.callBacks = new ArrayList();
        this.effectCallBacks = new ArrayList();
        this.dspEnabled = true;
    }

    public AudioProcessor() {
        this(1024, 70);
    }

    public void addListener(DspProcessorCallBack dspProcessorCallBack) {
        this.callBacks.add(dspProcessorCallBack);
    }

    public void removeListener(DspProcessorCallBack dspProcessorCallBack) {
        this.callBacks.remove(dspProcessorCallBack);
    }

    private void fireCurrentSampleChanged(float[] fArray, float[] fArray2) {
        int n = this.callBacks.size();
        int n2 = 0;
        while (n2 < n) {
            this.callBacks.get(n2).currentSampleChanged(fArray, fArray2);
            ++n2;
        }
    }

    public void addEffectListener(DSPEffekt dSPEffekt) {
        this.effectCallBacks.add(dSPEffekt);
    }

    public void removeEffectListener(DSPEffekt dSPEffekt) {
        this.effectCallBacks.remove(dSPEffekt);
    }

    private void initializeEffects(AudioFormat audioFormat, int n) {
        int n2 = this.effectCallBacks.size();
        int n3 = 0;
        while (n3 < n2) {
            this.effectCallBacks.get(n3).initialize(audioFormat, n);
            ++n3;
        }
    }

    private int callEffects(float[] fArray, int n, int n2) {
        int n3 = this.effectCallBacks.size();
        int n4 = n2;
        int n5 = 0;
        while (n5 < n3) {
            n4 = this.effectCallBacks.get(n5).doEffekt(fArray, n, n4);
            ++n5;
        }
        return n4;
    }

    public void setUseInternalCounter(boolean bl) {
        this.useInternalCounter = bl;
    }

    public void setInternalFramePosition(long l) {
        this.internalFramePosition = l;
    }

    public void initializeProcessor(SourceDataLine sourceDataLine) {
        this.sourceDataLine = sourceDataLine;
        this.initializeProcessor(sourceDataLine.getFormat());
    }

    public void initializeProcessor(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
        this.isBigEndian = audioFormat.isBigEndian();
        this.isSigned = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        this.sampleSizeInBits = audioFormat.getSampleSizeInBits();
        this.bytesPerChannel = this.sampleSizeInBits >> 3;
        this.mask = (1 << this.sampleSizeInBits) - 1;
        this.neg_Bit = 1 << this.sampleSizeInBits - 1;
        this.maxSample = this.neg_Bit - 1;
        this.minSample = -this.neg_Bit;
        this.neg_mask = 0xFFFFFFFF ^ this.mask;
        this.sampleBufferSize = this.sourceDataLine == null ? 96000 : this.sourceDataLine.getBufferSize();
        this.sampleBuffer = new float[this.sampleBufferSize];
        this.resultSampleBuffer = new byte[this.sampleBufferSize * this.bytesPerChannel];
        this.currentWritePosition = 0;
        this.internalFramePosition = 0L;
        this.useInternalCounter = false;
        this.initializeEffects(audioFormat, this.sampleBufferSize);
        this.processorThread = new ProcessorTask(this);
        this.processorThread.start();
    }

    public void stop() {
        if (this.processorThread != null) {
            this.processorThread.stopProcessorTask();
            this.processorThread = null;
            this.sampleBuffer = null;
        }
    }

    public boolean isDspEnabled() {
        return this.dspEnabled;
    }

    public void setDspEnabled(boolean bl) {
        this.dspEnabled = bl;
    }

    public byte[] getResultSampleBuffer() {
        return this.resultSampleBuffer;
    }

    private int writeIntoFloatArrayBuffer(int n) {
        int n2 = 0;
        int n3 = this.currentWritePosition;
        while (n2 < n) {
            int n4;
            int n5;
            int n6 = 0;
            if (this.isBigEndian) {
                n5 = this.bytesPerChannel - 1;
                n4 = 0;
                while (n5 >= 0) {
                    n6 |= (this.resultSampleBuffer[n2 + n5] & 0xFF) << n4;
                    --n5;
                    n4 += 8;
                }
            } else {
                n5 = 0;
                n4 = 0;
                while (n5 < this.bytesPerChannel) {
                    n6 |= (this.resultSampleBuffer[n2 + n5] & 0xFF) << n4;
                    ++n5;
                    n4 += 8;
                }
            }
            if (this.isSigned) {
                if ((n6 & this.neg_Bit) != 0) {
                    n6 |= this.neg_mask;
                }
            } else {
                n6 = (n6 & this.mask) - this.neg_Bit;
            }
            this.sampleBuffer[n3++ % this.sampleBufferSize] = (float)n6 / (float)this.neg_Bit;
            n2 += this.bytesPerChannel;
        }
        return n3 - this.currentWritePosition;
    }

    private int readFromFloatArrayBuffer(int n) {
        int n2 = this.currentWritePosition;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6;
            int n7;
            if ((n7 = (int)(this.sampleBuffer[n2++ % this.sampleBufferSize] * (float)this.neg_Bit)) > this.maxSample) {
                n7 = this.maxSample;
            } else if (n7 < this.minSample) {
                n7 = this.minSample;
            }
            if (!this.isSigned) {
                n7 += this.neg_Bit;
            }
            if (this.isBigEndian) {
                n6 = this.bytesPerChannel - 1;
                n5 = 0;
                while (n6 >= 0) {
                    this.resultSampleBuffer[n3 + n6] = (byte)(n7 >> n5 & 0xFF);
                    --n6;
                    n5 += 8;
                }
            } else {
                n6 = 0;
                n5 = 0;
                while (n6 < this.bytesPerChannel) {
                    this.resultSampleBuffer[n3 + n6] = (byte)(n7 >> n5 & 0xFF);
                    ++n6;
                    n5 += 8;
                }
            }
            ++n4;
            n3 += this.bytesPerChannel;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeSampleData(byte[] byArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            System.arraycopy(byArray, n, this.resultSampleBuffer, 0, n2);
            int n3 = this.writeIntoFloatArrayBuffer(n2);
            if (this.dspEnabled) {
                n3 = this.callEffects(this.sampleBuffer, this.currentWritePosition, n3);
                n2 = this.readFromFloatArrayBuffer(n3);
            }
            this.currentWritePosition = (this.currentWritePosition + n3) % this.sampleBufferSize;
            return n2;
        }
    }

    public int writeSampleData(byte[] byArray) {
        return this.writeSampleData(byArray, 0, byArray.length);
    }

    private final class ProcessorTask
    extends Thread {
        private final AudioProcessor me;
        private final float[] leftBuffer;
        private final float[] rightBuffer;
        private final long nanoWait;
        private volatile boolean process;
        private volatile boolean process_alive;

        public ProcessorTask(AudioProcessor audioProcessor2) {
            this.me = audioProcessor2;
            this.leftBuffer = new float[this.me.desiredBufferSize];
            this.rightBuffer = new float[this.me.desiredBufferSize];
            this.process = true;
            this.nanoWait = audioProcessor2.waitForNanos;
            this.setDaemon(true);
            this.setName("AudioProcessor");
            this.setPriority(10);
        }

        public void stopProcessorTask() {
            this.process = false;
            while (this.process_alive) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.me.fireCurrentSampleChanged(null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.process_alive = true;
            while (this.process) {
                long l = System.nanoTime();
                Object object = AudioProcessor.this.lock;
                synchronized (object) {
                    int n = this.me.audioFormat.getChannels();
                    int n2 = (int)((this.me.useInternalCounter ? this.me.internalFramePosition : this.me.sourceDataLine.getLongFramePosition()) * (long)n % (long)this.me.sampleBufferSize);
                    int n3 = 0;
                    while (n3 < this.me.desiredBufferSize) {
                        if (n2 >= this.me.sampleBufferSize) {
                            n2 = 0;
                        }
                        if (n == 2) {
                            this.leftBuffer[n3] = this.me.sampleBuffer[n2++];
                            this.rightBuffer[n3] = this.me.sampleBuffer[n2++];
                        } else {
                            this.leftBuffer[n3] = this.rightBuffer[n3] = this.me.sampleBuffer[n2++];
                        }
                        ++n3;
                    }
                }
                this.me.fireCurrentSampleChanged(this.leftBuffer, this.rightBuffer);
                long l2 = this.nanoWait - (System.nanoTime() - l);
                if (l2 > 0L) {
                    try {
                        Thread.sleep(l2 / 1000000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.process_alive = false;
        }
    }
}

