/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp;

public class FFT {
    private static final int FRAC_BITS = 16;
    public static final int FRAC_FAC = 65536;
    private final long[] xre;
    private final long[] xim;
    private final float[] mag;
    private final long[] fftSin;
    private final long[] fftCos;
    private final int[] fftBr;
    private final int ss;
    private final int ss2;
    private final int nu;

    public FFT(int n) {
        this.ss = n;
        this.ss2 = this.ss >> 1;
        this.nu = (int)(Math.log(this.ss) / Math.log(2.0));
        this.xre = new long[this.ss];
        this.xim = new long[this.ss];
        this.mag = new float[this.ss2];
        this.fftSin = new long[this.nu * this.ss2];
        this.fftCos = new long[this.nu * this.ss2];
        this.fftBr = new int[this.ss];
        this.prepareFFTTables();
    }

    /*
     * Unable to fully structure code
     */
    private void prepareFFTTables() {
        var1_1 = this.ss2;
        var2_2 = this.nu - 1;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 1;
        ** GOTO lbl24
        {
            var6_6 = 1;
            while (var6_6 <= var1_1) {
                var7_7 = FFT.bitrev(var3_3 >> var2_2, this.nu);
                var9_8 = 3.141592653589793 * var7_7 * 2.0 / (double)this.ss;
                this.fftSin[var4_4] = (long)(Math.sin(var9_8) * 65536.0);
                this.fftCos[var4_4] = (long)(Math.cos(var9_8) * 65536.0);
                ++var3_3;
                ++var4_4;
                ++var6_6;
            }
            var3_3 += var1_1;
            do {
                if (var3_3 < this.ss) continue block0;
                var3_3 = 0;
                --var2_2;
                var1_1 >>= 1;
                ++var5_5;
lbl24:
                // 2 sources

            } while (var5_5 <= this.nu);
        }
        var3_3 = 0;
        while (var3_3 < this.ss) {
            this.fftBr[var3_3] = FFT.bitrev(var3_3, this.nu);
            ++var3_3;
        }
    }

    private static long longSqrt(long l) {
        int n = 64;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        while (n2 < 8) {
            long l4;
            l3 = l3 << 8 | l >> (n -= 8) & 0xFFL;
            long l5 = (l2 << 5) + 1L;
            int n3 = 0;
            while ((l4 = l3 - l5) >= 0L) {
                l3 = l4;
                l5 += 2L;
                ++n3;
            }
            l2 = (l2 << 4) + (long)n3;
            ++n2;
        }
        return l2;
    }

    private static int bitrev(int n, int n2) {
        int n3 = n;
        int n4 = 0;
        int n5 = 1;
        while (n5 <= n2) {
            int n6 = n3 >> 1;
            n4 = (n4 << 1) + n3 - (n6 << 1);
            n3 = n6;
            ++n5;
        }
        return n4;
    }

    public float[] calculate(float[] fArray) {
        int n;
        int n2 = fArray.length / this.ss;
        int n3 = this.ss2;
        int n4 = this.nu - 1;
        int n5 = 0;
        int n6 = 0;
        while (n5 < fArray.length) {
            this.xre[n6] = (long)(fArray[n5] * 65536.0f);
            this.xim[n6] = 0L;
            n5 += n2;
            ++n6;
        }
        n6 = 0;
        int n7 = 1;
        while (n7 <= this.nu) {
            n = 0;
            while (n < this.ss) {
                int n8 = 1;
                while (n8 <= n3) {
                    long l = this.fftCos[n6];
                    long l2 = this.fftSin[n6];
                    int n9 = n + n3;
                    long l3 = this.xre[n9] * l + this.xim[n9] * l2 >> 16;
                    long l4 = this.xim[n9] * l - this.xre[n9] * l2 >> 16;
                    this.xre[n9] = this.xre[n] - l3;
                    this.xim[n9] = this.xim[n] - l4;
                    int n10 = n;
                    this.xre[n10] = this.xre[n10] + l3;
                    int n11 = n++;
                    this.xim[n11] = this.xim[n11] + l4;
                    ++n6;
                    ++n8;
                }
                n += n3;
            }
            --n4;
            n3 >>= 1;
            ++n7;
        }
        n7 = 0;
        while (n7 < this.ss) {
            n = this.fftBr[n7];
            if (n > n7) {
                long l = this.xre[n7];
                long l5 = this.xim[n7];
                this.xre[n7] = this.xre[n];
                this.xim[n7] = this.xim[n];
                this.xre[n] = l;
                this.xim[n] = l5;
            }
            ++n7;
        }
        this.mag[0] = (float)(FFT.longSqrt(this.xre[0] * this.xre[0] + this.xim[0] * this.xim[0]) >> 16) / (float)this.ss;
        n7 = 1;
        while (n7 < this.ss2) {
            this.mag[n7] = (float)(FFT.longSqrt(this.xre[n7] * this.xre[n7] + this.xim[n7] * this.xim[n7]) << 1 >> 16) / (float)this.ss;
            ++n7;
        }
        return this.mag;
    }
}

