/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ape;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.tools.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;

public class APEMixer
extends BasicMixer {
    private URL apeFileURL;
    private File apeFile;
    private IAPEDecompress spAPEDecompress;
    private int blocksPerDecode;
    private int blockAlign;
    private int channels;
    private int bitsPerSample;
    private int sampleRate;
    private byte[] output;

    public APEMixer(URL uRL) {
        this.apeFileURL = uRL;
        this.initialize();
    }

    private void initialize() {
        try {
            this.apeFile = File.createFile(this.apeFileURL, "r");
            this.spAPEDecompress = IAPEDecompress.CreateIAPEDecompress(this.apeFile);
            this.blockAlign = this.spAPEDecompress.getApeInfoBlockAlign();
            this.channels = this.spAPEDecompress.getApeInfoChannels();
            this.bitsPerSample = this.spAPEDecompress.getApeInfoBitsPerSample();
            this.sampleRate = this.spAPEDecompress.getApeInfoSampleRate();
            this.blocksPerDecode = 250 * this.sampleRate / 1000;
            int n = this.blockAlign * this.blocksPerDecode;
            this.output = new byte[n];
            AudioFormat audioFormat = new AudioFormat(this.sampleRate, this.bitsPerSample, this.channels, true, false);
            this.setAudioFormat(audioFormat);
            this.openAudioDevice();
        }
        catch (Exception exception) {
            if (this.apeFile != null) {
                try {
                    this.apeFile.close();
                    this.apeFile = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
            Log.error("[APEMixer]", exception);
        }
    }

    @Override
    public int getChannelCount() {
        if (this.spAPEDecompress == null) {
            return 0;
        }
        return this.spAPEDecompress.getApeInfoChannels();
    }

    @Override
    public int getCurrentKBperSecond() {
        if (this.spAPEDecompress == null) {
            return 0;
        }
        try {
            return this.spAPEDecompress.getApeInfoDecompressCurrentBitRate();
        }
        catch (IOException iOException) {
            return this.spAPEDecompress.getApeInfoAverageBitrate();
        }
    }

    @Override
    public int getCurrentSampleFrequency() {
        if (this.spAPEDecompress == null) {
            return 0;
        }
        return this.spAPEDecompress.getApeInfoSampleRate() / 1000;
    }

    @Override
    public long getLengthInMilliseconds() {
        if (this.spAPEDecompress == null) {
            return 0L;
        }
        return this.spAPEDecompress.getApeInfoDecompressLengthMS();
    }

    @Override
    public long getMillisecondPosition() {
        if (this.spAPEDecompress == null) {
            return 0L;
        }
        return this.spAPEDecompress.getApeInfoDecompressCurrentMS();
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    protected void seek(long l) {
        try {
            this.spAPEDecompress.Seek((int)(l * (long)this.sampleRate / 1000L));
        }
        catch (Exception exception) {
            Log.error("[APEMixer]", exception);
        }
    }

    private void cleanUp() {
        if (this.spAPEDecompress != null) {
            this.spAPEDecompress = null;
        }
        if (this.apeFile != null) {
            try {
                this.apeFile.close();
                this.apeFile = null;
            }
            catch (IOException iOException) {
                Log.error("IGNORED", iOException);
            }
        }
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            try {
                int n = 0;
                do {
                    if ((n = this.spAPEDecompress.GetData(this.output, this.blocksPerDecode)) <= 0 || !this.isInitialized()) continue;
                    int n2 = n * this.blockAlign;
                    this.writeSampleDataToLine(this.output, 0, n2);
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (!this.isInSeeking()) continue;
                    this.setIsSeeking();
                    while (this.isInSeeking()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } while (n > 0);
                if (n <= 0) {
                    this.setHasFinished();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            this.cleanUp();
        }
    }
}

