/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.midi;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import java.io.File;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class MidiMixer
extends BasicMixer {
    private boolean capture;
    private Mixer.Info mixerInfo;
    private long seekPosition = 0L;
    private int bufferSize;
    private byte[] output;
    private int sampleSizeInBits;
    private int sampleSizeInBytes;
    private int channels;
    private int sampleRate;
    private TargetDataLine targetDataLine;
    private Sequence sequence;
    private Sequencer sequencer = null;
    private MidiDevice midiOutput = null;
    private MidiDevice.Info outputDeviceInfo;
    private File soundBankFile;

    public MidiMixer(Sequence sequence, MidiDevice.Info info, File file, boolean bl, Mixer.Info info2) {
        this.outputDeviceInfo = info;
        this.soundBankFile = file;
        this.sequence = sequence;
        this.capture = bl;
        this.mixerInfo = info2;
        this.targetDataLine = null;
        if (bl) {
            this.setAudioFormat(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false));
            this.channels = this.getAudioFormat().getChannels();
            this.sampleSizeInBits = this.getAudioFormat().getSampleSizeInBits();
            this.sampleSizeInBytes = this.sampleSizeInBits >> 3;
            this.sampleRate = (int)this.getAudioFormat().getSampleRate();
            this.bufferSize = 250 * this.channels * this.sampleSizeInBytes * this.sampleRate / 1000;
            this.bufferSize *= this.sampleSizeInBytes;
            this.output = new byte[this.bufferSize];
        }
    }

    private void initialize() {
        if (this.capture) {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.getAudioFormat());
            try {
                Control[] controlArray;
                if (this.mixerInfo != null) {
                    controlArray = AudioSystem.getMixer(this.mixerInfo);
                    this.targetDataLine = (TargetDataLine)controlArray.getLine(info);
                } else {
                    this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                }
                this.targetDataLine.open();
                controlArray = this.targetDataLine.getControls();
                int n = 0;
                while (n < controlArray.length) {
                    if (controlArray[n] instanceof CompoundControl) {
                        Control[] controlArray2 = ((CompoundControl)controlArray[n]).getMemberControls();
                        int n2 = 0;
                        while (n2 < controlArray2.length) {
                            if (controlArray2[n] instanceof BooleanControl && controlArray2[n].getType().getClass().getName().endsWith("BCT")) {
                                ((BooleanControl)controlArray2[n]).setValue(true);
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
                this.targetDataLine.close();
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.targetDataLine = null;
            }
        }
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    public long getMillisecondPosition() {
        if (this.sequencer != null) {
            return this.sequencer.getMicrosecondPosition() / 1000L;
        }
        return 0L;
    }

    @Override
    protected void seek(long l) {
        if (this.sequencer != null) {
            this.sequencer.setMicrosecondPosition(l * 1000L);
        } else {
            this.seekPosition = l;
        }
    }

    @Override
    public void setMillisecondPosition(long l) {
        this.seek(l);
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.sequence != null ? this.sequence.getMicrosecondLength() / 1000L : 0L;
    }

    @Override
    public int getChannelCount() {
        Sequence sequence;
        if (this.sequencer != null && (sequence = this.sequencer.getSequence()) != null) {
            return sequence.getTracks().length;
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        return 0;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return 44;
    }

    public void setNewOutputDevice(MidiDevice.Info info) {
        boolean bl = this.isPlaying();
        if (bl) {
            this.stopLine();
        }
        try {
            Object object;
            if (this.midiOutput != null) {
                this.midiOutput.close();
                this.midiOutput = null;
            }
            this.midiOutput = info != null ? MidiSystem.getMidiDevice(info) : MidiSystem.getMidiDevice(this.outputDeviceInfo);
            if (!this.midiOutput.isOpen()) {
                this.midiOutput.open();
            }
            if (this.midiOutput instanceof Synthesizer && this.soundBankFile != null && this.soundBankFile.length() != 0L) {
                try {
                    object = MidiSystem.getSoundbank(this.soundBankFile);
                    ((Synthesizer)this.midiOutput).loadAllInstruments((Soundbank)object);
                }
                catch (Exception exception) {
                    Log.error("Error occured when opening soundfont bank", exception);
                }
            }
            object = this.midiOutput.getReceiver();
            Transmitter transmitter = this.sequencer.getTransmitter();
            transmitter.setReceiver((Receiver)object);
            if (bl) {
                this.startLine();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            this.closeAudioDevice();
            Log.error("Error occured when opening midi device", midiUnavailableException);
        }
    }

    @Override
    protected void openAudioDevice() {
        if (this.capture && this.targetDataLine != null) {
            try {
                this.setKeepSilent(true);
                super.openAudioDevice();
                this.targetDataLine.open();
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.closeAudioDevice();
                Log.error("[MidiMixer]: TargetDataLine", lineUnavailableException);
            }
        } else {
            this.closeAudioDevice();
        }
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.addMetaEventListener(new MetaEventListener(){

                @Override
                public void meta(MetaMessage metaMessage) {
                    if (metaMessage.getType() == 47) {
                        MidiMixer.this.stopPlayback();
                    }
                }
            });
            this.sequencer.setSequence(this.sequence);
            this.sequencer.open();
            if (!(this.sequencer instanceof Synthesizer)) {
                this.setNewOutputDevice(this.outputDeviceInfo);
            }
        }
        catch (Exception exception) {
            Log.error("[MidiMixer]", exception);
        }
    }

    @Override
    protected void closeAudioDevice() {
        this.stopLine();
        if (this.midiOutput != null && this.midiOutput.isOpen()) {
            this.midiOutput.close();
        }
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.close();
        }
        this.midiOutput = null;
        this.sequencer = null;
        if (this.capture) {
            if (this.targetDataLine != null) {
                this.targetDataLine.close();
            }
            super.closeAudioDevice();
        } else {
            super.fullyCloseAudioDevice();
        }
    }

    @Override
    protected void startLine() {
        if (this.targetDataLine != null) {
            this.targetDataLine.start();
        }
        if (this.sequencer != null) {
            this.sequencer.start();
        }
    }

    @Override
    protected void stopLine() {
        if (this.sequencer != null) {
            this.sequencer.stop();
        }
        if (this.targetDataLine != null) {
            this.targetDataLine.stop();
        }
    }

    @Override
    protected boolean isInitialized() {
        if (this.capture && this.targetDataLine == null) {
            return false;
        }
        return this.sequencer != null;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        if (this.seekPosition > 0L) {
            this.seek(this.seekPosition);
        }
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                this.startLine();
                this.setIsPlaying();
                long l = 0L;
                do {
                    if (this.targetDataLine != null) {
                        int n;
                        int n2 = this.targetDataLine.available();
                        if (n2 > this.bufferSize) {
                            n2 = this.bufferSize;
                        }
                        if ((n = this.targetDataLine.read(this.output, 0, n2)) > 0) {
                            this.writeSampleDataToLine(this.output, 0, n);
                            this.setInternatFramePosition(l);
                            l += (long)(n / this.channels);
                        }
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.isStopping()) {
                        this.setIsStopped();
                    }
                    if (!this.isPausing()) continue;
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } while (this.isPlaying());
                this.setHasFinished();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
        }
    }
}

