/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public abstract class Module {
    private String fileName;
    private String trackerName;
    private String modID;
    private int modType;
    private String songName;
    private int nChannels;
    private int nInstruments;
    private int nSamples;
    private int nPattern;
    private int BPMSpeed;
    private int tempo;
    private InstrumentsContainer instrumentContainer;
    private PatternContainer patternContainer;
    private int songLength;
    private int[] arrangement;
    private boolean[] arrangementPositionPlayed;
    private int baseVolume;
    protected int songFlags;

    public Module() {
    }

    protected Module(String string) {
        this();
        this.fileName = string;
    }

    public Module loadModFile(String string) throws IOException {
        return this.loadModFile(new File(string));
    }

    public Module loadModFile(File file) throws IOException {
        return this.loadModFile(file.toURI().toURL());
    }

    public Module loadModFile(URL uRL) throws IOException {
        ModfileInputStream modfileInputStream = null;
        try {
            modfileInputStream = new ModfileInputStream(uRL);
            Module module = this.loadModFile(modfileInputStream);
            return module;
        }
        finally {
            if (modfileInputStream != null) {
                try {
                    modfileInputStream.close();
                }
                catch (Exception exception) {
                    Log.error("IGNORED", exception);
                }
            }
        }
    }

    public Module loadModFile(ModfileInputStream modfileInputStream) throws IOException {
        Module module = this.getNewInstance(modfileInputStream.getFileName());
        module.loadModFileInternal(modfileInputStream);
        return module;
    }

    public abstract boolean checkLoadingPossible(ModfileInputStream var1) throws IOException;

    protected abstract Module getNewInstance(String var1);

    protected abstract void loadModFileInternal(ModfileInputStream var1) throws IOException;

    public abstract BasicModMixer getModMixer(int var1, int var2, int var3);

    public abstract String[] getFileExtensionList();

    public abstract int getPanningValue(int var1);

    public abstract int getChannelVolume(int var1);

    public abstract int getFrequencyTable();

    public abstract boolean doFastSlides();

    public String toShortInfoString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTrackerName());
        stringBuilder.append(" mod with ").append(this.getNSamples()).append(" samples and ").append(this.getNChannels()).append(" channels using ");
        switch (this.getFrequencyTable()) {
            case 2: {
                stringBuilder.append("Protracker");
                break;
            }
            case 0: {
                stringBuilder.append("Scream Tracker");
                break;
            }
            case 4: {
                stringBuilder.append("Fast Tracker log");
                break;
            }
            case 8: {
                stringBuilder.append("Fast Tracker linear");
                break;
            }
            case 1: {
                stringBuilder.append("Impuls Tracker linear");
                break;
            }
            case 16: {
                stringBuilder.append("Impuls Tracker log");
            }
        }
        stringBuilder.append(" frequency table");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.toShortInfoString());
        stringBuilder.append("\n\nSong named: ");
        stringBuilder.append(this.getSongName()).append('\n');
        stringBuilder.append(this.getInstrumentContainer().toString());
        return stringBuilder.toString();
    }

    protected void allocArrangement(int n) {
        this.arrangement = new int[n];
        this.arrangementPositionPlayed = new boolean[n];
    }

    public int[] getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(int[] nArray) {
        this.arrangement = nArray;
    }

    public void cleanUpArrangement() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.songLength) {
            if (this.arrangement[n2 - n] >= this.nPattern) {
                ++n;
                System.arraycopy(this.arrangement, n2 + 1, this.arrangement, n2, this.arrangement.length - n2 - 1);
            }
            ++n2;
        }
        this.songLength -= n;
    }

    public void resetLoopRecognition() {
        int n = 0;
        while (n < this.arrangementPositionPlayed.length) {
            this.arrangementPositionPlayed[n] = false;
            ++n;
        }
        this.getPatternContainer().resetRowsPlayed();
    }

    public boolean isArrangementPositionPlayed(int n) {
        return this.arrangementPositionPlayed[n];
    }

    public void setArrangementPositionPlayed(int n) {
        this.arrangementPositionPlayed[n] = true;
    }

    public int getBPMSpeed() {
        return this.BPMSpeed;
    }

    protected void setBPMSpeed(int n) {
        this.BPMSpeed = n;
    }

    public InstrumentsContainer getInstrumentContainer() {
        return this.instrumentContainer;
    }

    protected void setInstrumentContainer(InstrumentsContainer instrumentsContainer) {
        this.instrumentContainer = instrumentsContainer;
    }

    public int getNChannels() {
        return this.nChannels;
    }

    protected void setNChannels(int n) {
        this.nChannels = n;
    }

    public int getNPattern() {
        return this.nPattern;
    }

    protected void setNPattern(int n) {
        this.nPattern = n;
    }

    public int getNInstruments() {
        return this.nInstruments;
    }

    protected void setNInstruments(int n) {
        this.nInstruments = n;
    }

    public int getNSamples() {
        return this.nSamples;
    }

    protected void setNSamples(int n) {
        this.nSamples = n;
    }

    public int getSongLength() {
        return this.songLength;
    }

    protected void setSongLength(int n) {
        this.songLength = n;
    }

    public String getSongName() {
        return this.songName;
    }

    protected void setSongName(String string) {
        this.songName = string;
    }

    public int getTempo() {
        return this.tempo;
    }

    protected void setTempo(int n) {
        this.tempo = n;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    protected void setTrackerName(String string) {
        this.trackerName = string;
    }

    public PatternContainer getPatternContainer() {
        return this.patternContainer;
    }

    protected void setPatternContainer(PatternContainer patternContainer) {
        this.patternContainer = patternContainer;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getModID() {
        return this.modID;
    }

    protected void setModID(String string) {
        this.modID = string;
    }

    public int getBaseVolume() {
        return this.baseVolume;
    }

    protected void setBaseVolume(int n) {
        this.baseVolume = n;
    }

    public int getSongFlags() {
        return this.songFlags;
    }

    protected void setSongFlags(int n) {
        this.songFlags = n;
    }

    public int getModType() {
        return this.modType;
    }

    protected void setModType(int n) {
        this.modType = n;
    }

    protected void readSampleData(Sample sample, int n, ModfileInputStream modfileInputStream) throws IOException {
        if (sample.length > 0) {
            sample.allocSampleData();
            if ((n & 0x14) == 20 || (n & 0x16) == 22) {
                ITDeCompressor iTDeCompressor = new ITDeCompressor(sample, (n & 0x16) == 22, modfileInputStream);
                iTDeCompressor.decompress16();
            } else if ((n & 0x10) == 16 || (n & 0x12) == 18) {
                ITDeCompressor iTDeCompressor = new ITDeCompressor(sample, (n & 0x12) == 18, modfileInputStream);
                iTDeCompressor.decompress8();
            } else {
                short s = 0;
                int n2 = 0;
                while (n2 < sample.length) {
                    short s2;
                    if ((n & 4) != 0) {
                        s2 = (short)modfileInputStream.readIntelWord();
                        if ((n & 2) != 0) {
                            s = s2 = (short)(s2 + s);
                        }
                        sample.sample[n2] = (n & 1) != 0 ? Helpers.promoteUnsigned16BitToSigned24Bit(s2) : Helpers.promoteSigned16BitToSigned24Bit(s2);
                    } else {
                        s2 = modfileInputStream.readByte();
                        if ((n & 2) != 0) {
                            s = s2 = (short)((byte)(s2 + s));
                        }
                        sample.sample[n2] = (n & 1) != 0 ? Helpers.promoteUnsigned8BitToSigned24Bit((byte)s2) : Helpers.promoteSigned8BitToSigned24Bit((byte)s2);
                    }
                    ++n2;
                }
            }
            sample.fixSampleLoops(this.getModType());
        }
    }

    private static class ITDeCompressor {
        private ModfileInputStream input;
        private byte[] sourceBuffer;
        private int sourceIndex;
        private int[] destBuffer;
        private int destIndex;
        private int anzSamples;
        private int bitsRemain;
        private boolean isIT215;

        public ITDeCompressor(Sample sample, boolean bl, ModfileInputStream modfileInputStream) {
            this.input = modfileInputStream;
            this.sourceBuffer = null;
            this.sourceIndex = 0;
            this.bitsRemain = 0;
            this.destBuffer = sample.sample;
            this.destIndex = 0;
            this.anzSamples = sample.length;
            this.isIT215 = bl;
        }

        private int readbits(int n) {
            long l = 0L;
            if (n <= this.bitsRemain) {
                l = this.sourceBuffer[this.sourceIndex] & (1 << n) - 1;
                int n2 = this.sourceIndex;
                this.sourceBuffer[n2] = (byte)(this.sourceBuffer[n2] >> n);
                this.bitsRemain -= n;
            } else {
                int n3 = n - this.bitsRemain;
                l = (long)this.sourceBuffer[this.sourceIndex++] & (long)((1 << this.bitsRemain) - 1);
                while (n3 > 8) {
                    l |= (long)(this.sourceBuffer[this.sourceIndex++] & 0xFF) << this.bitsRemain;
                    n3 -= 8;
                    this.bitsRemain += 8;
                }
                l |= (long)(this.sourceBuffer[this.sourceIndex] & (1 << n3) - 1) << this.bitsRemain;
                int n4 = this.sourceIndex;
                this.sourceBuffer[n4] = (byte)(this.sourceBuffer[n4] >> n3);
                this.bitsRemain = 8 - n3;
            }
            return (int)(l & 0xFFFFFFFFFFFFFFFFL);
        }

        private boolean readblock() throws IOException {
            if (this.input.available() == 0) {
                return false;
            }
            int n = this.input.readIntelWord();
            if (n == 0) {
                return false;
            }
            if (this.input.available() < n) {
                n = this.input.available();
            }
            this.sourceBuffer = new byte[n];
            this.input.read(this.sourceBuffer, 0, n);
            this.sourceIndex = 0;
            this.bitsRemain = 8;
            return true;
        }

        public boolean decompress8() throws IOException {
            while (this.anzSamples > 0) {
                if (!this.readblock()) {
                    return false;
                }
                int n = this.anzSamples < 32768 ? this.anzSamples : 32768;
                int n2 = 0;
                int n3 = 9;
                byte by = 0;
                byte by2 = 0;
                while (n2 < n) {
                    int n4;
                    int n5 = this.readbits(n3);
                    if (n3 < 7) {
                        if (n5 == 1 << n3 - 1) {
                            n5 = this.readbits(3) + 1;
                            n3 = n5 < n3 ? n5 : n5 + 1;
                            continue;
                        }
                    } else if (n3 < 9) {
                        n4 = (255 >> 9 - n3) - 4;
                        if (n5 > n4 && n5 <= n4 + 8) {
                            n3 = (n5 -= n4) < n3 ? n5 : n5 + 1;
                            continue;
                        }
                    } else if (n3 == 9) {
                        if ((n5 & 0x100) != 0) {
                            n3 = n5 + 1 & 0xFF;
                            continue;
                        }
                    } else {
                        return false;
                    }
                    if (n3 < 8) {
                        int n6 = 8 - n3;
                        n4 = (byte)(n5 << n6 & 0xFF);
                        n4 = (byte)(n4 >> n6);
                    } else {
                        n4 = (byte)(n5 & 0xFF);
                    }
                    by2 = (byte)(by2 + n4);
                    by = (byte)(by + by2);
                    this.destBuffer[this.destIndex++] = Helpers.promoteSigned8BitToSigned24Bit(this.isIT215 ? by : by2);
                    ++n2;
                }
                this.anzSamples -= n;
            }
            return true;
        }

        public boolean decompress16() throws IOException {
            while (this.anzSamples > 0) {
                if (!this.readblock()) {
                    return false;
                }
                int n = this.anzSamples < 16384 ? this.anzSamples : 16384;
                int n2 = 0;
                int n3 = 17;
                int n4 = 0;
                int n5 = 0;
                while (n2 < n) {
                    int n6;
                    int n7 = this.readbits(n3);
                    if (n3 < 7) {
                        if (n7 == 1 << n3 - 1) {
                            n7 = this.readbits(4) + 1;
                            n3 = n7 < n3 ? n7 : n7 + 1;
                            continue;
                        }
                    } else if (n3 < 17) {
                        n6 = (65535 >> 17 - n3) - 8;
                        if (n7 > n6 && n7 <= n6 + 16) {
                            n3 = (n7 -= n6) < n3 ? n7 : n7 + 1;
                            continue;
                        }
                    } else if (n3 == 17) {
                        if ((n7 & 0x10000) != 0) {
                            n3 = n7 + 1 & 0xFF;
                            continue;
                        }
                    } else {
                        return false;
                    }
                    if (n3 < 16) {
                        int n8 = 16 - n3;
                        n6 = (short)(n7 << n8 & 0xFFFF);
                        n6 = (short)(n6 >> n8);
                    } else {
                        n6 = (short)n7;
                    }
                    n5 = (short)(n5 + n6);
                    n4 = (short)(n4 + n5);
                    this.destBuffer[this.destIndex++] = Helpers.promoteSigned16BitToSigned24Bit(this.isIT215 ? n4 : n5);
                    ++n2;
                }
                this.anzSamples -= n;
            }
            return true;
        }
    }
}

