/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.Envelope;
import de.quippy.javamod.multimedia.mod.loader.instrument.Instrument;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.Pattern;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.multimedia.mod.loader.tracker.ScreamTrackerMod;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ImpulseTrackerMod
extends ScreamTrackerMod {
    private static final int[] autovibit2xm;
    private static final String[] MODFILEEXTENSION;
    private int special;
    private int[] channelVolume;

    static {
        int[] nArray = new int[8];
        nArray[1] = 3;
        nArray[2] = 1;
        nArray[3] = 4;
        nArray[4] = 2;
        autovibit2xm = nArray;
        MODFILEEXTENSION = new String[]{"it"};
        ModuleFactory.registerModule(new ImpulseTrackerMod());
    }

    public ImpulseTrackerMod() {
    }

    protected ImpulseTrackerMod(String string) {
        super(string);
    }

    @Override
    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    @Override
    public int getFrequencyTable() {
        return (this.songFlags & 0x10) != 0 ? 1 : 16;
    }

    @Override
    public int getChannelVolume(int n) {
        return this.channelVolume[n];
    }

    public int getSpecial() {
        return this.special;
    }

    private void readEnvelopeData(Envelope envelope, int n, ModfileInputStream modfileInputStream) throws IOException {
        long l = modfileInputStream.getFilePointer();
        envelope.setITType(modfileInputStream.readByteAsInt());
        int n2 = modfileInputStream.readByteAsInt();
        if (n2 > 25) {
            n2 = 25;
        }
        envelope.setNPoints(n2);
        envelope.setLoopStartPoint(modfileInputStream.readByteAsInt());
        envelope.setLoopEndPoint(modfileInputStream.readByteAsInt());
        envelope.setSustainStartPoint(modfileInputStream.readByteAsInt());
        envelope.setSustainEndPoint(modfileInputStream.readByteAsInt());
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = modfileInputStream.readByteAsInt() + n & 0xFF;
            nArray2[n3] = modfileInputStream.readIntelWord();
            ++n3;
        }
        envelope.setPosition(nArray2);
        envelope.setValue(nArray);
        modfileInputStream.seek(l + 82L);
    }

    @Override
    public boolean checkLoadingPossible(ModfileInputStream modfileInputStream) throws IOException {
        byte[] byArray = new byte[4];
        modfileInputStream.read(byArray, 0, 4);
        modfileInputStream.seek(0L);
        return Helpers.convertDWordToInt(byArray, 0) == 1229803597;
    }

    @Override
    protected Module getNewInstance(String string) {
        return new ImpulseTrackerMod(string);
    }

    @Override
    public void loadModFileInternal(ModfileInputStream modfileInputStream) throws IOException {
        int n;
        int[] nArray;
        int[] nArray2;
        Object object;
        int n2;
        this.setModType(8);
        byte[] byArray = new byte[4];
        modfileInputStream.read(byArray, 0, 4);
        this.setModID(Helpers.retrieveAsString(byArray, 0, 4));
        if (Helpers.convertDWordToInt(byArray, 0) != 1229803597) {
            throw new IOException("Unsupported IT Module!");
        }
        this.setSongName(modfileInputStream.readString(26));
        modfileInputStream.skip(2L);
        this.setSongLength(modfileInputStream.readIntelWord());
        this.setNInstruments(modfileInputStream.readIntelWord());
        this.setNSamples(modfileInputStream.readIntelWord());
        this.setNPattern(modfileInputStream.readIntelWord());
        this.version = modfileInputStream.readIntelWord();
        this.setTrackerName("Impulse Tracker V" + Helpers.getAsHex(this.version >> 8 & 0xF, 1) + "." + Helpers.getAsHex(this.version & 0xFF, 2));
        int n3 = modfileInputStream.readIntelWord();
        this.setTrackerName(String.valueOf(this.getTrackerName()) + " (cmwt: " + Helpers.getAsHex(n3 >> 8 & 0xF, 1) + "." + Helpers.getAsHex(n3 & 0xFF, 2) + ")");
        this.flags = modfileInputStream.readIntelWord();
        if ((this.flags & 8) != 0) {
            this.songFlags |= 0x10;
        }
        if ((this.flags & 0x10) != 0) {
            this.songFlags |= 4;
        }
        if ((this.flags & 0x20) != 0) {
            this.songFlags |= 8;
        }
        if ((this.flags & 0x80) != 0) {
            this.songFlags |= 1;
        }
        if ((this.flags & 0x1000) != 0) {
            this.songFlags |= 0x8000;
        }
        this.special = modfileInputStream.readIntelWord();
        this.setBaseVolume(modfileInputStream.readByteAsInt());
        modfileInputStream.skip(1L);
        this.setTempo(modfileInputStream.readByteAsInt());
        this.setBPMSpeed(modfileInputStream.readByteAsInt());
        modfileInputStream.skip(1L);
        modfileInputStream.skip(1L);
        modfileInputStream.skip(2L);
        modfileInputStream.skip(4L);
        modfileInputStream.skip(4L);
        this.isStereo = true;
        this.usePanningValues = true;
        this.panningValue = new int[64];
        int n4 = 0;
        while (n4 < 64) {
            n2 = modfileInputStream.readByteAsInt();
            this.panningValue[n4] = n2 == 100 || (n2 & 0x80) != 0 ? n2 << 2 : (n2 & 0x7F) << 2;
            ++n4;
        }
        this.channelVolume = new int[64];
        n4 = 0;
        while (n4 < 64) {
            this.channelVolume[n4] = modfileInputStream.readByteAsInt();
            if (this.channelVolume[n4] > 64) {
                this.channelVolume[n4] = 64;
            }
            ++n4;
        }
        this.allocArrangement(this.getSongLength());
        n4 = 0;
        while (n4 < this.getSongLength()) {
            this.getArrangement()[n4] = modfileInputStream.readByteAsInt();
            ++n4;
        }
        InstrumentsContainer instrumentsContainer = new InstrumentsContainer(this, this.getNInstruments(), this.getNSamples());
        this.setInstrumentContainer(instrumentsContainer);
        n2 = 0;
        while (n2 < this.getNInstruments()) {
            modfileInputStream.seek(192L + (long)this.getSongLength() + (long)(n2 << 2));
            modfileInputStream.seek(modfileInputStream.readIntelDWord());
            if (modfileInputStream.readMotorolaDWord() != 1229803593) {
                throw new IOException("Unsupported IT Instrument Header!");
            }
            object = new Instrument();
            ((Instrument)object).setDosFileName(modfileInputStream.readString(13));
            Envelope envelope = new Envelope();
            ((Instrument)object).setVolumeEnvelope(envelope);
            Envelope envelope2 = new Envelope();
            ((Instrument)object).setPanningEnvelope(envelope2);
            Envelope envelope3 = new Envelope();
            ((Instrument)object).setPitchEnvelope(envelope3);
            if (n3 < 512) {
                envelope.setITType(modfileInputStream.readByteAsInt());
                envelope.setLoopStartPoint(modfileInputStream.readByteAsInt());
                envelope.setLoopEndPoint(modfileInputStream.readByteAsInt());
                envelope.setSustainStartPoint(modfileInputStream.readByteAsInt());
                envelope.setSustainEndPoint(modfileInputStream.readByteAsInt());
                modfileInputStream.skip(2L);
                ((Instrument)object).setVolumeFadeOut(modfileInputStream.readIntelWord() << 6);
                ((Instrument)object).setGlobalVolume(64);
                ((Instrument)object).setNNA(modfileInputStream.readByteAsInt());
                ((Instrument)object).setDublicateNoteCheck(modfileInputStream.readByteAsInt());
                modfileInputStream.skip(4L);
            } else {
                ((Instrument)object).setNNA(modfileInputStream.readByteAsInt());
                ((Instrument)object).setDublicateNoteCheck(modfileInputStream.readByteAsInt());
                ((Instrument)object).setDublicateNoteAction(modfileInputStream.readByteAsInt());
                ((Instrument)object).setVolumeFadeOut(modfileInputStream.readIntelWord() << 6);
                ((Instrument)object).setPitchPanSeparation(modfileInputStream.readByteAsInt());
                ((Instrument)object).setPitchPanCenter(modfileInputStream.readByteAsInt());
                ((Instrument)object).setGlobalVolume(modfileInputStream.readByteAsInt() >> 1);
                ((Instrument)object).setDefaultPan(modfileInputStream.readByteAsInt());
                ((Instrument)object).setRandomVolumeVariation(modfileInputStream.readByteAsInt());
                ((Instrument)object).setRandomPanningVariation(modfileInputStream.readByteAsInt());
                modfileInputStream.skip(4L);
            }
            ((Instrument)object).setName(modfileInputStream.readString(26));
            if (n3 < 512) {
                modfileInputStream.skip(6L);
            } else {
                ((Instrument)object).setInitialFilterCutoff(modfileInputStream.readByteAsInt());
                ((Instrument)object).setInitialFilterResonance(modfileInputStream.readByteAsInt());
                modfileInputStream.skip(4L);
            }
            int[] nArray3 = new int[120];
            nArray2 = new int[120];
            int n5 = 0;
            while (n5 < 120) {
                nArray2[n5] = modfileInputStream.readByteAsInt();
                nArray3[n5] = modfileInputStream.readByteAsInt();
                ++n5;
            }
            ((Instrument)object).setIndexArray(nArray3);
            ((Instrument)object).setNoteArray(nArray2);
            if (n3 < 512) {
                int[] nArray4 = new int[25];
                nArray = new int[25];
                n = 0;
                while (n < 25) {
                    nArray4[n] = modfileInputStream.readByteAsInt();
                    nArray[n] = modfileInputStream.readByteAsInt();
                    ++n;
                }
                envelope.setNPoints(n);
                envelope.setPosition(nArray4);
                envelope.setValue(nArray);
            } else {
                this.readEnvelopeData(envelope, 0, modfileInputStream);
                this.readEnvelopeData(envelope2, 32, modfileInputStream);
                this.readEnvelopeData(envelope3, 32, modfileInputStream);
            }
            instrumentsContainer.setInstrument(n2, (Instrument)object);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.getNSamples()) {
            modfileInputStream.seek(192L + (long)this.getSongLength() + (long)(this.getNInstruments() << 2) + (long)(n2 << 2));
            modfileInputStream.seek(modfileInputStream.readIntelDWord());
            if (modfileInputStream.readMotorolaDWord() != 1229803603) {
                throw new IOException("Unsupported IT Sample Header!");
            }
            object = new Sample();
            ((Sample)object).setDosFileName(modfileInputStream.readString(13));
            ((Sample)object).setGlobalVolume(modfileInputStream.readByteAsInt());
            int n6 = modfileInputStream.readByteAsInt();
            ((Sample)object).setFlags(n6);
            int n7 = 0;
            if ((n6 & 0x10) == 16) {
                n7 |= 1;
            }
            if ((n6 & 0x20) == 32) {
                n7 |= 2;
            }
            if ((n6 & 0x40) == 64) {
                n7 |= 4;
            }
            if ((n6 & 0x80) == 128) {
                n7 |= 8;
            }
            ((Sample)object).setLoopType(n7);
            ((Sample)object).setVolume(modfileInputStream.readByteAsInt());
            ((Sample)object).setName(modfileInputStream.readString(26));
            int n8 = modfileInputStream.readByteAsInt();
            ((Sample)object).setCvT(n8);
            int n9 = modfileInputStream.readByteAsInt();
            if ((n9 & 0x80) == 0) {
                n9 = -1;
            } else if ((n9 = (n9 & 0x7F) << 1) > 128) {
                n9 = 128;
            }
            ((Sample)object).setPanning(n9);
            ((Sample)object).setLength(modfileInputStream.readIntelDWord());
            int n10 = modfileInputStream.readIntelDWord();
            int n11 = modfileInputStream.readIntelDWord();
            ((Sample)object).setRepeatStart(n10);
            ((Sample)object).setRepeatStop(n11);
            ((Sample)object).setRepeatLength(n11 - n10);
            ((Sample)object).setFineTune(0);
            ((Sample)object).setTranspose(0);
            int n12 = modfileInputStream.readIntelDWord();
            if (n12 == 0) {
                n12 = 8363;
            } else if (n12 < 256) {
                n12 = 256;
            }
            ((Sample)object).setBaseFrequency(n12);
            ((Sample)object).setSustainLoopStart(modfileInputStream.readIntelDWord());
            ((Sample)object).setSustainLoopEnd(modfileInputStream.readIntelDWord());
            n = modfileInputStream.readIntelDWord();
            ((Sample)object).setVibratoRate(modfileInputStream.readByteAsInt());
            ((Sample)object).setVibratoDepth(modfileInputStream.readByteAsInt() & 0x7F);
            ((Sample)object).setVibratoSweep(modfileInputStream.readByteAsInt() + 3 >> 2);
            ((Sample)object).setVibratoType(autovibit2xm[modfileInputStream.readByteAsInt() & 7]);
            if (n > 0 && ((Sample)object).length > 0) {
                int n13 = 0;
                if (n8 == 255 && (n6 & 2) != 2) {
                    n13 = 3;
                } else {
                    int n14 = n13 = (n8 & 1) == 1 ? 0 : 1;
                    if ((n6 & 2) == 2) {
                        n13 |= 4;
                    }
                    if ((n6 & 4) == 4) {
                        n13 |= 8;
                    }
                    if ((n6 & 8) == 8) {
                        n13 |= this.version >= 533 && (n8 & 4) == 4 ? 18 : 16;
                    }
                }
                modfileInputStream.seek(n);
                this.readSampleData((Sample)object, n13, modfileInputStream);
            }
            instrumentsContainer.setSample(n2, (Sample)object);
            ++n2;
        }
        PatternContainer patternContainer = new PatternContainer(this.getNPattern());
        this.setPatternContainer(patternContainer);
        int n15 = 0;
        int n16 = 0;
        while (n16 < this.getNPattern()) {
            modfileInputStream.seek(192 + this.getSongLength() + (this.getNInstruments() << 2) + (this.getNSamples() << 2) + (n16 << 2));
            modfileInputStream.seek(modfileInputStream.readIntelDWord());
            int n17 = modfileInputStream.readIntelWord();
            int n18 = modfileInputStream.readIntelWord();
            modfileInputStream.skip(4L);
            patternContainer.setPattern(n16, new Pattern(n18));
            int n19 = 0;
            while (n19 < n18) {
                patternContainer.setPatternRow(n16, n19, new PatternRow(64));
                int n20 = 0;
                while (n20 < 64) {
                    PatternElement patternElement = new PatternElement(n16, n19, n20);
                    patternContainer.setPatternElement(patternElement);
                    ++n20;
                }
                ++n19;
            }
            n19 = 0;
            nArray2 = new int[64];
            int[] nArray5 = new int[64];
            nArray = new int[64];
            int[] nArray6 = new int[64];
            int[] nArray7 = new int[64];
            int[] nArray8 = new int[64];
            int[] nArray9 = new int[64];
            while (n17 > 0) {
                int n21;
                int n22;
                int n23 = modfileInputStream.readByteAsInt();
                --n17;
                if (n23 == 0) {
                    ++n19;
                    continue;
                }
                int n24 = n23 - 1 & 0x3F;
                if (n24 > n15) {
                    n15 = n24;
                }
                PatternElement patternElement = patternContainer.getPatternElement(n16, n19, n24);
                if ((n23 & 0x80) != 0) {
                    nArray2[n24] = modfileInputStream.readByteAsInt();
                    --n17;
                }
                if ((nArray2[n24] & 1) != 0 || (nArray2[n24] & 0x10) != 0) {
                    if ((nArray2[n24] & 1) != 0) {
                        nArray5[n24] = modfileInputStream.readByteAsInt();
                        --n17;
                    }
                    if ((n22 = nArray5[n24]) == 255) {
                        n21 = -1;
                        n22 = -1;
                    } else if (n22 == 254) {
                        n21 = -2;
                        n22 = -2;
                    } else {
                        n21 = n22 < Helpers.noteValues.length ? Helpers.noteValues[n22] : 1;
                        ++n22;
                    }
                    patternElement.setNoteIndex(n22);
                    patternElement.setPeriod(n21);
                }
                if ((nArray2[n24] & 2) != 0 || (nArray2[n24] & 0x20) != 0) {
                    if ((nArray2[n24] & 2) != 0) {
                        nArray[n24] = modfileInputStream.readByteAsInt();
                        --n17;
                    }
                    patternElement.setInstrument(nArray[n24]);
                }
                if ((nArray2[n24] & 4) != 0 || (nArray2[n24] & 0x40) != 0) {
                    if ((nArray2[n24] & 4) != 0) {
                        n22 = modfileInputStream.readByteAsInt();
                        --n17;
                        n21 = 0;
                        int n25 = 0;
                        if (n22 <= 64) {
                            n21 = 1;
                            n25 = n22;
                        } else if (n22 >= 128 && n22 <= 192) {
                            n21 = 8;
                            n25 = n22 - 128;
                        } else if (n22 < 75) {
                            n21 = 5;
                            n25 = n22 - 65;
                        } else if (n22 < 85) {
                            n21 = 4;
                            n25 = n22 - 75;
                        } else if (n22 < 95) {
                            n21 = 3;
                            n25 = n22 - 85;
                        } else if (n22 < 105) {
                            n21 = 2;
                            n25 = n22 - 95;
                        } else if (n22 < 115) {
                            n21 = 13;
                            n25 = n22 - 105;
                        } else if (n22 < 125) {
                            n21 = 12;
                            n25 = n22 - 115;
                        } else if (n22 >= 193 && n22 <= 202) {
                            n21 = 11;
                            n25 = n22 - 193;
                        } else if (n22 >= 203 && n22 <= 212) {
                            n21 = 6;
                            n25 = n22 - 203;
                        }
                        nArray6[n24] = n21;
                        nArray7[n24] = n25;
                    }
                    patternElement.setVolumeEffekt(nArray6[n24]);
                    patternElement.setVolumeEffektOp(nArray7[n24]);
                }
                if ((nArray2[n24] & 8) == 0 && (nArray2[n24] & 0x80) == 0) continue;
                if ((nArray2[n24] & 8) != 0) {
                    nArray8[n24] = modfileInputStream.readByteAsInt();
                    --n17;
                    nArray9[n24] = modfileInputStream.readByteAsInt();
                    --n17;
                }
                patternElement.setEffekt(nArray8[n24]);
                patternElement.setEffektOp(nArray9[n24]);
            }
            ++n16;
        }
        if (n15 < 4) {
            n15 = 4;
        }
        this.setNChannels(n15 + 1);
        n16 = 0;
        int n26 = 0;
        while (n26 < this.getSongLength()) {
            if (this.getArrangement()[n26] == 255) break;
            if (this.getArrangement()[n26] < 254 && this.getArrangement()[n26] < this.getNPattern()) {
                this.getArrangement()[n16++] = this.getArrangement()[n26];
            }
            ++n26;
        }
        this.setSongLength(n16);
        this.cleanUpArrangement();
    }
}

