/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.multimedia.mod.mixer.ScreamTrackerMixer;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ScreamTrackerOldMod
extends Module {
    private static final String[] MODFILEEXTENSION = new String[]{"stm"};
    private int vHi;
    private int vLow;
    private int playBackTempo;
    private int STMType;

    static {
        ModuleFactory.registerModule(new ScreamTrackerOldMod());
    }

    public ScreamTrackerOldMod() {
    }

    protected ScreamTrackerOldMod(String string) {
        super(string);
    }

    @Override
    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    @Override
    public BasicModMixer getModMixer(int n, int n2, int n3) {
        return new ScreamTrackerMixer(this, n, n2, n3);
    }

    @Override
    public int getPanningValue(int n) {
        if (n % 3 != 0) {
            return 256;
        }
        return 0;
    }

    @Override
    public int getChannelVolume(int n) {
        return 64;
    }

    @Override
    public int getFrequencyTable() {
        return 0;
    }

    public int getPlayBackTempo() {
        return this.playBackTempo;
    }

    @Override
    public boolean doFastSlides() {
        return false;
    }

    private String getModType(String string) throws IOException {
        if (!string.equals("!Scream!")) {
            throw new IOException("Mod id: " + string + ": this is not a screamtracker mod");
        }
        this.setNSamples(31);
        this.setNChannels(4);
        return "ScreamTracker";
    }

    private PatternElement createNewPatternElement(int n, int n2, int n3, int n4) {
        int n5;
        PatternElement patternElement = new PatternElement(n, n2, n3);
        patternElement.setInstrument((n4 & 0xF80000) >> 19);
        int n6 = (n4 & 0xF0000000) >> 28;
        if (n6 != -1) {
            n5 = (n4 & 0xF000000) >> 24;
            int n7 = (n6 + 3) * 12 + n5;
            patternElement.setPeriod(n7 < Helpers.noteValues.length ? Helpers.noteValues[n7] : 0);
            patternElement.setNoteIndex(n7 + 1);
        } else {
            patternElement.setPeriod(0);
            patternElement.setNoteIndex(0);
        }
        patternElement.setEffekt((n4 & 0xF00) >> 8);
        patternElement.setEffektOp(n4 & 0xFF);
        if (patternElement.getEffekt() == 1) {
            n5 = patternElement.getEffektOp();
            patternElement.setEffektOp((n5 & 0xF) << 4 | (n5 & 0xF0) >> 4);
        }
        if ((n5 = (n4 & 0x70000) >> 16 | (n4 & 0xF000) >> 9) <= 64) {
            patternElement.setVolumeEffekt(1);
            patternElement.setVolumeEffektOp(n5);
        }
        return patternElement;
    }

    @Override
    public boolean checkLoadingPossible(ModfileInputStream modfileInputStream) throws IOException {
        modfileInputStream.seek(20L);
        String string = modfileInputStream.readString(8);
        modfileInputStream.seek(0L);
        return string.equals("!SCREAM!") || string.equals("!Scream!");
    }

    @Override
    protected Module getNewInstance(String string) {
        return new ScreamTrackerOldMod(string);
    }

    @Override
    public void loadModFileInternal(ModfileInputStream modfileInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        modfileInputStream.seek(20L);
        this.setTrackerName(this.getModType(modfileInputStream.readString(8)));
        modfileInputStream.seek(0L);
        this.setSongName(modfileInputStream.readString(20));
        this.setModID(modfileInputStream.readString(8));
        modfileInputStream.skip(1L);
        this.STMType = modfileInputStream.readByteAsInt();
        if (this.STMType != 2) {
            throw new IOException("Unsupported STM MOD (ID!=0x02)");
        }
        this.vHi = modfileInputStream.readByteAsInt();
        this.vLow = modfileInputStream.readByteAsInt();
        this.setTrackerName(String.valueOf(this.getTrackerName()) + " V" + this.vHi + '.' + this.vLow);
        this.playBackTempo = modfileInputStream.readByteAsInt();
        this.setTempo(6);
        this.setBPMSpeed(125);
        int n5 = modfileInputStream.readByteAsInt();
        if (n5 > 64) {
            n5 = 64;
        }
        this.setNPattern(n5);
        this.setBaseVolume(modfileInputStream.readByteAsInt() << 1);
        modfileInputStream.skip(13L);
        this.setNInstruments(this.getNSamples());
        InstrumentsContainer instrumentsContainer = new InstrumentsContainer(this, 0, this.getNSamples());
        this.setInstrumentContainer(instrumentsContainer);
        int n6 = 0;
        while (n6 < this.getNSamples()) {
            Sample sample = new Sample();
            sample.setName(modfileInputStream.readString(12));
            modfileInputStream.skip(1L);
            n4 = modfileInputStream.readByteAsInt();
            if (this.STMType == 1) {
                sample.setName(String.valueOf(sample.name) + " #" + n4);
            }
            modfileInputStream.skip(2L);
            sample.setLength(modfileInputStream.readIntelWord());
            n3 = modfileInputStream.readIntelWord();
            n2 = modfileInputStream.readIntelWord();
            if (n3 < n2 && n2 != 65535) {
                sample.setLoopType(1);
            } else {
                sample.setLoopType(0);
            }
            sample.setRepeatStart(n3);
            sample.setRepeatStop(n2);
            sample.setRepeatLength(n2 - n3);
            n = modfileInputStream.readByteAsInt() & 0x7F;
            sample.setVolume(n > 64 ? 64 : n);
            modfileInputStream.skip(1L);
            sample.setPanning(-1);
            sample.setFineTune(0);
            sample.setTranspose(0);
            sample.setBaseFrequency(modfileInputStream.readIntelWord());
            modfileInputStream.skip(4L);
            modfileInputStream.skip(2L);
            instrumentsContainer.setSample(n6, sample);
            ++n6;
        }
        this.allocArrangement(128);
        n6 = -1;
        int n7 = 0;
        while (n7 < 128) {
            this.getArrangement()[n7] = n4 = modfileInputStream.readByteAsInt();
            if (n6 == -1 && n4 == 99) {
                n6 = n7;
            }
            ++n7;
        }
        while (this.getArrangement()[n6 - 1] >= this.getNPattern()) {
            --n6;
        }
        this.setSongLength(n6);
        PatternContainer patternContainer = new PatternContainer(this.getNPattern(), 64, this.getNChannels());
        this.setPatternContainer(patternContainer);
        n4 = 0;
        while (n4 < this.getNPattern()) {
            n3 = 0;
            while (n3 < 64) {
                n2 = 0;
                while (n2 < this.getNChannels()) {
                    n = modfileInputStream.readMotorolaDWord();
                    patternContainer.setPatternElement(this.createNewPatternElement(n4, n3, n2, n));
                    ++n2;
                }
                ++n3;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.getNSamples()) {
            Sample sample = this.getInstrumentContainer().getSample(n4);
            this.readSampleData(sample, 0, modfileInputStream);
            ++n4;
        }
        this.cleanUpArrangement();
    }
}

