/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer;

import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.system.Helpers;

public class ScreamTrackerMixer
extends BasicModMixer {
    public ScreamTrackerMixer(Module module, int n, int n2, int n3) {
        super(module, n, n2, n3);
    }

    @Override
    protected void initializeMixer(int n, BasicModMixer.ChannelMemory channelMemory) {
        if (this.mod.getModType() == 8) {
            channelMemory.muted = (this.mod.getPanningValue(n) & 0x200) != 0;
            channelMemory.doSurround = this.mod.getPanningValue(n) == 400;
        }
    }

    @Override
    protected void resetAllEffects(BasicModMixer.ChannelMemory channelMemory, PatternElement patternElement, boolean bl) {
        if (channelMemory.arpegioIndex >= 0) {
            channelMemory.arpegioIndex = -1;
            int n = channelMemory.arpegioNote[0];
            if (n != 0) {
                channelMemory.currentNotePeriod = n;
                this.setNewPlayerTuningFor(channelMemory, channelMemory.currentNotePeriod);
            }
        }
        if (channelMemory.vibratoOn && (bl || patternElement.getEffekt() != 8 && patternElement.getEffekt() != 11 && patternElement.getEffekt() != 21)) {
            channelMemory.vibratoOn = false;
            if (!channelMemory.vibratoNoRetrig) {
                channelMemory.vibratoTablePos = 0;
            }
            this.setNewPlayerTuningFor(channelMemory);
        }
        if (channelMemory.tremoloOn && (bl || patternElement.getEffekt() != 18)) {
            channelMemory.tremoloOn = false;
            if (!channelMemory.tremoloNoRetrig) {
                channelMemory.tremoloTablePos = 0;
            }
        }
        if (channelMemory.panbrelloOn && (bl || patternElement.getEffekt() != 25)) {
            channelMemory.panbrelloOn = false;
            if (!channelMemory.panbrelloNoRetrig) {
                channelMemory.panbrelloTablePos = 0;
            }
        }
    }

    @Override
    protected void doRowEffects(BasicModMixer.ChannelMemory channelMemory) {
        if (channelMemory.effekt == 0 && channelMemory.effektParam == 0) {
            return;
        }
        block0 : switch (channelMemory.effekt) {
            case 1: {
                this.currentTick = this.currentTempo = channelMemory.effektParam;
                break;
            }
            case 2: {
                this.patternPosJumpPatternIndex = channelMemory.effektParam;
                break;
            }
            case 3: {
                this.patternBreakRowIndex = (channelMemory.effektParam >> 4) * 10 + (channelMemory.effektParam & 0xF);
                break;
            }
            case 4: {
                if (channelMemory.effektParam != 0) {
                    channelMemory.volumSlideValue = channelMemory.effektParam;
                }
                if (!(channelMemory.volumSlideValue >> 4 == 15 && (channelMemory.volumSlideValue & 0xF) != 0 || channelMemory.volumSlideValue >> 4 != 0 && (channelMemory.volumSlideValue & 0xF) == 15) && !this.useFastSlides) break;
                this.doVolumeSlideEffekt(channelMemory);
                break;
            }
            case 5: {
                int n;
                if (channelMemory.effektParam != 0) {
                    channelMemory.portaStepDown = channelMemory.effektParam;
                }
                if ((n = channelMemory.portaStepDown & 0xF0) != 224 && n != 240) break;
                int n2 = channelMemory.portaStepDown & 0xF;
                channelMemory.currentNotePeriod = channelMemory.currentNotePeriod + (n == 224 ? n2 << 2 : n2 << 4);
                this.setNewPlayerTuningFor(channelMemory);
                break;
            }
            case 6: {
                int n;
                if (channelMemory.effektParam != 0) {
                    channelMemory.portaStepUp = channelMemory.effektParam;
                }
                if ((n = channelMemory.portaStepUp & 0xF0) != 224 && n != 240) break;
                int n3 = channelMemory.portaStepUp & 0xF;
                channelMemory.currentNotePeriod = channelMemory.currentNotePeriod - (n == 224 ? n3 << 2 : n3 << 4);
                this.setNewPlayerTuningFor(channelMemory);
                break;
            }
            case 7: {
                if (channelMemory.assignedNotePeriod != 0) {
                    channelMemory.portaTargetNotePeriod = this.getFineTunePeriod(channelMemory);
                }
                if (channelMemory.effektParam == 0) break;
                channelMemory.portaNoteStep = channelMemory.effektParam << 4;
                break;
            }
            case 8: 
            case 21: {
                if (channelMemory.effektParam >> 4 != 0) {
                    channelMemory.vibratoStep = channelMemory.effektParam >> 4;
                }
                if ((channelMemory.effektParam & 0xF) != 0) {
                    channelMemory.vibratoAmplitude = channelMemory.effektParam & 0xF;
                }
                channelMemory.vibratoOn = true;
                break;
            }
            case 9: {
                if (channelMemory.effektParam != 0) {
                    channelMemory.tremorCount = 0;
                    channelMemory.tremorOntime = (channelMemory.effektParam >> 4) + 1;
                    channelMemory.tremorOfftime = (channelMemory.effektParam & 0xF) + 1;
                }
                this.doTremorEffekt(channelMemory);
                break;
            }
            case 10: {
                if (channelMemory.assignedNotePeriod == 0) break;
                int n = channelMemory.assignedNoteIndex - 1;
                channelMemory.arpegioNote[0] = this.getFineTunePeriod(channelMemory);
                channelMemory.arpegioNote[1] = this.getFineTunePeriod(channelMemory, n + (channelMemory.effektParam >> 4));
                channelMemory.arpegioNote[2] = this.getFineTunePeriod(channelMemory, n + (channelMemory.effektParam & 0xF));
                channelMemory.arpegioIndex = 0;
                break;
            }
            case 11: {
                channelMemory.vibratoOn = true;
                if (channelMemory.effektParam != 0) {
                    channelMemory.volumSlideValue = channelMemory.effektParam;
                }
                if (!(channelMemory.effektParam >> 4 == 15 && (channelMemory.effektParam & 0xF) != 0 || channelMemory.effektParam >> 4 != 0 && (channelMemory.effektParam & 0xF) == 15) && !this.useFastSlides) break;
                this.doVolumeSlideEffekt(channelMemory);
                break;
            }
            case 12: {
                if (channelMemory.assignedNotePeriod != 0) {
                    channelMemory.portaTargetNotePeriod = this.getFineTunePeriod(channelMemory);
                }
                if (channelMemory.effektParam != 0) {
                    channelMemory.volumSlideValue = channelMemory.effektParam;
                }
                if (!(channelMemory.effektParam >> 4 == 15 && (channelMemory.effektParam & 0xF) != 0 || channelMemory.effektParam >> 4 != 0 && (channelMemory.effektParam & 0xF) == 15) && !this.useFastSlides) break;
                this.doVolumeSlideEffekt(channelMemory);
                break;
            }
            case 13: {
                channelMemory.channelVolume = channelMemory.effektParam;
                if (channelMemory.channelVolume <= 64) break;
                channelMemory.channelVolume = 64;
                break;
            }
            case 14: {
                if (channelMemory.effektParam != 0) {
                    channelMemory.channelVolumSlideValue = channelMemory.effektParam;
                }
                if (!(channelMemory.effektParam >> 4 == 15 && (channelMemory.effektParam & 0xF) != 0 || channelMemory.effektParam >> 4 != 0 && (channelMemory.effektParam & 0xF) == 15) && !this.useFastSlides) break;
                this.doChannelVolumeSlideEffekt(channelMemory);
                break;
            }
            case 15: {
                if (channelMemory.currentNotePeriod == 0 || channelMemory.currentSample == null) break;
                if (channelMemory.effektParam != 0) {
                    channelMemory.sampleOffset = channelMemory.highSampleOffset << 16 | channelMemory.effektParam << 8;
                    channelMemory.highSampleOffset = 0;
                }
                channelMemory.currentSamplePos = channelMemory.sampleOffset < channelMemory.currentSample.length ? channelMemory.sampleOffset : channelMemory.currentSample.length - 1;
                channelMemory.currentTuningPos = 0;
                channelMemory.currentDirection = 0;
                break;
            }
            case 16: {
                if (channelMemory.effektParam >> 4 != 0) {
                    channelMemory.panningSlideValue = channelMemory.effektParam >> 4 << 2;
                    break;
                }
                channelMemory.panningSlideValue = -((channelMemory.effektParam & 0xF) << 2);
                break;
            }
            case 17: {
                channelMemory.retrigCount = channelMemory.retrigMemo = channelMemory.effektParam & 0xF;
                channelMemory.retrigVolSlide = channelMemory.effektParam >> 4;
                break;
            }
            case 18: {
                if (channelMemory.effektParam >> 4 != 0) {
                    channelMemory.tremoloStep = channelMemory.effektParam >> 4;
                }
                if ((channelMemory.effektParam & 0xF) != 0) {
                    channelMemory.tremoloAmplitude = channelMemory.effektParam & 0xF;
                }
                channelMemory.tremoloOn = true;
                break;
            }
            case 19: {
                int n = channelMemory.effektParam & 0xF;
                switch (channelMemory.effektParam >> 4) {
                    case 1: {
                        channelMemory.glissando = n != 0;
                        break block0;
                    }
                    case 2: {
                        channelMemory.currentFineTune = Helpers.it_fineTuneTable[n];
                        channelMemory.currentFinetuneFrequency = Helpers.it_fineTuneTable[n];
                        this.setNewPlayerTuningFor(channelMemory);
                        break block0;
                    }
                    case 3: {
                        channelMemory.vibratoType = n & 3;
                        channelMemory.vibratoNoRetrig = (n & 4) != 0;
                        break block0;
                    }
                    case 4: {
                        channelMemory.tremoloType = n & 3;
                        channelMemory.tremoloNoRetrig = (n & 4) != 0;
                        break block0;
                    }
                    case 5: {
                        channelMemory.panbrelloType = n & 3;
                        channelMemory.panbrelloNoRetrig = (n & 4) != 0;
                        break block0;
                    }
                    case 6: {
                        if (this.patternTicksDelayCount > 0) break block0;
                        this.patternTicksDelayCount = n;
                        break block0;
                    }
                    case 7: {
                        break block0;
                    }
                    case 8: {
                        channelMemory.panning = n << 4;
                        break block0;
                    }
                    case 9: {
                        switch (n) {
                            case 0: {
                                channelMemory.doSurround = false;
                                break block0;
                            }
                            case 1: {
                                channelMemory.doSurround = true;
                                break block0;
                            }
                            case 8: {
                                break block0;
                            }
                            case 9: {
                                break block0;
                            }
                            case 10: {
                                break block0;
                            }
                            case 11: {
                                break block0;
                            }
                            case 12: {
                                break block0;
                            }
                            case 13: {
                                break block0;
                            }
                            case 14: {
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 10: {
                        channelMemory.highSampleOffset = channelMemory.effektParam & 0xF;
                        break block0;
                    }
                    case 11: {
                        if (n == 0) {
                            this.jumpLoopPatternIndex = this.currentArrangement;
                            this.jumpLoopPatternRow = this.currentRow;
                            this.jumpLoopPositionSet = true;
                            break block0;
                        }
                        if (this.jumpLoopRepeatCount == -1) {
                            this.jumpLoopRepeatCount = n;
                            if (!this.jumpLoopPositionSet) {
                                this.jumpLoopPatternIndex = this.currentArrangement;
                                this.jumpLoopPatternRow = 0;
                                this.jumpLoopPositionSet = true;
                            }
                        }
                        if (this.jumpLoopRepeatCount > 0 && this.jumpLoopPositionSet) {
                            --this.jumpLoopRepeatCount;
                            this.patternBreakRowIndex = this.jumpLoopPatternRow;
                            this.patternPosJumpPatternIndex = this.jumpLoopPatternIndex;
                            break block0;
                        }
                        this.jumpLoopPositionSet = false;
                        this.jumpLoopRepeatCount = -1;
                        break block0;
                    }
                    case 12: {
                        channelMemory.noteCutCount = n;
                        break block0;
                    }
                    case 13: {
                        channelMemory.noteDelayCount = n;
                        break block0;
                    }
                    case 14: {
                        if (this.patternDelayCount > 0) break block0;
                        this.patternDelayCount = n;
                        break block0;
                    }
                }
                break;
            }
            case 20: {
                this.currentBPM = channelMemory.effektParam >> 4 == 0 ? (this.currentBPM -= channelMemory.effektParam & 0xF) : (channelMemory.effektParam >> 4 == 1 ? (this.currentBPM += channelMemory.effektParam & 0xF) : channelMemory.effektParam);
                this.samplePerTicks = this.calculateSamplesPerTick();
                break;
            }
            case 22: {
                this.globalVolume = this.mod.getModType() == 8 ? channelMemory.effektParam : channelMemory.effektParam << 1;
                if (this.globalVolume <= 128) break;
                this.globalVolume = 128;
                break;
            }
            case 23: {
                this.globalVolumSlideValue = channelMemory.effektParam >> 4 != 0 ? channelMemory.effektParam >> 4 : -(channelMemory.effektParam & 0xF);
                if (this.mod.getModType() != 8) {
                    this.globalVolumSlideValue <<= 1;
                }
                this.doGlobalVolumeSlideEffekt();
                break;
            }
            case 24: {
                if (channelMemory.effektParam == 164) {
                    channelMemory.doSurround = true;
                    channelMemory.panning = 128;
                    break;
                }
                channelMemory.doSurround = false;
                channelMemory.panning = channelMemory.effektParam;
                break;
            }
            case 25: {
                if (channelMemory.effektParam >> 4 != 0) {
                    channelMemory.panbrelloStep = channelMemory.effektParam >> 4;
                }
                if ((channelMemory.effektParam & 0xF) != 0) {
                    channelMemory.panbrelloAmplitude = channelMemory.effektParam & 0xF;
                }
                channelMemory.panbrelloOn = true;
                break;
            }
        }
    }

    private void doPortaToNoteEffekt(BasicModMixer.ChannelMemory channelMemory) {
        if (channelMemory.portaTargetNotePeriod != channelMemory.currentNotePeriod) {
            if (channelMemory.portaTargetNotePeriod < channelMemory.currentNotePeriod) {
                channelMemory.currentNotePeriod -= channelMemory.portaNoteStep;
                if (channelMemory.currentNotePeriod < channelMemory.portaTargetNotePeriod) {
                    channelMemory.currentNotePeriod = channelMemory.portaTargetNotePeriod;
                }
            } else {
                channelMemory.currentNotePeriod += channelMemory.portaNoteStep;
                if (channelMemory.currentNotePeriod > channelMemory.portaTargetNotePeriod) {
                    channelMemory.currentNotePeriod = channelMemory.portaTargetNotePeriod;
                }
            }
            this.setNewPlayerTuningFor(channelMemory);
        }
    }

    protected void doVibratoEffekt(BasicModMixer.ChannelMemory channelMemory, boolean bl) {
        int n;
        switch (channelMemory.vibratoType & 3) {
            case 1: {
                n = Helpers.ModRampDownTable[channelMemory.vibratoTablePos];
                break;
            }
            case 2: {
                n = Helpers.ModSquareTable[channelMemory.vibratoTablePos];
                break;
            }
            case 3: {
                n = Helpers.ModRandomTable[channelMemory.vibratoTablePos];
                break;
            }
            default: {
                n = Helpers.ModSinusTable[channelMemory.vibratoTablePos];
            }
        }
        n = (n << 4) * channelMemory.vibratoAmplitude >> (bl ? 9 : 7);
        this.setNewPlayerTuningFor(channelMemory, channelMemory.currentNotePeriod + n);
        channelMemory.vibratoTablePos = channelMemory.vibratoTablePos + channelMemory.vibratoStep & 0x3F;
    }

    protected void doTremoloEffekt(BasicModMixer.ChannelMemory channelMemory) {
        int n;
        switch (channelMemory.tremoloType & 3) {
            case 1: {
                n = Helpers.ModRampDownTable[channelMemory.tremoloTablePos];
                break;
            }
            case 2: {
                n = Helpers.ModSquareTable[channelMemory.tremoloTablePos];
                break;
            }
            case 3: {
                n = Helpers.ModRandomTable[channelMemory.tremoloTablePos];
                break;
            }
            default: {
                n = Helpers.ModSinusTable[channelMemory.tremoloTablePos];
            }
        }
        n = n * channelMemory.tremoloAmplitude >> 7;
        channelMemory.currentVolume = channelMemory.currentSetVolume + n;
        channelMemory.tremoloTablePos = channelMemory.tremoloTablePos + channelMemory.tremoloStep & 0x3F;
    }

    protected void doTremorEffekt(BasicModMixer.ChannelMemory channelMemory) {
        channelMemory.currentVolume = channelMemory.tremorCount < channelMemory.tremorOntime ? channelMemory.currentSetVolume : 0;
        ++channelMemory.tremorCount;
        if (channelMemory.tremorCount > channelMemory.tremorOntime + channelMemory.tremorOfftime) {
            channelMemory.tremorCount = 0;
        }
    }

    protected void doVolumeSlideEffekt(BasicModMixer.ChannelMemory channelMemory) {
        int n = channelMemory.volumSlideValue >> 4;
        int n2 = channelMemory.volumSlideValue & 0xF;
        if (n != 0) {
            channelMemory.currentSetVolume = n == 15 && n2 != 0 ? (channelMemory.currentVolume -= n2) : (channelMemory.currentVolume += n);
        } else if (n2 != 0) {
            channelMemory.currentSetVolume = n != 0 && n2 == 15 ? (channelMemory.currentVolume += n) : (channelMemory.currentVolume -= n2);
        }
    }

    protected void doChannelVolumeSlideEffekt(BasicModMixer.ChannelMemory channelMemory) {
        int n = channelMemory.channelVolumSlideValue >> 4;
        int n2 = channelMemory.channelVolumSlideValue & 0xF;
        if (n != 0) {
            channelMemory.channelVolume = n == 15 && n2 != 0 ? (channelMemory.channelVolume -= n2) : (channelMemory.channelVolume += n);
        } else if (n2 != 0) {
            channelMemory.channelVolume = n != 0 && n2 == 15 ? (channelMemory.channelVolume += n) : (channelMemory.channelVolume -= n2);
        }
        if (channelMemory.channelVolume > 64) {
            channelMemory.channelVolume = 64;
        } else if (channelMemory.channelVolume < 0) {
            channelMemory.channelVolume = 0;
        }
    }

    protected void doGlobalVolumeSlideEffekt() {
        this.globalVolume += this.globalVolumSlideValue;
        if (this.globalVolume > 128) {
            this.globalVolume = 128;
        } else if (this.globalVolume < 0) {
            this.globalVolume = 0;
        }
    }

    protected void doPanningSlideEffekt(BasicModMixer.ChannelMemory channelMemory) {
        channelMemory.doSurround = false;
        channelMemory.panning += channelMemory.panningSlideValue;
    }

    @Override
    protected void doTickEffekts(BasicModMixer.ChannelMemory channelMemory) {
        if (channelMemory.effekt == 0 && channelMemory.effektParam == 0) {
            return;
        }
        switch (channelMemory.effekt) {
            case 4: {
                if (channelMemory.volumSlideValue >> 4 == 15 && (channelMemory.volumSlideValue & 0xF) != 0 && (channelMemory.volumSlideValue >> 4 == 0 || (channelMemory.volumSlideValue & 0xF) != 15)) break;
                this.doVolumeSlideEffekt(channelMemory);
                break;
            }
            case 5: {
                int n = channelMemory.portaStepDown & 0xF0;
                if (n == 224 || n == 240) break;
                channelMemory.currentNotePeriod += channelMemory.portaStepDown << 4;
                if (channelMemory.glissando) {
                    channelMemory.currentNotePeriod = Helpers.getRoundedPeriod(channelMemory.currentNotePeriod >> 4) << 4;
                }
                this.setNewPlayerTuningFor(channelMemory);
                break;
            }
            case 6: {
                int n = channelMemory.portaStepUp & 0xF0;
                if (n == 224 || n == 240) break;
                channelMemory.currentNotePeriod -= channelMemory.portaStepUp << 4;
                if (channelMemory.glissando) {
                    channelMemory.currentNotePeriod = Helpers.getRoundedPeriod(channelMemory.currentNotePeriod >> 4) << 4;
                }
                this.setNewPlayerTuningFor(channelMemory);
                break;
            }
            case 7: {
                this.doPortaToNoteEffekt(channelMemory);
                break;
            }
            case 8: {
                this.doVibratoEffekt(channelMemory, false);
                break;
            }
            case 9: {
                this.doTremorEffekt(channelMemory);
                break;
            }
            case 10: {
                channelMemory.arpegioIndex = (channelMemory.arpegioIndex + 1) % 3;
                int n = channelMemory.arpegioNote[channelMemory.arpegioIndex];
                if (n == 0) break;
                channelMemory.currentNotePeriod = n;
                this.setNewPlayerTuningFor(channelMemory);
                break;
            }
            case 11: {
                this.doVibratoEffekt(channelMemory, false);
                this.doVolumeSlideEffekt(channelMemory);
                break;
            }
            case 12: {
                this.doPortaToNoteEffekt(channelMemory);
                this.doVolumeSlideEffekt(channelMemory);
                break;
            }
            case 14: {
                if (channelMemory.effektParam >> 4 == 15 && (channelMemory.effektParam & 0xF) != 0 && (channelMemory.effektParam >> 4 == 0 || (channelMemory.effektParam & 0xF) != 15)) break;
                this.doChannelVolumeSlideEffekt(channelMemory);
                break;
            }
            case 16: {
                this.doPanningSlideEffekt(channelMemory);
                break;
            }
            case 17: {
                if (channelMemory.retrigVolSlide > 0) {
                    switch (channelMemory.retrigVolSlide) {
                        case 1: {
                            --channelMemory.currentVolume;
                            break;
                        }
                        case 2: {
                            channelMemory.currentVolume -= 2;
                            break;
                        }
                        case 3: {
                            channelMemory.currentVolume -= 4;
                            break;
                        }
                        case 4: {
                            channelMemory.currentVolume -= 8;
                            break;
                        }
                        case 5: {
                            channelMemory.currentVolume -= 16;
                            break;
                        }
                        case 6: {
                            channelMemory.currentVolume = (channelMemory.currentVolume << 1) / 3;
                            break;
                        }
                        case 7: {
                            channelMemory.currentVolume >>= 1;
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            ++channelMemory.currentVolume;
                            break;
                        }
                        case 10: {
                            channelMemory.currentVolume += 2;
                            break;
                        }
                        case 11: {
                            channelMemory.currentVolume += 4;
                            break;
                        }
                        case 12: {
                            channelMemory.currentVolume += 8;
                            break;
                        }
                        case 13: {
                            channelMemory.currentVolume += 16;
                            break;
                        }
                        case 14: {
                            channelMemory.currentVolume = channelMemory.currentVolume * 3 >> 1;
                            break;
                        }
                        case 15: {
                            channelMemory.currentVolume <<= 1;
                        }
                    }
                    channelMemory.currentSetVolume = channelMemory.currentVolume;
                }
                --channelMemory.retrigCount;
                if (channelMemory.retrigCount > 0) break;
                channelMemory.retrigCount = channelMemory.retrigMemo;
                this.resetInstrument(channelMemory);
                break;
            }
            case 18: {
                this.doTremoloEffekt(channelMemory);
                break;
            }
            case 19: {
                switch (channelMemory.effektParam >> 4) {
                    case 12: {
                        if (channelMemory.noteCutCount <= 0) break;
                        --channelMemory.noteCutCount;
                        if (channelMemory.noteCutCount > 0) break;
                        channelMemory.noteCutCount = -1;
                        channelMemory.currentVolume = 0;
                        break;
                    }
                    case 13: {
                        if (channelMemory.noteDelayCount <= 0) break;
                        --channelMemory.noteDelayCount;
                        if (channelMemory.noteDelayCount > 0) break;
                        channelMemory.noteDelayCount = -1;
                        this.setNewInstrumentAndPeriod(channelMemory);
                    }
                }
                break;
            }
            case 21: {
                this.doVibratoEffekt(channelMemory, true);
                break;
            }
            case 23: {
                this.doGlobalVolumeSlideEffekt();
            }
        }
    }

    @Override
    protected void doVolumeColumnRowEffekt(BasicModMixer.ChannelMemory channelMemory) {
        if (channelMemory.volumeEffekt == 0) {
            return;
        }
        switch (channelMemory.volumeEffekt) {
            case 1: {
                channelMemory.currentSetVolume = channelMemory.currentVolume = channelMemory.volumeEffektOp;
                break;
            }
            case 2: {
                channelMemory.volumSlideValue = -channelMemory.volumeEffektOp;
                break;
            }
            case 3: {
                channelMemory.volumSlideValue = channelMemory.volumeEffektOp;
                break;
            }
            case 4: {
                channelMemory.currentSetVolume = channelMemory.currentVolume -= channelMemory.volumeEffektOp;
                break;
            }
            case 5: {
                channelMemory.currentSetVolume = channelMemory.currentVolume += channelMemory.volumeEffektOp;
                break;
            }
            case 6: {
                if (channelMemory.volumeEffektOp == 0) break;
                channelMemory.vibratoStep = channelMemory.volumeEffektOp;
                break;
            }
            case 7: {
                if (channelMemory.volumeEffektOp == 0) break;
                channelMemory.vibratoAmplitude = channelMemory.volumeEffektOp;
                break;
            }
            case 8: {
                channelMemory.doSurround = false;
                channelMemory.panning = channelMemory.volumeEffektOp << 4;
                break;
            }
            case 9: {
                channelMemory.panningSlideValue = -channelMemory.volumeEffektOp;
                break;
            }
            case 10: {
                channelMemory.panningSlideValue = channelMemory.volumeEffektOp;
                break;
            }
            case 11: {
                if (channelMemory.assignedNotePeriod != 0) {
                    channelMemory.portaTargetNotePeriod = this.getFineTunePeriod(channelMemory);
                }
                if (channelMemory.volumeEffektOp == 0) break;
                channelMemory.portaNoteStep = channelMemory.volumeEffektOp;
                break;
            }
            case 12: {
                channelMemory.portaStepDown = channelMemory.volumeEffektOp << 4;
                break;
            }
            case 13: {
                channelMemory.portaStepUp = channelMemory.volumeEffektOp << 4;
            }
        }
    }

    @Override
    protected void doVolumeColumnTickEffekt(BasicModMixer.ChannelMemory channelMemory) {
        if (channelMemory.volumeEffekt == 0) {
            return;
        }
        switch (channelMemory.volumeEffekt) {
            case 2: 
            case 3: {
                this.doVolumeSlideEffekt(channelMemory);
                break;
            }
            case 6: 
            case 7: {
                this.doVibratoEffekt(channelMemory, false);
                break;
            }
            case 9: 
            case 10: {
                this.doPanningSlideEffekt(channelMemory);
                break;
            }
            case 11: {
                this.doPortaToNoteEffekt(channelMemory);
            }
        }
    }

    @Override
    protected boolean isNoteDelayEffekt(BasicModMixer.ChannelMemory channelMemory) {
        return channelMemory.effekt == 19 && channelMemory.effektParam >> 4 == 13;
    }

    @Override
    protected boolean isPortaToNoteEffekt(BasicModMixer.ChannelMemory channelMemory) {
        return (channelMemory.effekt == 7 || channelMemory.effekt == 12) && channelMemory.currentNotePeriod != 0;
    }

    @Override
    protected boolean isSampleOffsetEffekt(BasicModMixer.ChannelMemory channelMemory) {
        return channelMemory.effekt == 15;
    }
}

