/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ID3v2Footer {
    private static final String ENC_TYPE = "ISO-8859-1";
    private static final String TAG_START = "3DI";
    private static final int FOOT_SIZE = 10;
    private static final int NEW_MAJOR_VERSION = 3;
    private static final int NEW_MINOR_VERSION = 0;
    private boolean footerExists = false;
    private int majorVersion = 3;
    private int minorVersion = 0;
    private boolean unsynchronisation = false;
    private boolean extended = false;
    private boolean experimental = false;
    private boolean footer = false;
    private int tagSize = 0;

    public ID3v2Footer(RandomAccessInputStream randomAccessInputStream, int n) throws IOException {
        this.footerExists = this.checkFooter(randomAccessInputStream, n);
        if (this.footerExists) {
            this.readFooter(randomAccessInputStream, n);
        }
    }

    private boolean checkFooter(RandomAccessInputStream randomAccessInputStream, int n) throws IOException {
        randomAccessInputStream.seek(n);
        byte[] byArray = new byte[10];
        if (randomAccessInputStream.read(byArray) != 10) {
            throw new IOException("Error encountered finding id3v2 footer");
        }
        String string = new String(byArray, ENC_TYPE);
        return string.substring(0, TAG_START.length()).equals(TAG_START) && (byArray[3] & 0xFF) != 255 && (byArray[4] & 0xFF) != 255 && (byArray[6] & 0x80) == 0 && (byArray[7] & 0x80) == 0 && (byArray[8] & 0x80) == 0 && (byArray[9] & 0x80) == 0;
    }

    private void readFooter(RandomAccessInputStream randomAccessInputStream, int n) throws IOException {
        randomAccessInputStream.seek(n);
        byte[] byArray = new byte[10];
        if (randomAccessInputStream.read(byArray) != 10) {
            throw new IOException("Error encountered reading id3v2 footer");
        }
        this.majorVersion = byArray[3];
        if (this.majorVersion <= 3) {
            this.minorVersion = byArray[4];
            this.unsynchronisation = (byArray[5] & 0x80) != 0;
            this.extended = (byArray[5] & 0x40) != 0;
            this.experimental = (byArray[5] & 0x20) != 0;
            this.footer = (byArray[5] & 0x10) != 0;
            this.tagSize = Helpers.convertDWordToInt(byArray, 6);
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[10];
        int n = 0;
        System.arraycopy(Helpers.getBytesFromString(TAG_START, TAG_START.length(), ENC_TYPE), 0, byArray, 0, TAG_START.length());
        n += TAG_START.length();
        byArray[n++] = (byte)this.majorVersion;
        byArray[n++] = (byte)this.minorVersion;
        byArray[n++] = this.getFlagByte();
        System.arraycopy(Helpers.convertIntToDWord(this.tagSize), 0, byArray, n, 4);
        n += 4;
        return byArray;
    }

    private byte getFlagByte() {
        byte by = 0;
        if (this.unsynchronisation) {
            by = (byte)(by | 0x80);
        }
        if (this.extended) {
            by = (byte)(by | 0x40);
        }
        if (this.experimental) {
            by = (byte)(by | 0x20);
        }
        if (this.footer) {
            by = (byte)(by | 0x10);
        }
        return by;
    }

    public boolean footerExists() {
        return this.footerExists;
    }

    public int getFooterSize() {
        if (this.footerExists) {
            return 10;
        }
        return 0;
    }

    public int getTagSize() {
        return this.tagSize;
    }

    public void setTagSize(int n) {
        if (n > 0) {
            this.tagSize = n;
            this.footerExists = true;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean getUnsynchronisation() {
        return this.unsynchronisation;
    }

    public void setUnsynchronisation(boolean bl) {
        this.unsynchronisation = bl;
    }

    public boolean getExtendedFooter() {
        return this.extended;
    }

    public void setExtendedFooter(boolean bl) {
        this.extended = bl;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean bl) {
        this.experimental = bl;
    }

    public boolean getFooter() {
        return this.footer;
    }

    public void setFooter(boolean bl) {
        this.footer = bl;
    }

    public String toString() {
        return "ID3v2." + this.getMajorVersion() + "." + this.getMinorVersion() + "\n" + "TagSize:\t\t\t" + this.getTagSize() + " bytes\nUnsynchronisation:\t\t" + this.getUnsynchronisation() + "\nExtended Footer:\t\t" + this.getExtendedFooter() + "\nExperimental:\t\t\t" + this.getExperimental() + "\nFooter:\t\t\t\t" + this.getFooter();
    }
}

