/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.io.RandomAccessInputStreamImpl;
import de.quippy.javamod.multimedia.mp3.id3.ID3v1Tag;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Tag;
import de.quippy.javamod.multimedia.mp3.id3.MPEGAudioFrameHeader;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;

public class MP3FileID3Controller {
    public static final int ID3V1 = 1;
    public static final int ID3V2 = 2;
    private File mp3File;
    private ID3v1Tag id3v1;
    private ID3v2Tag id3v2;
    private MPEGAudioFrameHeader head;

    public MP3FileID3Controller(URL uRL) {
        this.getTagsFromURL(uRL);
    }

    public MP3FileID3Controller(RandomAccessInputStream randomAccessInputStream) {
        this.getTagsFromRAF(randomAccessInputStream);
    }

    private void getTagsFromURL(URL uRL) {
        RandomAccessInputStreamImpl randomAccessInputStreamImpl = null;
        try {
            try {
                randomAccessInputStreamImpl = new RandomAccessInputStreamImpl(uRL);
                this.getTagsFromRAF(randomAccessInputStreamImpl);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            if (randomAccessInputStreamImpl != null) {
                try {
                    randomAccessInputStreamImpl.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
    }

    private void getTagsFromRAF(RandomAccessInputStream randomAccessInputStream) {
        try {
            this.mp3File = randomAccessInputStream.getFile();
            this.id3v1 = new ID3v1Tag(randomAccessInputStream);
            this.id3v2 = new ID3v2Tag(randomAccessInputStream);
            this.head = new MPEGAudioFrameHeader(randomAccessInputStream, this.id3v2.getSize());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void removeTags(int n) throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.mp3File, "rw");
            if (this.allow(n & 1)) {
                this.id3v1.removeTag(randomAccessFile);
            }
            if (this.allow(n & 2)) {
                this.id3v2.removeTag(randomAccessFile);
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public void writeTags() throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.mp3File, "rw");
            if (this.id3v2.tagExists()) {
                this.id3v2.writeTag(randomAccessFile);
            }
            if (this.id3v1.tagExists()) {
                this.id3v1.writeTag(randomAccessFile);
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public void setTitle(String string, int n) {
        if (this.allow(n & 1)) {
            this.id3v1.setTitle(string);
        }
        if (this.allow(n & 2)) {
            this.id3v2.setTextFrame("TIT2", string);
        }
    }

    public void setAlbum(String string, int n) {
        if (this.allow(n & 1)) {
            this.id3v1.setAlbum(string);
        }
        if (this.allow(n & 2)) {
            this.id3v2.setTextFrame("TALB", string);
        }
    }

    public void setArtist(String string, int n) {
        if (this.allow(n & 1)) {
            this.id3v1.setArtist(string);
        }
        if (this.allow(n & 2)) {
            this.id3v2.setTextFrame("TPE1", string);
        }
    }

    public void setComment(String string, int n) {
        if (this.allow(n & 1)) {
            this.id3v1.setComment(string);
        }
        if (this.allow(n & 2)) {
            this.id3v2.setCommentFrame("", string);
        }
    }

    public void setGenre(String string, int n) {
        if (this.allow(n & 1)) {
            this.id3v1.setGenreString(string);
        }
        if (this.allow(n & 2)) {
            this.id3v2.setTextFrame("TCON", string);
        }
    }

    public void setYear(String string, int n) {
        if (this.allow(n & 1)) {
            this.id3v1.setYear(string);
        }
        if (this.allow(n & 2)) {
            this.id3v2.setTextFrame("TYER", string);
        }
    }

    public void setTrack(int n, int n2) {
        if (this.allow(n2 & 1)) {
            this.id3v1.setTrack(n);
        }
        if (this.allow(n2 & 2)) {
            this.id3v2.setTextFrame("TRCK", String.valueOf(n));
        }
    }

    public void setComposer(String string) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame("TCOM", string);
        }
    }

    public void setOriginalArtist(String string) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame("TOPE", string);
        }
    }

    public void setCopyrightInfo(String string) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame("TCOP", string);
        }
    }

    public void setUserDefinedURL(String string, String string2) {
        if (this.allow(2)) {
            this.id3v2.setUserDefinedURLFrame(string, string2);
        }
    }

    public void setUserDefinedText(String string, String string2) {
        if (this.allow(2)) {
            this.id3v2.setUserDefinedTextFrame(string, string2);
        }
    }

    public void setEncodedBy(String string) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame("TENC", string);
        }
    }

    public void setTextFrame(String string, String string2) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame(string, string2);
        }
    }

    public void setFrameData(String string, byte[] byArray) {
        if (this.allow(2)) {
            this.id3v2.updateFrameData(string, byArray);
        }
    }

    public long getPlayingTime() {
        long l = this.mp3File.length() * 8L - (long)this.id3v2.getSize();
        long l2 = this.head.getBitRate() * 1000;
        return l / l2;
    }

    public String getPlayingTimeString() {
        long l = this.getPlayingTime();
        long l2 = l / 60L;
        long l3 = l % 60L;
        StringBuilder stringBuilder = new StringBuilder();
        if (l2 < 10L) {
            stringBuilder.append('0');
        }
        stringBuilder.append(l2).append(':');
        if (l3 < 10L) {
            stringBuilder.append('0');
        }
        stringBuilder.append(l3);
        return stringBuilder.toString();
    }

    public boolean id3v2Exists() {
        return this.id3v2 != null && this.id3v2.tagExists();
    }

    public boolean id3v1Exists() {
        return this.id3v1 != null && this.id3v1.tagExists();
    }

    public boolean isMP3() {
        return this.head.isMP3();
    }

    public int getBitRate() {
        return this.head.getBitRate();
    }

    public int getSampleRate() {
        return this.head.getSampleRate();
    }

    public String getMPEGEmphasis() {
        return this.head.getEmphasis();
    }

    public String getMPEGLayer() {
        return this.head.getLayer();
    }

    public String getMPEGVersion() {
        return this.head.getVersion();
    }

    public String getMPEGChannelMode() {
        return this.head.getChannelMode();
    }

    public boolean isMPEGCopyrighted() {
        return this.head.isCopyrighted();
    }

    public boolean isMPEGOriginal() {
        return this.head.isOriginal();
    }

    public boolean isMPEGProtected() {
        return this.head.isProtected();
    }

    public String getArtist(int n) {
        if (this.allow(n & 1)) {
            return this.id3v1.getArtist();
        }
        if (this.allow(n & 2)) {
            return this.id3v2.getFrameDataString("TPE1");
        }
        return null;
    }

    public String getAlbum(int n) {
        if (this.allow(n & 1)) {
            return this.id3v1.getAlbum();
        }
        if (this.allow(n & 2)) {
            return this.id3v2.getFrameDataString("TALB");
        }
        return null;
    }

    public String getComment(int n) {
        if (this.allow(n & 1)) {
            return this.id3v1.getComment();
        }
        if (this.allow(n & 2)) {
            return this.id3v2.getFrameDataString("COMM");
        }
        return null;
    }

    public String getGenre(int n) {
        if (this.allow(n & 1)) {
            return this.id3v1.getGenreString();
        }
        if (this.allow(n & 2)) {
            return this.id3v2.getFrameDataString("TCON");
        }
        return null;
    }

    public String getTitle(int n) {
        if (this.allow(n & 1)) {
            return this.id3v1.getTitle();
        }
        if (this.allow(n & 2)) {
            return this.id3v2.getFrameDataString("TIT2");
        }
        return null;
    }

    public String getTrack(int n) {
        if (this.allow(n & 1)) {
            return Integer.toString(this.id3v1.getTrack());
        }
        if (this.allow(n & 2)) {
            return this.id3v2.getFrameDataString("TRCK");
        }
        return null;
    }

    public String getYear(int n) {
        if (this.allow(n & 1)) {
            return this.id3v1.getYear();
        }
        if (this.allow(n & 2)) {
            return this.id3v2.getFrameDataString("TYER");
        }
        return null;
    }

    public String getComposer() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TCOM");
        }
        return null;
    }

    public String getDisc() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TPOS");
        }
        return null;
    }

    public String getOriginalArtist() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TOPE");
        }
        return null;
    }

    public String getAlbumArtist() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TPE2");
        }
        return null;
    }

    public String getPublisher() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TPUB");
        }
        return null;
    }

    public String getCopyrightInfo() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TCOP");
        }
        return null;
    }

    public String getUserDefinedURL() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("WXXX");
        }
        return null;
    }

    public String getEncodedBy() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TENC");
        }
        return null;
    }

    public String getBPM() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TBPM");
        }
        return null;
    }

    public String getFrameDataString(String string) {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString(string);
        }
        return null;
    }

    public byte[] getFrameDataBytes(String string) {
        if (this.allow(2)) {
            return this.id3v2.getFrameData(string);
        }
        return null;
    }

    public String getFileName() {
        if (this.mp3File == null) {
            return "";
        }
        try {
            return this.mp3File.getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.mp3File.getAbsolutePath();
        }
    }

    public String getShortDescription() {
        int n;
        String string = null;
        String string2 = null;
        if (this.id3v2Exists()) {
            string = this.getArtist(2);
            string2 = this.getTitle(2);
        }
        if (this.id3v1Exists()) {
            if (string == null || string.length() == 0) {
                string = this.getArtist(1);
            }
            if (string2 == null || string2.length() == 0) {
                string2 = this.getTitle(1);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() != 0) {
            stringBuilder.append(string).append(" - ");
        }
        if ((string2 == null || string2.length() == 0) && this.mp3File != null && (n = (string2 = this.mp3File.getName()).lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n);
        }
        return stringBuilder.append(string2).toString();
    }

    private boolean allow(int n) {
        return (n & 1) != 0 && this.id3v1Exists() || (n & 2) != 0 && this.id3v2Exists();
    }

    public String toString() {
        return "MP3File\nPath:\t\t\t\t" + this.mp3File.getAbsolutePath() + "\nFileSize:\t\t\t" + this.mp3File.length() + " bytes\nPlayingTime:\t\t\t" + this.getPlayingTimeString() + "\n" + this.head + "\n" + this.id3v1 + "\n" + this.id3v2;
    }
}

