/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.streaming;

import de.quippy.javamod.multimedia.mp3.streaming.IcyTag;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseEvent;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class IcyInputStream
extends BufferedInputStream {
    private ArrayList<TagParseListener> tagParseListeners = new ArrayList();
    protected static final String INLINE_TAG_SEPARATORS = ";\u0000";
    private HashMap<String, IcyTag> tags;
    protected byte[] crlfBuffer = new byte[1024];
    protected int metaint = -1;
    protected int bytesUntilNextMetadata = -1;

    public IcyInputStream(InputStream inputStream, String string, TagParseListener tagParseListener) throws IOException {
        super(inputStream);
        this.tags = new HashMap();
        if (tagParseListener != null) {
            this.addTagParseListener(tagParseListener);
        }
        if (string == null) {
            this.readInitialHeaders();
            IcyTag icyTag = this.getTag("icy-metaint");
            if (icyTag != null) {
                string = icyTag.getValue();
            }
        }
        try {
            if (string != null) {
                this.bytesUntilNextMetadata = this.metaint = Integer.parseInt(string.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public IcyInputStream(InputStream inputStream) throws IOException {
        this(inputStream, null, null);
    }

    public IcyInputStream(InputStream inputStream, TagParseListener tagParseListener) throws IOException {
        this(inputStream, null, tagParseListener);
    }

    protected void readInitialHeaders() throws IOException {
        String string;
        while ((string = this.readCRLFLine()).length() != 0) {
            int n = string.indexOf(58);
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string3.toLowerCase().endsWith("<br>")) {
                string3 = string3.substring(0, string3.length() - 4);
            }
            IcyTag icyTag = new IcyTag(string2, string3);
            this.addTag(icyTag);
        }
    }

    protected String readCRLFLine() throws IOException {
        int n = 0;
        while (n < this.crlfBuffer.length) {
            byte by = (byte)this.read();
            if (by == 10) break;
            if (by == 13) continue;
            this.crlfBuffer[n++] = by;
        }
        return new String(this.crlfBuffer, 0, n);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.bytesUntilNextMetadata > 0) {
            --this.bytesUntilNextMetadata;
            return super.read();
        }
        if (this.bytesUntilNextMetadata == 0) {
            this.readMetadata();
            this.bytesUntilNextMetadata = this.metaint - 1;
            return super.read();
        }
        return super.read();
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesUntilNextMetadata > 0) {
            int n3 = Math.min(n2, this.bytesUntilNextMetadata);
            int n4 = super.read(byArray, n, n3);
            this.bytesUntilNextMetadata -= n4;
            return n4;
        }
        if (this.bytesUntilNextMetadata == 0) {
            this.readMetadata();
            this.bytesUntilNextMetadata = this.metaint;
            int n5 = Math.min(n2, this.bytesUntilNextMetadata);
            int n6 = super.read(byArray, n, n5);
            this.bytesUntilNextMetadata -= n6;
            return n6;
        }
        return super.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    protected void readMetadata() throws IOException {
        int n = super.read();
        int n2 = n * 16;
        if (n2 < 0) {
            return;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = super.read(byArray, n3, n2);
            n3 += n4;
            n2 -= n4;
        }
        if (n > 0) {
            this.parseInlineIcyTags(byArray);
        }
    }

    protected void parseInlineIcyTags(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, INLINE_TAG_SEPARATORS);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            int n2 = string2.charAt(n + 1) == '\'' ? n + 2 : n + 1;
            int n3 = string2.charAt(string2.length() - 1) == '\'' ? string2.length() - 1 : string2.length();
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n2, n3);
            this.addTag(new IcyTag(string3, string4));
        }
    }

    protected void addTag(IcyTag icyTag) {
        this.tags.put(icyTag.getName(), icyTag);
        this.fireTagParsed(this, icyTag);
    }

    public IcyTag getTag(String string) {
        return this.tags.get(string);
    }

    public IcyTag[] getTags() {
        return this.tags.values().toArray(new IcyTag[this.tags.values().size()]);
    }

    public HashMap<String, IcyTag> getTagHash() {
        return this.tags;
    }

    public void addTagParseListener(TagParseListener tagParseListener) {
        this.tagParseListeners.add(tagParseListener);
    }

    public void removeTagParseListener(TagParseListener tagParseListener) {
        this.tagParseListeners.remove(tagParseListener);
    }

    public void fireTagParseEvent(TagParseEvent tagParseEvent) {
        int n = 0;
        while (n < this.tagParseListeners.size()) {
            TagParseListener tagParseListener = this.tagParseListeners.get(n);
            tagParseListener.tagParsed(tagParseEvent);
            ++n;
        }
    }

    public void fireTagParsed(Object object, IcyTag icyTag) {
        this.fireTagParseEvent(new TagParseEvent(object, icyTag));
    }
}

