/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.metadata;

import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.io.BitOutputStream;
import de.quippy.jflac.metadata.Metadata;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class StreamInfo
extends Metadata {
    private static final int STREAMINFO_MIN_BLOCK_SIZE_LEN = 16;
    private static final int STREAMINFO_MAX_BLOCK_SIZE_LEN = 16;
    private static final int STREAMINFO_MIN_FRAME_SIZE_LEN = 24;
    private static final int STREAMINFO_MAX_FRAME_SIZE_LEN = 24;
    private static final int STREAMINFO_SAMPLE_RATE_LEN = 20;
    private static final int STREAMINFO_CHANNELS_LEN = 3;
    private static final int STREAMINFO_BITS_PER_SAMPLE_LEN = 5;
    private static final int STREAMINFO_TOTAL_SAMPLES_LEN = 36;
    private static final int STREAMINFO_MD5SUM_LEN = 128;
    private byte[] md5sum = new byte[16];
    private int minBlockSize;
    private int maxBlockSize;
    private int minFrameSize;
    private int maxFrameSize;
    private int sampleRate;
    private int channels;
    private int bitsPerSample;
    private long totalSamples;

    public StreamInfo(BitInputStream bitInputStream, int n, boolean bl) throws IOException {
        super(bl);
        int n2 = 0;
        this.minBlockSize = bitInputStream.readRawUInt(16);
        n2 += 16;
        this.maxBlockSize = bitInputStream.readRawUInt(16);
        n2 += 16;
        this.minFrameSize = bitInputStream.readRawUInt(24);
        n2 += 24;
        this.maxFrameSize = bitInputStream.readRawUInt(24);
        n2 += 24;
        this.sampleRate = bitInputStream.readRawUInt(20);
        n2 += 20;
        this.channels = bitInputStream.readRawUInt(3) + 1;
        n2 += 3;
        this.bitsPerSample = bitInputStream.readRawUInt(5) + 1;
        n2 += 5;
        this.totalSamples = bitInputStream.readRawULong(36);
        n2 += 36;
        bitInputStream.readByteBlockAlignedNoCRC(this.md5sum, 16);
        bitInputStream.readByteBlockAlignedNoCRC(null, n -= (n2 += 128) / 8);
    }

    public void write(BitOutputStream bitOutputStream, boolean bl) throws IOException {
        bitOutputStream.writeRawUInt(bl, 1);
        bitOutputStream.writeRawUInt(0, 7);
        bitOutputStream.writeRawUInt(this.calcLength(), 24);
        bitOutputStream.writeRawUInt(this.minBlockSize, 16);
        bitOutputStream.writeRawUInt(this.maxBlockSize, 16);
        bitOutputStream.writeRawUInt(this.minFrameSize, 24);
        bitOutputStream.writeRawUInt(this.maxFrameSize, 24);
        bitOutputStream.writeRawUInt(this.sampleRate, 20);
        bitOutputStream.writeRawUInt(this.channels - 1, 3);
        bitOutputStream.writeRawULong(this.bitsPerSample - 1, 5);
        bitOutputStream.writeRawULong(this.totalSamples, 36);
        bitOutputStream.writeByteBlock(this.md5sum, this.md5sum.length);
        bitOutputStream.flushByteAligned();
    }

    public int calcLength() {
        int n = 144 + this.md5sum.length * 8;
        return (n + 7) / 8;
    }

    public boolean compatiable(StreamInfo streamInfo) {
        if (this.sampleRate != streamInfo.sampleRate) {
            return false;
        }
        if (this.channels != streamInfo.channels) {
            return false;
        }
        return this.bitsPerSample == streamInfo.bitsPerSample;
    }

    public String toString() {
        return "StreamInfo: BlockSize=" + this.minBlockSize + "-" + this.maxBlockSize + " FrameSize" + this.minFrameSize + "-" + this.maxFrameSize + " SampleRate=" + this.sampleRate + " Channels=" + this.channels + " BPS=" + this.bitsPerSample + " TotalSamples=" + this.totalSamples;
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public int getMinBlockSize() {
        return this.minBlockSize;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public void setTotalSamples(long l) {
        this.totalSamples = l;
    }

    public void addTotalSamples(long l) {
        this.totalSamples += l;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getMinFrameSize() {
        return this.minFrameSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public AudioFormat getAudioFormat() {
        return new AudioFormat(this.sampleRate, this.bitsPerSample, this.channels, this.bitsPerSample > 8, false);
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getChannels() {
        return this.channels;
    }
}

