/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.APEDecompressCore;
import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.tools.ByteBuffer;
import de.quippy.jmac.tools.Crc32;
import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.Prepare;
import java.io.IOException;

public class UnMAC {
    private boolean m_bInitialized = false;
    private int m_LastDecodedFrameIndex = -1;
    private int m_nRealFrame = 0;
    private IAPEDecompress m_pAPEDecompress = null;
    private Prepare m_pPrepare = null;
    private APEDecompressCore m_pAPEDecompressCore = null;
    public int m_nBlocksProcessed = 0;
    public Crc32 CRC = new Crc32();
    public long m_nStoredCRC;
    public WaveFormat m_wfeInput;

    public void Initialize(IAPEDecompress iAPEDecompress) {
        if (this.m_bInitialized) {
            this.Uninitialize();
        }
        if (iAPEDecompress == null) {
            this.Uninitialize();
            throw new JMACException("Error Initializing UnMAC");
        }
        this.m_pAPEDecompress = iAPEDecompress;
        this.m_LastDecodedFrameIndex = -1;
        this.m_pAPEDecompressCore = new APEDecompressCore(iAPEDecompress);
        this.m_pPrepare = new Prepare();
        this.m_bInitialized = true;
        this.m_wfeInput = this.m_pAPEDecompress.getApeInfoWaveFormatEx();
    }

    public void Uninitialize() {
        if (this.m_bInitialized) {
            this.m_pAPEDecompressCore = null;
            this.m_pPrepare = null;
            this.m_pAPEDecompress = null;
            this.m_LastDecodedFrameIndex = -1;
            this.m_bInitialized = false;
        }
    }

    public int DecompressFrame(ByteBuffer byteBuffer, int n) throws IOException {
        return this.DecompressFrameOld(byteBuffer, n);
    }

    public void SeekToFrame(int n) throws IOException {
        if (this.m_pAPEDecompress.getApeInfoFileVersion() > 3800) {
            if (this.m_LastDecodedFrameIndex == -1 || n - 1 != this.m_LastDecodedFrameIndex) {
                int n2 = (this.m_pAPEDecompress.getApeInfoSeekByte(n) - this.m_pAPEDecompress.getApeInfoSeekByte(0)) % 4;
                this.m_pAPEDecompressCore.GetUnBitArrray().FillAndResetBitArray(this.m_nRealFrame == n ? -1 : this.m_pAPEDecompress.getApeInfoSeekByte(n) - n2, n2 * 8);
                this.m_nRealFrame = n;
            } else {
                this.m_pAPEDecompressCore.GetUnBitArrray().AdvanceToByteBoundary();
            }
        } else if (this.m_LastDecodedFrameIndex == -1 || n - 1 != this.m_LastDecodedFrameIndex) {
            this.m_pAPEDecompressCore.GetUnBitArrray().FillAndResetBitArray(this.m_nRealFrame == n ? -1 : this.m_pAPEDecompress.getApeInfoSeekByte(n), this.m_pAPEDecompress.getApeInfoSeekBit(n));
            this.m_nRealFrame = n;
        }
    }

    private int DecompressFrameOld(ByteBuffer byteBuffer, int n) throws IOException {
        long l;
        if (n >= this.m_pAPEDecompress.getApeInfoTotalFrames()) {
            return 0;
        }
        int n2 = 0;
        int n3 = n2 = n + 1 >= this.m_pAPEDecompress.getApeInfoTotalFrames() ? this.m_pAPEDecompress.getApeInfoFinalFrameBlocks() : this.m_pAPEDecompress.getApeInfoBlocksPerFrame();
        if (n2 == 0) {
            throw new JMACException("Invalid Frame Index");
        }
        this.SeekToFrame(n);
        long l2 = 0L;
        long l3 = 0L;
        if ((this.m_pAPEDecompress.getApeInfoFormatFlags() & 2) <= 0) {
            l3 = this.m_pAPEDecompressCore.GetUnBitArrray().DecodeValue(1, 30);
            if (l3 == 0L) {
                l2 = 3L;
            }
        } else {
            l3 = this.m_pAPEDecompressCore.GetUnBitArrray().DecodeValue(0);
            l2 = 0L;
            if (this.m_pAPEDecompress.getApeInfoFileVersion() > 3820) {
                if ((l3 & Integer.MIN_VALUE) != 0L) {
                    l2 = this.m_pAPEDecompressCore.GetUnBitArrray().DecodeValue(0);
                }
                l3 &= Integer.MAX_VALUE;
            }
        }
        if (this.m_pAPEDecompress.getApeInfoChannels() == 2) {
            this.m_pAPEDecompressCore.GenerateDecodedArrays(n2, (int)l2, n);
            this.m_pPrepare.unprepareOld(this.m_pAPEDecompressCore.m_pDataX, this.m_pAPEDecompressCore.m_pDataY, n2, this.m_wfeInput, byteBuffer, this.CRC, this.m_pAPEDecompress.getApeInfoFileVersion());
        } else if (this.m_pAPEDecompress.getApeInfoChannels() == 1) {
            this.m_pAPEDecompressCore.GenerateDecodedArrays(n2, (int)l2, n);
            this.m_pPrepare.unprepareOld(this.m_pAPEDecompressCore.m_pDataX, null, n2, this.m_wfeInput, byteBuffer, this.CRC, this.m_pAPEDecompress.getApeInfoFileVersion());
        }
        if (this.m_pAPEDecompress.getApeInfoFileVersion() > 3820) {
            this.CRC.finalizeCrc();
        }
        if ((this.m_pAPEDecompress.getApeInfoFormatFlags() & 2) <= 0 ? (l = this.CalculateOldChecksum(this.m_pAPEDecompressCore.m_pDataX, this.m_pAPEDecompressCore.m_pDataY, this.m_pAPEDecompress.getApeInfoChannels(), n2)) != l3 : this.CRC.getCrc() != l3) {
            throw new JMACException("Invalid Checksum");
        }
        this.m_LastDecodedFrameIndex = n;
        return n2;
    }

    private long CalculateOldChecksum(int[] nArray, int[] nArray2, int n, int n2) {
        long l;
        block3: {
            block2: {
                l = 0L;
                if (n != 2) break block2;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray[n3] - nArray2[n3] / 2;
                    int n5 = n4 + nArray2[n3];
                    l += (long)(Math.abs(n4) + Math.abs(n5));
                    ++n3;
                }
                break block3;
            }
            if (n != 1) break block3;
            int n6 = 0;
            while (n6 < n2) {
                l += (long)Math.abs(nArray[n6]);
                ++n6;
            }
        }
        return l;
    }
}

