/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.File;
import java.io.IOException;

public class WaveFormat {
    public short wFormatTag;
    public short nChannels;
    public int nSamplesPerSec;
    public int nAvgBytesPerSec;
    public short nBlockAlign;
    public short wBitsPerSample;
    public short cbSize;
    public static final int WAV_HEADER_SIZE = 16;

    public static void FillWaveFormatEx(WaveFormat waveFormat, int n, int n2, int n3) {
        waveFormat.cbSize = 0;
        waveFormat.nSamplesPerSec = n;
        waveFormat.wBitsPerSample = (short)n2;
        waveFormat.nChannels = (short)n3;
        waveFormat.wFormatTag = 1;
        waveFormat.nBlockAlign = (short)(waveFormat.wBitsPerSample / 8 * waveFormat.nChannels);
        waveFormat.nAvgBytesPerSec = waveFormat.nBlockAlign * waveFormat.nSamplesPerSec;
    }

    public void readHeader(File file) throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(file, 16);
        this.wFormatTag = byteArrayReader.readShort();
        this.nChannels = byteArrayReader.readShort();
        this.nSamplesPerSec = byteArrayReader.readInt();
        this.nAvgBytesPerSec = byteArrayReader.readInt();
        this.nBlockAlign = byteArrayReader.readShort();
        this.wBitsPerSample = byteArrayReader.readShort();
    }
}

