/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.tools;

import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ByteArrayReader {
    private byte[] data = null;
    private int index = 0;

    public ByteArrayReader() {
    }

    public ByteArrayReader(File file, int n) throws IOException {
        this.data = new byte[n];
        file.readFully(this.data);
    }

    public ByteArrayReader(byte[] byArray) {
        this.data = byArray;
    }

    public ByteArrayReader(int n) {
        this.data = new byte[n];
    }

    public byte[] getData() {
        return this.data;
    }

    public void reset(byte[] byArray, int n) {
        this.data = byArray;
        this.index = n;
    }

    public void reset(File file, int n) throws IOException {
        this.index = 0;
        try {
            file.readFully(this.data, 0, n);
        }
        catch (EOFException eOFException) {}
    }

    public void skipBytes(long l) {
        this.index = (int)((long)this.index + l);
    }

    public short readUnsignedByte() {
        return (short)(this.data[this.index++] & 0xFF);
    }

    public int readUnsignedShort() {
        byte[] byArray = this.data;
        return this.data[this.index++] & 0xFF | (byArray[this.index++] & 0xFF) << 8;
    }

    public long readUnsignedInt() {
        byte[] byArray = this.data;
        return (long)(this.data[this.index++] & 0xFF) | (long)(byArray[this.index++] & 0xFF) << 8 | (long)(byArray[this.index++] & 0xFF) << 16 | (long)(byArray[this.index++] & 0xFF) << 24;
    }

    public byte readByte() {
        return this.data[this.index++];
    }

    public short readShort() {
        byte[] byArray = this.data;
        return (short)(this.data[this.index++] & 0xFF | (byArray[this.index++] & 0xFF) << 8);
    }

    public int readInt() {
        byte[] byArray = this.data;
        return (int)((long)(this.data[this.index++] & 0xFF) | (long)(byArray[this.index++] & 0xFF) << 8 | (long)(byArray[this.index++] & 0xFF) << 16 | (long)(byArray[this.index++] & 0xFF) << 24);
    }

    public long readLong() {
        byte[] byArray = this.data;
        return (long)(this.data[this.index++] & 0xFF) | (long)(byArray[this.index++] & 0xFF) << 8 | (long)(byArray[this.index++] & 0xFF) << 16 | (long)(byArray[this.index++] & 0xFF) << 24 | (long)(byArray[this.index++] & 0xFF) << 32 | (long)(byArray[this.index++] & 0xFF) << 40 | (long)(byArray[this.index++] & 0xFF) << 48 | (long)(byArray[this.index++] & 0xFF) << 56;
    }

    public void readFully(byte[] byArray) {
        System.arraycopy(this.data, this.index, byArray, 0, byArray.length);
        this.index += byArray.length;
    }

    public String readString(int n, String string) {
        String string2;
        try {
            string2 = new String(this.data, this.index, n, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMACException("Unsupported encoding", unsupportedEncodingException);
        }
        this.index += n;
        return string2;
    }

    public String readString(String string) {
        String string2;
        int n = 0;
        int n2 = this.index;
        while (this.data[n2] != 0) {
            ++n;
            ++n2;
        }
        try {
            string2 = new String(this.data, this.index, n, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMACException("Unsupported encoding", unsupportedEncodingException);
        }
        this.index += n + 1;
        return string2;
    }
}

