/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.ogg.jorbis;

import de.quippy.ogg.jogg.Buffer;
import de.quippy.ogg.jorbis.Block;
import de.quippy.ogg.jorbis.CodeBook;
import de.quippy.ogg.jorbis.DspState;
import de.quippy.ogg.jorbis.FuncFloor;
import de.quippy.ogg.jorbis.Info;
import de.quippy.ogg.jorbis.InfoMode;
import de.quippy.ogg.jorbis.Lpc;
import de.quippy.ogg.jorbis.Lsp;
import de.quippy.ogg.jorbis.Util;

class Floor0
extends FuncFloor {
    float[] lsp = null;

    Floor0() {
    }

    @Override
    void pack(Object object, Buffer buffer) {
        InfoFloor0 infoFloor0 = (InfoFloor0)object;
        buffer.write(infoFloor0.order, 8);
        buffer.write(infoFloor0.rate, 16);
        buffer.write(infoFloor0.barkmap, 16);
        buffer.write(infoFloor0.ampbits, 6);
        buffer.write(infoFloor0.ampdB, 8);
        buffer.write(infoFloor0.numbooks - 1, 4);
        int n = 0;
        while (n < infoFloor0.numbooks) {
            buffer.write(infoFloor0.books[n], 8);
            ++n;
        }
    }

    @Override
    Object unpack(Info info, Buffer buffer) {
        InfoFloor0 infoFloor0 = new InfoFloor0();
        infoFloor0.order = buffer.read(8);
        infoFloor0.rate = buffer.read(16);
        infoFloor0.barkmap = buffer.read(16);
        infoFloor0.ampbits = buffer.read(6);
        infoFloor0.ampdB = buffer.read(8);
        infoFloor0.numbooks = buffer.read(4) + 1;
        if (infoFloor0.order < 1 || infoFloor0.rate < 1 || infoFloor0.barkmap < 1 || infoFloor0.numbooks < 1) {
            return null;
        }
        int n = 0;
        while (n < infoFloor0.numbooks) {
            infoFloor0.books[n] = buffer.read(8);
            if (infoFloor0.books[n] < 0 || infoFloor0.books[n] >= info.books) {
                return null;
            }
            ++n;
        }
        return infoFloor0;
    }

    @Override
    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        InfoFloor0 infoFloor0 = (InfoFloor0)object;
        LookFloor0 lookFloor0 = new LookFloor0();
        lookFloor0.m = infoFloor0.order;
        lookFloor0.n = info.blocksizes[infoMode.blockflag] / 2;
        lookFloor0.ln = infoFloor0.barkmap;
        lookFloor0.vi = infoFloor0;
        lookFloor0.lpclook.init(lookFloor0.ln, lookFloor0.m);
        float f = (float)lookFloor0.ln / Floor0.toBARK((float)((double)infoFloor0.rate / 2.0));
        lookFloor0.linearmap = new int[lookFloor0.n];
        int n = 0;
        while (n < lookFloor0.n) {
            int n2 = (int)Math.floor(Floor0.toBARK((float)((double)infoFloor0.rate / 2.0 / (double)lookFloor0.n * (double)n)) * f);
            if (n2 >= lookFloor0.ln) {
                n2 = lookFloor0.ln;
            }
            lookFloor0.linearmap[n] = n2;
            ++n;
        }
        return lookFloor0;
    }

    static float toBARK(float f) {
        return (float)(13.1 * Math.atan(7.4E-4 * (double)f) + 2.24 * Math.atan((double)(f * f) * 1.85E-8) + 1.0E-4 * (double)f);
    }

    @Override
    void free_info(Object object) {
    }

    @Override
    void free_look(Object object) {
    }

    @Override
    void free_state(Object object) {
    }

    @Override
    int forward(Block block, Object object, float[] fArray, float[] fArray2, Object object2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    int inverse(Block block, Object object, float[] fArray) {
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        int n = block.opb.read(infoFloor0.ampbits);
        if (n > 0) {
            int n2 = (1 << infoFloor0.ampbits) - 1;
            float f = (float)n / (float)n2 * (float)infoFloor0.ampdB;
            int n3 = block.opb.read(Util.ilog(infoFloor0.numbooks));
            if (n3 != -1 && n3 < infoFloor0.numbooks) {
                Floor0 floor0 = this;
                synchronized (floor0) {
                    if (this.lsp == null || this.lsp.length < lookFloor0.m) {
                        this.lsp = new float[lookFloor0.m];
                    } else {
                        int n4 = 0;
                        while (n4 < lookFloor0.m) {
                            this.lsp[n4] = 0.0f;
                            ++n4;
                        }
                    }
                    CodeBook codeBook = block.vd.fullbooks[infoFloor0.books[n3]];
                    float f2 = 0.0f;
                    int n5 = 0;
                    while (n5 < lookFloor0.m) {
                        fArray[n5] = 0.0f;
                        ++n5;
                    }
                    n5 = 0;
                    while (n5 < lookFloor0.m) {
                        if (codeBook.decodevs(this.lsp, n5, block.opb, 1, -1) == -1) {
                            int n6 = 0;
                            while (n6 < lookFloor0.n) {
                                fArray[n6] = 0.0f;
                                ++n6;
                            }
                            return 0;
                        }
                        n5 += codeBook.dim;
                    }
                    n5 = 0;
                    while (n5 < lookFloor0.m) {
                        int n7 = 0;
                        while (n7 < codeBook.dim) {
                            int n8 = n5++;
                            this.lsp[n8] = this.lsp[n8] + f2;
                            ++n7;
                        }
                        f2 = this.lsp[n5 - 1];
                    }
                    Lsp.lsp_to_curve(fArray, lookFloor0.linearmap, lookFloor0.n, lookFloor0.ln, this.lsp, lookFloor0.m, f, infoFloor0.ampdB);
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    Object inverse1(Block block, Object object, Object object2) {
        int n;
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        float[] fArray = null;
        if (object2 instanceof float[]) {
            fArray = (float[])object2;
        }
        if ((n = block.opb.read(infoFloor0.ampbits)) > 0) {
            int n2 = (1 << infoFloor0.ampbits) - 1;
            float f = (float)n / (float)n2 * (float)infoFloor0.ampdB;
            int n3 = block.opb.read(Util.ilog(infoFloor0.numbooks));
            if (n3 != -1 && n3 < infoFloor0.numbooks) {
                int n4;
                CodeBook codeBook = block.vd.fullbooks[infoFloor0.books[n3]];
                float f2 = 0.0f;
                if (fArray == null || fArray.length < lookFloor0.m + 1) {
                    fArray = new float[lookFloor0.m + 1];
                } else {
                    n4 = 0;
                    while (n4 < fArray.length) {
                        fArray[n4] = 0.0f;
                        ++n4;
                    }
                }
                n4 = 0;
                while (n4 < lookFloor0.m) {
                    if (codeBook.decodev_set(fArray, n4, block.opb, codeBook.dim) == -1) {
                        return null;
                    }
                    n4 += codeBook.dim;
                }
                n4 = 0;
                while (n4 < lookFloor0.m) {
                    int n5 = 0;
                    while (n5 < codeBook.dim) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] + f2;
                        ++n5;
                    }
                    f2 = fArray[n4 - 1];
                }
                fArray[lookFloor0.m] = f;
                return fArray;
            }
        }
        return null;
    }

    @Override
    int inverse2(Block block, Object object, Object object2, float[] fArray) {
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        if (object2 != null) {
            float[] fArray2 = (float[])object2;
            float f = fArray2[lookFloor0.m];
            Lsp.lsp_to_curve(fArray, lookFloor0.linearmap, lookFloor0.n, lookFloor0.ln, fArray2, lookFloor0.m, f, infoFloor0.ampdB);
            return 1;
        }
        int n = 0;
        while (n < lookFloor0.n) {
            fArray[n] = 0.0f;
            ++n;
        }
        return 0;
    }

    static float fromdB(float f) {
        return (float)Math.exp((double)f * 0.11512925);
    }

    static void lsp_to_lpc(float[] fArray, float[] fArray2, int n) {
        int n2 = n / 2;
        float[] fArray3 = new float[n2];
        float[] fArray4 = new float[n2];
        float[] fArray5 = new float[n2 + 1];
        float[] fArray6 = new float[n2 + 1];
        float[] fArray7 = new float[n2];
        float[] fArray8 = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray3[n3] = (float)(-2.0 * Math.cos(fArray[n3 * 2]));
            fArray4[n3] = (float)(-2.0 * Math.cos(fArray[n3 * 2 + 1]));
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            fArray5[n4] = 0.0f;
            fArray6[n4] = 1.0f;
            fArray7[n4] = 0.0f;
            fArray8[n4] = 1.0f;
            ++n4;
        }
        fArray6[n4] = 1.0f;
        fArray5[n4] = 1.0f;
        n3 = 1;
        while (n3 < n + 1) {
            float f = 0.0f;
            float f2 = 0.0f;
            n4 = 0;
            while (n4 < n2) {
                float f3 = fArray3[n4] * fArray6[n4] + fArray5[n4];
                fArray5[n4] = fArray6[n4];
                fArray6[n4] = f2;
                f2 += f3;
                f3 = fArray4[n4] * fArray8[n4] + fArray7[n4];
                fArray7[n4] = fArray8[n4];
                fArray8[n4] = f;
                f += f3;
                ++n4;
            }
            fArray2[n3 - 1] = (f2 + fArray6[n4] + f - fArray5[n4]) / 2.0f;
            fArray6[n4] = f2;
            fArray5[n4] = f;
            ++n3;
        }
    }

    static void lpc_to_curve(float[] fArray, float[] fArray2, float f, LookFloor0 lookFloor0, String string, int n) {
        float[] fArray3 = new float[Math.max(lookFloor0.ln * 2, lookFloor0.m * 2 + 2)];
        if (f == 0.0f) {
            int n2 = 0;
            while (n2 < lookFloor0.n) {
                fArray[n2] = 0.0f;
                ++n2;
            }
            return;
        }
        lookFloor0.lpclook.lpc_to_curve(fArray3, fArray2, f);
        int n3 = 0;
        while (n3 < lookFloor0.n) {
            fArray[n3] = fArray3[lookFloor0.linearmap[n3]];
            ++n3;
        }
    }

    private static class InfoFloor0 {
        int order;
        int rate;
        int barkmap;
        int ampbits;
        int ampdB;
        int numbooks;
        int[] books = new int[16];

        private InfoFloor0() {
        }
    }

    private static class LookFloor0 {
        int n;
        int ln;
        int m;
        int[] linearmap;
        InfoFloor0 vi;
        Lpc lpclook = new Lpc();

        private LookFloor0() {
        }
    }
}

