/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.common;

public class SIDEndian {
    public static final int SID_WORDS_BIGENDIAN = 0;
    public static final int SID_WORDS_LITTLEENDIAN = 1;
    public static final int SID_WORDS = 1;

    public static final int endian_16lo8(int n, short s) {
        n &= 0xFF00;
        return n |= s;
    }

    public static final short endian_16lo8(int n) {
        return (short)(n & 0xFF);
    }

    public static final int endian_16hi8(int n, short s) {
        n &= 0xFF;
        return n |= s << 8;
    }

    public static final short endian_16hi8(int n) {
        return (short)(n >> 8 & 0xFF);
    }

    public static final int endian_16swap8(int n) {
        short s = SIDEndian.endian_16lo8(n);
        short s2 = SIDEndian.endian_16hi8(n);
        n = 0;
        n = SIDEndian.endian_16lo8(n, s2);
        n |= SIDEndian.endian_16hi8(n, s);
        return n;
    }

    public static final int endian_16(short s, short s2) {
        int n = 0;
        n = SIDEndian.endian_16lo8(n, s2);
        n |= SIDEndian.endian_16hi8(n, s);
        return n;
    }

    public static final void endian_16(short[] sArray, int n, int n2) {
        sArray[n + 0] = SIDEndian.endian_16lo8(n2);
        sArray[n + 1] = SIDEndian.endian_16hi8(n2);
    }

    public static final void endian_16(char[] cArray, int n, int n2) {
        short[] sArray = new short[]{(short)cArray[n + 0], (short)cArray[n + 1]};
        SIDEndian.endian_16(sArray, 0, n2);
        cArray[n + 0] = (char)sArray[0];
        cArray[n + 1] = (char)sArray[1];
    }

    public static final int endian_little16(short[] sArray, int n) {
        return SIDEndian.endian_16(sArray[n + 1], sArray[n + 0]);
    }

    public static final void endian_little16(short[] sArray, int n, int n2) {
        sArray[n + 0] = SIDEndian.endian_16lo8(n2);
        sArray[n + 1] = SIDEndian.endian_16hi8(n2);
    }

    public static final int endian_big16(short[] sArray, int n) {
        return SIDEndian.endian_16(sArray[n + 0], sArray[n + 1]);
    }

    public static final void endian_big16(short[] sArray, int n, int n2) {
        sArray[n + 0] = SIDEndian.endian_16hi8(n2);
        sArray[n + 1] = SIDEndian.endian_16lo8(n2);
    }

    public static final long endian_32lo16(long l, int n) {
        l &= 0xFFFFFFFFFFFF0000L;
        return l |= (long)n;
    }

    public static final int endian_32lo16(long l) {
        return (int)l & 0xFFFF;
    }

    public static final long endian_32hi16(long l, int n) {
        l &= 0xFFFFL;
        return l |= (long)n << 16;
    }

    public static final int endian_32hi16(long l) {
        return (int)l >> 16;
    }

    public static final long endian_32lo8(long l, short s) {
        l &= 0xFFFFFFFFFFFFFF00L;
        return l |= (long)s;
    }

    public static final short endian_32lo8(long l) {
        return (short)(l & 0xFFL);
    }

    public static final long endian_32hi8(long l, short s) {
        l &= 0xFFFFFFFFFFFF00FFL;
        return l |= (long)s << 8;
    }

    public static final short endian_32hi8(long l) {
        return (short)(l >> 8 & 0xFFL);
    }

    public static final long endian_32swap16(long l) {
        int n = SIDEndian.endian_32lo16(l);
        int n2 = SIDEndian.endian_32hi16(l);
        l = 0L;
        l |= SIDEndian.endian_32lo16(l, n2);
        l |= SIDEndian.endian_32hi16(l, n);
        return l;
    }

    public static final long endian_32swap8(long l) {
        int n = SIDEndian.endian_32lo16(l);
        int n2 = SIDEndian.endian_32hi16(l);
        n = SIDEndian.endian_16swap8(n);
        n2 = SIDEndian.endian_16swap8(n2);
        l = 0L;
        l |= SIDEndian.endian_32lo16(l, n2);
        l |= SIDEndian.endian_32hi16(l, n);
        return l;
    }

    public static final long endian_32(short s, short s2, short s3, short s4) {
        long l = 0L;
        int n = 0;
        l = SIDEndian.endian_32lo8(l, s4);
        l |= SIDEndian.endian_32hi8(l, s3);
        n = SIDEndian.endian_16lo8(n, s2);
        n |= SIDEndian.endian_16hi8(n, s);
        l |= SIDEndian.endian_32hi16(l, n);
        return l;
    }

    public static final long endian_little32(short[] sArray, int n) {
        return SIDEndian.endian_32(sArray[n + 3], sArray[n + 2], sArray[n + 1], sArray[n + 0]);
    }

    public static final void endian_little32(short[] sArray, int n, long l) {
        int n2 = 0;
        sArray[n + 0] = SIDEndian.endian_32lo8(l);
        sArray[n + 1] = SIDEndian.endian_32hi8(l);
        n2 = SIDEndian.endian_32hi16(l);
        sArray[n + 2] = SIDEndian.endian_16lo8(n2);
        sArray[n + 3] = SIDEndian.endian_16hi8(n2);
    }

    public static final long endian_big32(short[] sArray, int n) {
        return SIDEndian.endian_32(sArray[n + 0], sArray[n + 1], sArray[n + 2], sArray[n + 3]);
    }

    public static final void endian_big32(short[] sArray, int n, long l) {
        int n2 = 0;
        n2 = SIDEndian.endian_32hi16(l);
        sArray[n + 1] = SIDEndian.endian_16lo8(n2);
        sArray[n + 0] = SIDEndian.endian_16hi8(n2);
        sArray[n + 2] = SIDEndian.endian_32hi8(l);
        sArray[n + 3] = SIDEndian.endian_32lo8(l);
    }
}

