/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.resid_builder;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.resid_builder.ReSID;
import de.quippy.sidplay.resid_builder.sid_filter_t;
import java.util.ArrayList;

public class ReSIDBuilder
extends SIDBuilder {
    protected ArrayList<SIDEmu> sidobjs = new ArrayList();
    private static final String ERR_FILTER_DEFINITION = "RESID ERROR: Filter definition is not valid (see docs).";
    private String m_error = "N/A";

    public ReSIDBuilder(String string) {
        super(string);
    }

    public int devices(boolean bl) {
        this.m_status = true;
        if (bl) {
            return this.sidobjs.size();
        }
        return 0;
    }

    public int create(int n) {
        ReSID reSID = null;
        this.m_status = true;
        int n2 = this.devices(false);
        if (!this.m_status) {
            this.m_status = false;
            return n2;
        }
        if (n2 != 0 && n2 < n) {
            n = n2;
        }
        n2 = 0;
        while (n2 < n) {
            reSID = new ReSID(this);
            if (!reSID.bool()) {
                this.m_error = reSID.error();
                this.m_status = false;
                reSID = null;
                return n2;
            }
            this.sidobjs.add(reSID);
            ++n2;
        }
        return n2;
    }

    @Override
    public SIDEmu lock(C64Env c64Env, ISID2Types.sid2_model_t sid2_model_t2) {
        int n = this.sidobjs.size();
        this.m_status = true;
        int n2 = 0;
        while (n2 < n) {
            ReSID reSID = (ReSID)this.sidobjs.get(n2);
            if (reSID.lock(c64Env)) {
                reSID.model(sid2_model_t2);
                return reSID;
            }
            ++n2;
        }
        this.m_status = false;
        this.m_error = String.valueOf(this.name()) + " ERROR: No available SIDs to lock";
        return null;
    }

    @Override
    public void unlock(SIDEmu sIDEmu) {
        int n = this.sidobjs.size();
        int n2 = 0;
        while (n2 < n) {
            ReSID reSID = (ReSID)this.sidobjs.get(n2);
            if (reSID == sIDEmu) {
                reSID.lock(null);
                break;
            }
            ++n2;
        }
    }

    public void remove() {
        int n = this.sidobjs.size();
        int n2 = 0;
        while (n2 < n) {
            this.sidobjs.remove(this.sidobjs.get(n2));
            ++n2;
        }
        this.sidobjs.clear();
    }

    @Override
    public final String error() {
        return this.m_error;
    }

    @Override
    public final String credits() {
        this.m_status = true;
        if (this.sidobjs.size() != 0) {
            ReSID reSID = (ReSID)this.sidobjs.get(0);
            return reSID.credits();
        }
        ReSID reSID = new ReSID(this);
        return reSID.credits();
    }

    public void filter(boolean bl) {
        int n = this.sidobjs.size();
        this.m_status = true;
        int n2 = 0;
        while (n2 < n) {
            ReSID reSID = (ReSID)this.sidobjs.get(n2);
            reSID.filter(bl);
            ++n2;
        }
    }

    public void filter(sid_filter_t sid_filter_t2) {
        int n = this.sidobjs.size();
        this.m_status = true;
        int n2 = 0;
        while (n2 < n) {
            ReSID reSID = (ReSID)this.sidobjs.get(n2);
            if (!reSID.filter(sid_filter_t2)) {
                this.m_error = ERR_FILTER_DEFINITION;
                this.m_status = false;
            }
            ++n2;
        }
    }

    public void sampling(long l) {
        int n = this.sidobjs.size();
        this.m_status = true;
        int n2 = 0;
        while (n2 < n) {
            ReSID reSID = (ReSID)this.sidobjs.get(n2);
            reSID.sampling(l);
            ++n2;
        }
    }
}

