/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.vorbis.sampled.file;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.vorbis.sampled.file.VorbisAudioFileFormat;
import javazoom.spi.vorbis.sampled.file.VorbisAudioFormat;
import javazoom.spi.vorbis.sampled.file.VorbisEncoding;
import javazoom.spi.vorbis.sampled.file.VorbisFileFormatType;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class VorbisAudioFileReader
extends TAudioFileReader {
    private SyncState oggSyncState_ = null;
    private StreamState oggStreamState_ = null;
    private Page oggPage_ = null;
    private Packet oggPacket_ = null;
    private Info vorbisInfo = null;
    private Comment vorbisComment = null;
    private DspState vorbisDspState = null;
    private Block vorbisBlock = null;
    private int bufferMultiple_ = 4;
    private int bufferSize_ = this.bufferMultiple_ * 256 * 2;
    private byte[] buffer = null;
    private int bytes = 0;
    private int index = 0;
    private InputStream oggBitStream_ = null;
    private static final int INITAL_READ_LENGTH = 64000;
    private static final int MARK_LIMIT = 64001;

    public VorbisAudioFileReader() {
        super(64001, true);
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioFileFormat(File file)");
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            inputStream.mark(64001);
            inputStream.reset();
            VorbisFile vf = new VorbisFile(file.getAbsolutePath());
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, (int)file.length(), Math.round(vf.time_total(-1) * 1000.0f));
            return audioFileFormat;
        }
        catch (JOrbisException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioFileFormat(URL url)");
        }
        InputStream inputStream = url.openStream();
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioFileFormat(InputStream inputStream)");
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(64001);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, -1, -1);
            return audioFileFormat;
        }
        finally {
            inputStream.reset();
        }
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream, long medialength) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, (int)medialength, -1);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream bitStream, int mediaLength, int totalms) throws UnsupportedAudioFileException, IOException {
        HashMap<String, Number> aff_properties = new HashMap<String, Number>();
        HashMap<String, Constable> af_properties = new HashMap<String, Constable>();
        if (totalms == -1) {
            totalms = 0;
        }
        if (totalms <= 0) {
            totalms = 0;
        } else {
            aff_properties.put("duration", new Long(totalms * 1000));
        }
        this.oggBitStream_ = bitStream;
        this.init_jorbis();
        this.index = 0;
        try {
            this.readHeaders(aff_properties, af_properties);
        }
        catch (IOException ioe) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out(ioe.getMessage());
            }
            throw new UnsupportedAudioFileException(ioe.getMessage());
        }
        String dmp = this.vorbisInfo.toString();
        if (TDebug.TraceAudioFileReader) {
            TDebug.out(dmp);
        }
        int ind = dmp.lastIndexOf("bitrate:");
        int minbitrate = -1;
        int nominalbitrate = -1;
        int maxbitrate = -1;
        if (ind != -1) {
            StringTokenizer st = new StringTokenizer(dmp = dmp.substring(ind + 8, dmp.length()), ",");
            if (st.hasMoreTokens()) {
                minbitrate = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                nominalbitrate = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                maxbitrate = Integer.parseInt(st.nextToken());
            }
        }
        if (nominalbitrate > 0) {
            af_properties.put("bitrate", new Integer(nominalbitrate));
        }
        af_properties.put("vbr", Boolean.TRUE);
        if (minbitrate > 0) {
            aff_properties.put("ogg.bitrate.min.bps", new Integer(minbitrate));
        }
        if (maxbitrate > 0) {
            aff_properties.put("ogg.bitrate.max.bps", new Integer(maxbitrate));
        }
        if (nominalbitrate > 0) {
            aff_properties.put("ogg.bitrate.nominal.bps", new Integer(nominalbitrate));
        }
        if (this.vorbisInfo.channels > 0) {
            aff_properties.put("ogg.channels", new Integer(this.vorbisInfo.channels));
        }
        if (this.vorbisInfo.rate > 0) {
            aff_properties.put("ogg.frequency.hz", new Integer(this.vorbisInfo.rate));
        }
        if (mediaLength > 0) {
            aff_properties.put("ogg.length.bytes", new Integer(mediaLength));
        }
        aff_properties.put("ogg.version", new Integer(this.vorbisInfo.version));
        float frameRate = -1.0f;
        if (nominalbitrate > 0) {
            frameRate = nominalbitrate / 8;
        } else if (minbitrate > 0) {
            frameRate = minbitrate / 8;
        }
        AudioFormat.Encoding encoding = VorbisEncoding.VORBISENC;
        VorbisAudioFormat format = new VorbisAudioFormat(encoding, (float)this.vorbisInfo.rate, -1, this.vorbisInfo.channels, 1, frameRate, false, af_properties);
        return new VorbisAudioFileFormat(VorbisFileFormatType.OGG, format, -1, mediaLength, aff_properties);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioInputStream(InputStream inputStream)");
        }
        return this.getAudioInputStream(inputStream, -1, -1);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream, int medialength, int totalms) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioInputStream(InputStream inputStreamint medialength, int totalms)");
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(64001);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, medialength, totalms);
            inputStream.reset();
            return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
        }
        catch (UnsupportedAudioFileException e) {
            inputStream.reset();
            throw e;
        }
        catch (IOException e) {
            inputStream.reset();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioInputStream(File file)");
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
            throw e;
        }
        catch (IOException e) {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioInputStream(URL url)");
        }
        InputStream inputStream = url.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw e;
        }
        catch (IOException e) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw e;
        }
    }

    private void readHeaders(HashMap aff_properties, HashMap af_properties) throws IOException {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("readHeaders(");
        }
        this.index = this.oggSyncState_.buffer(this.bufferSize_);
        this.buffer = this.oggSyncState_.data;
        this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
        if (this.bytes == -1) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Cannot get any data from selected Ogg bitstream.");
            }
            throw new IOException("Cannot get any data from selected Ogg bitstream.");
        }
        this.oggSyncState_.wrote(this.bytes);
        if (this.oggSyncState_.pageout(this.oggPage_) != 1) {
            if (this.bytes < this.bufferSize_) {
                throw new IOException("EOF");
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Input does not appear to be an Ogg bitstream.");
            }
            throw new IOException("Input does not appear to be an Ogg bitstream.");
        }
        this.oggStreamState_.init(this.oggPage_.serialno());
        this.vorbisInfo.init();
        this.vorbisComment.init();
        aff_properties.put("ogg.serial", new Integer(this.oggPage_.serialno()));
        if (this.oggStreamState_.pagein(this.oggPage_) < 0) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Error reading first page of Ogg bitstream data.");
            }
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        if (this.oggStreamState_.packetout(this.oggPacket_) != 1) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Error reading initial header packet.");
            }
            throw new IOException("Error reading initial header packet.");
        }
        if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_) < 0) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("This Ogg bitstream does not contain Vorbis audio data.");
            }
            throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
        }
        int i = 0;
        while (i < 2) {
            int result;
            while (i < 2 && (result = this.oggSyncState_.pageout(this.oggPage_)) != 0) {
                if (result != 1) continue;
                this.oggStreamState_.pagein(this.oggPage_);
                while (i < 2 && (result = this.oggStreamState_.packetout(this.oggPacket_)) != 0) {
                    if (result == -1) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("Corrupt secondary header.  Exiting.");
                        }
                        throw new IOException("Corrupt secondary header.  Exiting.");
                    }
                    this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_);
                    ++i;
                }
            }
            this.index = this.oggSyncState_.buffer(this.bufferSize_);
            this.buffer = this.oggSyncState_.data;
            this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
            if (this.bytes == -1) break;
            if (this.bytes == 0 && i < 2) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("End of file before finding all Vorbis headers!");
                }
                throw new IOException("End of file before finding all Vorbis  headers!");
            }
            this.oggSyncState_.wrote(this.bytes);
        }
        byte[][] ptr = this.vorbisComment.user_comments;
        String currComment = "";
        int c = 0;
        for (int j = 0; j < ptr.length && ptr[j] != null; ++j) {
            currComment = new String(ptr[j], 0, ptr[j].length - 1, "UTF-8").trim();
            if (TDebug.TraceAudioConverter) {
                TDebug.out(currComment);
            }
            if (currComment.toLowerCase().startsWith("artist")) {
                aff_properties.put("author", currComment.substring(7));
            } else if (currComment.toLowerCase().startsWith("title")) {
                aff_properties.put("title", currComment.substring(6));
            } else if (currComment.toLowerCase().startsWith("album")) {
                aff_properties.put("album", currComment.substring(6));
            } else if (currComment.toLowerCase().startsWith("date")) {
                aff_properties.put("date", currComment.substring(5));
            } else if (currComment.toLowerCase().startsWith("copyright")) {
                aff_properties.put("copyright", currComment.substring(10));
            } else if (currComment.toLowerCase().startsWith("comment")) {
                aff_properties.put("comment", currComment.substring(8));
            } else if (currComment.toLowerCase().startsWith("genre")) {
                aff_properties.put("ogg.comment.genre", currComment.substring(6));
            } else if (currComment.toLowerCase().startsWith("tracknumber")) {
                aff_properties.put("ogg.comment.track", currComment.substring(12));
            } else {
                aff_properties.put("ogg.comment.ext." + ++c, currComment);
            }
            aff_properties.put("ogg.comment.encodedby", new String(this.vorbisComment.vendor, 0, this.vorbisComment.vendor.length - 1));
        }
    }

    private int readFromStream(byte[] buffer, int index, int bufferSize_) {
        int readBytes = 0;
        try {
            readBytes = this.oggBitStream_.read(buffer, index, bufferSize_);
        }
        catch (Exception e) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("Cannot Read Selected Song");
            }
            readBytes = -1;
        }
        return readBytes;
    }

    private void init_jorbis() {
        this.oggSyncState_ = new SyncState();
        this.oggStreamState_ = new StreamState();
        this.oggPage_ = new Page();
        this.oggPacket_ = new Packet();
        this.vorbisInfo = new Info();
        this.vorbisComment = new Comment();
        this.vorbisDspState = new DspState();
        this.vorbisBlock = new Block(this.vorbisDspState);
        this.buffer = null;
        this.bytes = 0;
        this.oggSyncState_.init();
    }
}

