/*
 * Decompiled with CFR 0.152.
 */
package xtrememp;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;
import xtrememp.Settings;
import xtrememp.XtremeMP;
import xtrememp.player.audio.AudioPlayer;
import xtrememp.ui.combobox.IconComboBox;
import xtrememp.ui.combobox.SkinComboSelector;
import xtrememp.ui.skin.GFXUIListener;
import xtrememp.util.Utilities;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    private final String GENERAL_PANEL = "GENERAL_PANEL";
    private final String AUDIO_PANEL = "AUDIO_PANEL";
    private final String HOTKEYS_PANEL = "HOTKEYS_PANEL";
    private AudioPlayer audioPlayer;
    private GFXUIListener gfxUIListener;
    private CardLayout cardLayout;
    private JPanel centerPanel;
    private JToggleButton generalButton;
    private JToggleButton audioButton;
    private JToggleButton hotkeysButton;
    private JComboBox languageComboBox;
    private SkinComboSelector skinComboSelector;
    private JCheckBox uiEffectsCheckbox;
    private JCheckBox updatesCheckBox;
    private JTextField cacheDirTextField;
    private JComboBox mixerComboBox;
    private JButton changeCacheDirButton;
    private JButton resetButton;
    private JButton closeButton;

    public PreferencesDialog(AudioPlayer audioPlayer, GFXUIListener gfxUIListener) {
        super((Frame)XtremeMP.getInstance().getMainFrame(), true);
        this.audioPlayer = audioPlayer;
        this.gfxUIListener = gfxUIListener;
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setTitle(Utilities.tr("Dialog.Preferences"));
        this.initComponents();
        Utilities.closeOnEscape(this);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.closeButton);
        this.closeButton.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.generalButton)) {
            this.cardLayout.show(this.centerPanel, "GENERAL_PANEL");
        } else if (source.equals(this.audioButton)) {
            this.cardLayout.show(this.centerPanel, "AUDIO_PANEL");
        } else if (source.equals(this.hotkeysButton)) {
            this.cardLayout.show(this.centerPanel, "HOTKEYS_PANEL");
        } else if (source.equals(this.languageComboBox)) {
            Settings.setLanguageIndex(this.languageComboBox.getSelectedIndex());
        } else if (source.equals(this.uiEffectsCheckbox)) {
            Settings.setUIEffectsEnabled(this.uiEffectsCheckbox.isSelected());
            this.gfxUIListener.guiEffectsStateChanged(this.uiEffectsCheckbox.isSelected());
        } else if (source.equals(this.updatesCheckBox)) {
            Settings.setAutomaticUpdatesEnabled(this.updatesCheckBox.isSelected());
        } else if (source.equals(this.changeCacheDirButton)) {
            JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
            fileChooser.setDialogTitle(Utilities.tr("Dialog.Preferences.General.CacheDirectory.SelectCacheDir"));
            fileChooser.setFileSelectionMode(1);
            while (fileChooser.showOpenDialog(this) == 0) {
                File cacheDir = fileChooser.getSelectedFile();
                if (cacheDir.canRead() && cacheDir.canWrite()) {
                    Settings.setCacheDir(cacheDir);
                    this.cacheDirTextField.setText(Settings.getCacheDir().getPath());
                    break;
                }
                Object[] options = new Object[]{Utilities.tr("Button.Close")};
                JOptionPane.showOptionDialog(this.getParent(), Utilities.tr("Dialog.Preferences.General.CacheDirectory.NoReadWritePermissions"), Utilities.tr("Dialog.OptionDialog.Warning"), 0, 2, null, options, options[0]);
            }
        } else if (source.equals(this.mixerComboBox)) {
            String mixerName = (String)this.mixerComboBox.getSelectedItem();
            this.audioPlayer.setMixerName(mixerName);
            Settings.setMixerName(mixerName);
        } else if (!source.equals(this.resetButton) && source.equals(this.closeButton)) {
            this.dispose();
        }
    }

    private void initComponents() {
        Container container = this.getContentPane();
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(Box.createHorizontalGlue());
        this.generalButton = new JToggleButton(Utilities.tr("Dialog.Preferences.General"), Utilities.PREFERENCES_SYSTEM_ICON);
        this.generalButton.setVerticalTextPosition(3);
        this.generalButton.setHorizontalTextPosition(0);
        this.generalButton.setMnemonic(71);
        this.generalButton.setSelected(true);
        this.generalButton.addActionListener(this);
        toolBar.add(this.generalButton);
        this.audioButton = new JToggleButton(Utilities.tr("Dialog.Preferences.Audio"), Utilities.AUDIO_CARD_ICON);
        this.audioButton.setVerticalTextPosition(3);
        this.audioButton.setHorizontalTextPosition(0);
        this.audioButton.setMnemonic(65);
        this.audioButton.addActionListener(this);
        toolBar.add(this.audioButton);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.generalButton);
        bg.add(this.audioButton);
        bg.add(this.hotkeysButton);
        toolBar.add(Box.createHorizontalGlue());
        container.add((Component)toolBar, "north");
        this.cardLayout = new CardLayout();
        this.centerPanel = new JPanel(this.cardLayout);
        JPanel generalPanel = new JPanel((LayoutManager)new MigLayout("ins 8,fillx"));
        this.addTextSeparator(generalPanel, Utilities.tr("Dialog.Preferences.General.Interface"));
        generalPanel.add(new JLabel(Utilities.tr("Dialog.Preferences.General.Interface.Language"), 10));
        this.languageComboBox = new IconComboBox<Locale>(Utilities.getLanguages()){

            @Override
            public String getCaption(Locale item) {
                if (item.equals(Utilities.getSystemLocale())) {
                    return "Auto";
                }
                String dl = item.getDisplayLanguage(item);
                String dl2Prefix = dl.substring(0, 1).toUpperCase();
                String dl2Suffix = dl.substring(1, dl.length()).toLowerCase();
                String dl2 = dl2Prefix.concat(dl2Suffix);
                return dl2;
            }

            @Override
            public Icon getItemIcon(Locale item) {
                if (!item.equals(Utilities.getSystemLocale())) {
                    return Utilities.getIcon("flags/" + item.getLanguage() + ".png");
                }
                return null;
            }
        };
        this.languageComboBox.setSelectedIndex(Settings.getLanguageIndex());
        this.languageComboBox.addActionListener(this);
        generalPanel.add((Component)this.languageComboBox, "span,growx");
        generalPanel.add(new JLabel(Utilities.tr("Dialog.Preferences.General.Interface.Skin"), 10));
        this.skinComboSelector = new SkinComboSelector();
        generalPanel.add((Component)this.skinComboSelector, "span,growx");
        generalPanel.add(new JLabel(Utilities.tr("Dialog.Preferences.General.Interface.UIEffects"), 10));
        this.uiEffectsCheckbox = new JCheckBox();
        this.uiEffectsCheckbox.setSelected(Settings.isUIEffectsEnabled());
        this.uiEffectsCheckbox.addActionListener(this);
        generalPanel.add((Component)this.uiEffectsCheckbox, "span,growx");
        this.addTextSeparator(generalPanel, Utilities.tr("Dialog.Preferences.General.Updates"));
        this.updatesCheckBox = new JCheckBox(Utilities.tr("Dialog.Preferences.General.Updates.CheckForUpdatesOnStartup"));
        this.updatesCheckBox.setSelected(Settings.isAutomaticUpdatesEnabled());
        this.updatesCheckBox.addActionListener(this);
        generalPanel.add((Component)this.updatesCheckBox, "span,growx");
        this.addTextSeparator(generalPanel, Utilities.tr("Dialog.Preferences.General.CacheDirectory"));
        this.cacheDirTextField = new JTextField(Settings.getCacheDir().getPath());
        generalPanel.add((Component)this.cacheDirTextField, "span,growx,split");
        this.changeCacheDirButton = new JButton(Utilities.tr("Button.Change"));
        this.changeCacheDirButton.addActionListener(this);
        generalPanel.add((Component)this.changeCacheDirButton, "wrap");
        this.centerPanel.add((Component)generalPanel, "GENERAL_PANEL");
        JPanel audioPanel = new JPanel((LayoutManager)new MigLayout("ins 8,fillx"));
        this.addTextSeparator(audioPanel, Utilities.tr("Dialog.Preferences.Audio.PlaybackDevice"));
        audioPanel.add(new JLabel(Utilities.tr("Dialog.Preferences.Audio.PlaybackDevice.Mixer"), 10));
        this.mixerComboBox = new JComboBox<Object>(this.audioPlayer.getMixers().toArray());
        this.mixerComboBox.setSelectedItem(Settings.getMixerName());
        this.mixerComboBox.addActionListener(this);
        audioPanel.add((Component)this.mixerComboBox, "span,growx");
        this.centerPanel.add((Component)audioPanel, "AUDIO_PANEL");
        JPanel hotkeysPanel = new JPanel((LayoutManager)new MigLayout("ins 8,fillx"));
        this.centerPanel.add((Component)hotkeysPanel, "HOTKEYS_PANEL");
        container.add((Component)this.centerPanel, "center");
        JPanel southPanel = new JPanel((LayoutManager)new MigLayout("nogrid, fillx, aligny 100%, gapy unrel"));
        this.closeButton = new JButton(Utilities.tr("Button.Close"));
        this.closeButton.addActionListener(this);
        southPanel.add((Component)this.closeButton, "tag cancel");
        container.add((Component)southPanel, "south");
    }

    private void addTextSeparator(JPanel panel, String text) {
        JLabel label = new JLabel(text, 10);
        label.setFont(label.getFont().deriveFont(1));
        panel.add((Component)label, "gapbottom 1, span, split 2, aligny center");
        panel.add((Component)new JSeparator(), "gapleft rel, growx");
    }
}

