/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.player.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;

public class EqAudioInputStream
extends TAsynchronousFilteredAudioInputStream {
    private final Logger logger = LoggerFactory.getLogger(EqAudioInputStream.class);
    protected static final int BLOCKSIZE = 17640;
    private static final int MAX_UPPER_FREQ = 19000;
    private static final int BAND_COUNT = 10;
    private static final int STAGE_COUNT = 2;
    private static final int SAMPLING_RATE = 44100;
    private static final double FIRST_CENTER_FREQUENCY = 30.0;
    private static final float UPPER_NORM_FREQ_LOG = 0.4971f;
    private static final float LOWER_NORM_FREQ_LOG = -2.5452f;
    private double[] KBase = new double[10];
    private double[] K = new double[10];
    private double[] V = new double[10];
    private double[][] a0recip = new double[10][2];
    private double[] c = new double[2];
    private double[] c0 = new double[10];
    private double[][][] filterstates = new double[10][2][4];
    private AudioInputStream sourceStream;
    private ByteBuffer audioDataIn;
    private ByteBuffer audioDataOut;
    private ShortBuffer shortDataIn;
    private ShortBuffer shortDataOut;
    private int nChannels;

    public EqAudioInputStream(AudioInputStream sourceStream) {
        super(sourceStream.getFormat(), sourceStream.getFrameLength());
        this.sourceStream = sourceStream;
        this.init();
    }

    public void close() throws IOException {
        super.close();
        this.sourceStream.close();
    }

    public long skip(long n) throws IOException {
        long sk = this.sourceStream.skip(n);
        return sk;
    }

    public void execute() {
        int n;
        int sampleCount;
        double[] inSamples = new double[this.nChannels * 17640 / 2];
        double[] outSamples = new double[this.nChannels * 17640 / 2];
        int nBytesRead = 0;
        try {
            nBytesRead = this.sourceStream.read(this.audioDataIn.array(), 0, 17640 * this.nChannels);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (nBytesRead == -1) {
            this.getCircularBuffer().close();
            return;
        }
        byte[] trimBuffer = this.audioDataIn.array();
        if (nBytesRead < trimBuffer.length) {
            trimBuffer = new byte[nBytesRead];
            System.arraycopy(this.audioDataIn.array(), 0, trimBuffer, 0, nBytesRead);
        }
        if (this.nChannels > 1) {
            sampleCount = nBytesRead / 2;
            for (n = 0; n < nBytesRead / 2; ++n) {
                inSamples[n] = (double)this.shortDataIn.get(n) / 32768.0;
            }
        } else {
            sampleCount = nBytesRead / 2;
            for (n = 0; n < nBytesRead / 2; ++n) {
                inSamples[n] = (double)this.shortDataIn.get(n) / 32768.0;
            }
        }
        for (n = 0; n < sampleCount; ++n) {
            outSamples[n] = this.processSample(inSamples[n]);
            double outValue = outSamples[n] * 32768.0;
            if (outValue > 32767.0) {
                outValue = 32767.0;
            }
            if (outValue < -32768.0) {
                outValue = -32768.0;
            }
            this.shortDataOut.put(n, (short)outValue);
        }
        if (nBytesRead >= 0) {
            this.getCircularBuffer().write(this.audioDataOut.array(), 0, sampleCount * 2);
        }
    }

    protected double processSample(double u) {
        double y = u;
        for (int band = 0; band < 10; ++band) {
            for (int stage = 0; stage < 2; ++stage) {
                double x4 = -this.c0[band] * (this.filterstates[band][stage][0] - this.filterstates[band][stage][1]);
                double x6 = this.filterstates[band][stage][1] + x4;
                this.filterstates[band][stage][1] = this.filterstates[band][stage][0] + x4;
                double x8 = -this.c0[band] * (this.filterstates[band][stage][2] - this.filterstates[band][stage][3]);
                double x7 = this.filterstates[band][stage][3] + x8;
                this.filterstates[band][stage][3] = this.filterstates[band][stage][2] + x8;
                double x3 = 2.0 * x6;
                double x2 = x7 + x3;
                double x1 = this.a0recip[band][stage] * (this.K[band] * u - (x7 - x3 + this.K[band] * (-2.0 * this.c[stage] * x7 + this.K[band] * x2)));
                double x5 = this.K[band] * (x1 + x2);
                this.filterstates[band][stage][0] = -x1;
                this.filterstates[band][stage][2] = -x6;
                u = y = this.V[band] * (this.V[band] * x5 + 2.0 * (x5 - this.c[stage] * (x7 - x1))) + u;
            }
        }
        return y;
    }

    public void init() {
        this.nChannels = this.getFormat().getChannels();
        this.audioDataIn = ByteBuffer.allocate(17640 * this.nChannels);
        this.audioDataIn.order(ByteOrder.LITTLE_ENDIAN);
        this.shortDataIn = this.audioDataIn.asShortBuffer();
        this.audioDataOut = ByteBuffer.allocate(17640 * this.nChannels);
        this.audioDataOut.order(ByteOrder.LITTLE_ENDIAN);
        this.shortDataOut = this.audioDataOut.asShortBuffer();
        for (int stage = 0; stage < 2; ++stage) {
            this.c[stage] = Math.cos((0.5 - (2.0 * (double)stage + 1.0) / 8.0) * Math.PI);
        }
        for (int band = 0; band < 10; ++band) {
            double fC = 30.0 * Math.pow(2.0, band);
            double fL = fC / Math.sqrt(2.0);
            double fU = fC * Math.sqrt(2.0);
            if (fU > 19000.0) {
                fU = 19000.0;
            }
            double fB = fU - fL;
            double wB = 1.4247585730565955E-4 * fB;
            double wU = 1.4247585730565955E-4 * fU;
            double wL = 1.4247585730565955E-4 * fL;
            double wM = 2.0 * Math.atan(Math.sqrt(Math.tan(wU / 2.0) * Math.tan(wL / 2.0)));
            this.KBase[band] = Math.tan(wB / 2.0);
            this.c0[band] = Math.cos(wM);
            this.setGain(band, 1.0);
        }
    }

    public void setGain(int band, int gain) {
        if (gain > 12) {
            gain = 12;
        } else if (gain < -12) {
            gain = -12;
        }
        this.setGain(band, Math.pow(10.0, (double)gain / 20.0));
    }

    protected void setGain(int band, double gain) {
        this.K[band] = Math.pow(gain, -0.125) * this.KBase[band];
        this.V[band] = Math.sqrt(gain) - 1.0;
        for (int stage = 0; stage < 2; ++stage) {
            this.a0recip[band][stage] = 1.0 / (1.0 + 2.0 * this.K[band] * this.c[stage] + this.K[band] * this.K[band]);
        }
    }
}

