/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.tag;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.tag.FlacInfo;
import xtrememp.tag.GenericInfo;
import xtrememp.tag.MpegInfo;
import xtrememp.tag.OggVorbisInfo;
import xtrememp.tag.TagInfo;
import xtrememp.util.Utilities;

public class TagInfoFactory {
    private static Logger logger = LoggerFactory.getLogger(TagInfoFactory.class);
    private static final TagInfoFactory instance = new TagInfoFactory();

    public static TagInfoFactory getInstance() {
        return instance;
    }

    public TagInfo getTagInfo(URL location) {
        TagInfo taginfo;
        try {
            taginfo = new MpegInfo();
            taginfo.load(location);
        }
        catch (UnsupportedAudioFileException ex) {
            taginfo = null;
        }
        catch (IOException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            taginfo = null;
        }
        if (taginfo == null) {
            try {
                taginfo = new OggVorbisInfo();
                taginfo.load(location);
            }
            catch (UnsupportedAudioFileException ex) {
                taginfo = null;
            }
            catch (IOException ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
                taginfo = null;
            }
        }
        if (taginfo == null) {
            try {
                taginfo = new FlacInfo();
                taginfo.load(location);
            }
            catch (UnsupportedAudioFileException ex) {
                taginfo = null;
            }
            catch (IOException ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
                taginfo = null;
            }
        }
        if (taginfo == null) {
            try {
                taginfo = new GenericInfo();
                taginfo.load(location);
            }
            catch (UnsupportedAudioFileException ex) {
                taginfo = null;
            }
            catch (IOException ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
                taginfo = null;
            }
        }
        return taginfo;
    }

    public TagInfo getTagInfo(String location) {
        if (Utilities.startWithProtocol(location)) {
            try {
                return this.getTagInfo(new URL(location));
            }
            catch (MalformedURLException ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        return this.getTagInfo(new File(location));
    }

    public TagInfo getTagInfo(File file) {
        GenericInfo taginfo = null;
        try {
            taginfo = new GenericInfo();
            ((TagInfo)taginfo).load(file);
        }
        catch (UnsupportedAudioFileException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
        }
        return taginfo;
    }
}

