/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.button.shaper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.shaper.StandardButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;

public abstract class ButtonShaper
implements SubstanceButtonShaper {
    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        if (button.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            boolean isBorderComputing = button.getClientProperty("substancelaf.buttonbordercomputing") != null;
            Border border = button.getBorder();
            int uiw = uiPreferredSize.width;
            int uih = uiPreferredSize.height;
            if (border instanceof SubstanceButtonBorder) {
                Insets bi = border.getBorderInsets(button);
                if (!isBorderComputing) {
                    button.setBorder(null);
                }
                uiPreferredSize.setSize(uiw - bi.left - bi.right, uih - bi.top - bi.bottom);
            } else {
                Insets bi = border.getBorderInsets(button);
                if (!isBorderComputing) {
                    button.setBorder(null);
                }
                uiPreferredSize.setSize(uiw - bi.left - bi.right, uih - bi.top - bi.bottom);
            }
            if (!isBorderComputing) {
                button.setBorder(this.getButtonBorder(button));
                button.putClientProperty("substancelaf.buttonbordercomputed", new String());
            }
        }
        return uiPreferredSize;
    }

    public Border getButtonBorder(AbstractButton button) {
        return new SubstanceButtonBorder(StandardButtonShaper.class){

            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 0);
            }
        };
    }

    public boolean isProportionate() {
        return true;
    }
}

