/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.label;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.swing.SwingRepaintTimeline;

public class BusyLabel
extends JLabel {
    private SwingRepaintTimeline repaintTimeline;
    private int angle;
    private boolean busy;

    public BusyLabel(Dimension size) {
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.repaintTimeline = new SwingRepaintTimeline((Component)this);
        this.repaintTimeline.addPropertyToInterpolate("angle", (Object)0, (Object)360);
        this.repaintTimeline.setDuration(36000L);
        this.repaintTimeline.setAutoRepaintMode(false);
    }

    public int getAngle() {
        return this.angle;
    }

    public void setAngle(int angle) {
        this.angle = angle;
        this.repaintTimeline.forceRepaintOnNextPulse();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
        if (busy) {
            this.repaintTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
        } else {
            this.repaintTimeline.abort();
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(2.5f, 0, 0));
        int width = this.getWidth();
        int height = this.getHeight();
        int points = 8;
        Color fgColor = this.getForeground();
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            ComponentState labelState = this.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            fgColor = SubstanceLookAndFeel.getCurrentSkin().getColorScheme((Component)this, labelState).getForegroundColor();
        }
        for (int i = 0; i < points; ++i) {
            if (this.busy) {
                int alpha = 255 * ((i + this.angle) % points) / points;
                g2d.setColor(new Color(fgColor.getRed(), fgColor.getGreen(), fgColor.getBlue(), alpha));
            } else {
                g2d.setColor(fgColor);
            }
            double a = Math.PI * 2 / (double)points;
            double x = Math.sin((double)i * a);
            double y = Math.cos((double)i * a);
            g2d.drawLine(width / 2 + (int)(5.0 * x), height / 2 + (int)(5.0 * y), width / 2 + (int)((double)(width / 2) * x), height / 2 + (int)((double)(height / 2) * y));
        }
        g2d.dispose();
    }
}

