/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class SortOrderIcon
implements Icon {
    private static final int DEFAULT_WIDTH = 10;
    private static final int DEFAULT_HEIGHT = 10;
    private Color color;
    private int width;
    private int height;
    private Polygon poly;

    public SortOrderIcon(Color color) {
        this(color, true, 10, 10);
    }

    public SortOrderIcon(Color color, boolean ascending) {
        this(color, ascending, 10, 10);
    }

    public SortOrderIcon(Color color, boolean ascending, int width, int height) {
        this.color = color;
        this.width = width;
        this.height = height;
        this.initPolygon(ascending);
    }

    private void initPolygon(boolean ascending) {
        this.poly = new Polygon();
        int halfWidth = this.width / 2;
        if (ascending) {
            this.poly.addPoint(0, this.height);
            this.poly.addPoint(halfWidth, 0);
            this.poly.addPoint(this.width, this.height);
        } else {
            this.poly.addPoint(0, 0);
            this.poly.addPoint(halfWidth, this.height);
            this.poly.addPoint(this.width, 0);
        }
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.color);
        g2d.translate(x, y);
        g2d.fillPolygon(this.poly);
        g2d.translate(-x, -y);
        g2d.dispose();
    }
}

