/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.Settings;
import xtrememp.XtremeMP;
import xtrememp.update.Version;
import xtrememp.util.Utilities;

public final class SoftwareUpdate {
    private static final Logger logger = LoggerFactory.getLogger(SoftwareUpdate.class);
    private static final String updatesURL = Utilities.tr("Application.updatesURL");
    private static final Version currentVersion = Version.getCurrentVersion();
    private static SwingWorker checkForUpdatesWorker;
    private static JDialog checkForUpdatesDialog;
    private static Version newerVersion;

    public static void checkForUpdates(final boolean showDialogs) {
        checkForUpdatesWorker = new SwingWorker<Version, Void>(){

            @Override
            protected Version doInBackground() throws Exception {
                long delayTime;
                logger.debug("checkForUpdates: started...");
                long startTime = System.currentTimeMillis();
                Version version = SoftwareUpdate.getLastVersion(new URL(updatesURL));
                if (showDialogs && (delayTime = System.currentTimeMillis() - startTime - 2000L) > 0L) {
                    Thread.sleep(delayTime);
                }
                return version;
            }

            @Override
            protected void done() {
                block13: {
                    logger.debug("checkForUpdates: done");
                    if (checkForUpdatesDialog != null && checkForUpdatesDialog.isVisible()) {
                        checkForUpdatesDialog.dispose();
                    }
                    if (!this.isCancelled()) {
                        try {
                            newerVersion = (Version)this.get();
                            if (newerVersion != null && newerVersion.compareTo(currentVersion) == 1) {
                                logger.debug("checkForUpdates: currentVersion = {}", (Object)currentVersion);
                                logger.debug("checkForUpdates: newerVersion = {}", (Object)newerVersion);
                                logger.debug("SoftwareUpdate::checkForUpdates: updates found");
                                Object[] options = new Object[]{Utilities.tr("Button.Cancel")};
                                Desktop desktop = null;
                                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                                    options = new Object[]{Utilities.tr("Button.Download"), Utilities.tr("Button.Cancel")};
                                }
                                JPanel panel = new JPanel(new BorderLayout(0, 10));
                                panel.add((Component)new JLabel("<html>" + Utilities.tr("Dialog.SoftwareUpdate.UpdatesFound") + " (" + newerVersion + ")</html>"), "Center");
                                JCheckBox hideCheckBox = null;
                                if (Settings.isAutomaticUpdatesEnabled()) {
                                    hideCheckBox = new JCheckBox(Utilities.tr("Dialog.SoftwareUpdate.DisableAutomaticCheckForUpdates"));
                                    panel.add((Component)hideCheckBox, "South");
                                }
                                int option = JOptionPane.showOptionDialog(XtremeMP.getInstance().getMainFrame(), panel, Utilities.tr("Dialog.SoftwareUpdate"), 2, 3, null, options, options[0]);
                                if (hideCheckBox != null) {
                                    Settings.setAutomaticUpdatesEnabled(!hideCheckBox.isSelected());
                                }
                                if (options.length == 2 && option == 0) {
                                    try {
                                        URL url = new URL(newerVersion.getDownloadURL());
                                        desktop.browse(url.toURI());
                                    }
                                    catch (Exception ex) {
                                        logger.error(ex.getMessage(), (Throwable)ex);
                                    }
                                }
                            } else {
                                logger.debug("checkForUpdates: no updates found");
                                if (showDialogs) {
                                    JOptionPane.showMessageDialog(XtremeMP.getInstance().getMainFrame(), Utilities.tr("Dialog.SoftwareUpdate.NoUpdatesFound"), Utilities.tr("Dialog.SoftwareUpdate"), 1);
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                            if (!showDialogs) break block13;
                            JOptionPane.showMessageDialog(XtremeMP.getInstance().getMainFrame(), Utilities.tr("Dialog.SoftwareUpdate.ConnectionFailure"), Utilities.tr("Dialog.SoftwareUpdate"), 1);
                        }
                    }
                }
            }
        };
        checkForUpdatesWorker.execute();
    }

    public static void showCheckForUpdatesDialog() {
        checkForUpdatesDialog = new JDialog(XtremeMP.getInstance().getMainFrame(), Utilities.tr("Dialog.SoftwareUpdate"), true);
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.add((Component)new JLabel(Utilities.tr("Dialog.SoftwareUpdate.CheckingForUpdates")), "Center");
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.setPreferredSize(new Dimension(250, 20));
        panel.add((Component)progressBar, "South");
        JButton cancelButton = new JButton(Utilities.tr("Button.Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checkForUpdatesWorker != null && !checkForUpdatesWorker.isDone()) {
                    checkForUpdatesWorker.cancel(true);
                }
                checkForUpdatesDialog.dispose();
            }
        });
        JOptionPane optionPane = new JOptionPane(panel, -1, -1, null, new Object[]{cancelButton}, cancelButton);
        checkForUpdatesDialog.setContentPane(optionPane);
        checkForUpdatesDialog.pack();
        checkForUpdatesDialog.setResizable(false);
        checkForUpdatesDialog.setLocationRelativeTo(checkForUpdatesDialog.getParent());
        checkForUpdatesDialog.getRootPane().setDefaultButton(cancelButton);
        checkForUpdatesDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getLastVersion(URL url) throws Exception {
        Version result = null;
        InputStream urlStream = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setConnectTimeout(30000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(false);
            urlConnection.setReadTimeout(10000);
            urlConnection.setUseCaches(true);
            urlStream = urlConnection.getInputStream();
            Properties properties = new Properties();
            properties.load(urlStream);
            result = new Version();
            result.setMajorNumber(Integer.parseInt(properties.getProperty("xtrememp.lastVersion.majorNumber")));
            result.setMinorNumber(Integer.parseInt(properties.getProperty("xtrememp.lastVersion.minorNumber")));
            result.setMicroNumber(Integer.parseInt(properties.getProperty("xtrememp.lastVersion.microNumber")));
            result.setVersionType(Version.VersionType.valueOf(properties.getProperty("xtrememp.lastVersion.versionType")));
            result.setReleaseDate(properties.getProperty("xtrememp.lastVersion.releaseDate"));
            result.setDownloadURL(properties.getProperty("xtrememp.lastVersion.dounloadURL"));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(urlStream);
            throw throwable;
        }
        IOUtils.closeQuietly(urlStream);
        return result;
    }

    public static void scheduleCheckForUpdates(long delay) {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new CheckForUpdatesTask(), delay);
    }

    private static class CheckForUpdatesTask
    extends TimerTask {
        private CheckForUpdatesTask() {
        }

        @Override
        public void run() {
            SoftwareUpdate.checkForUpdates(false);
        }
    }
}

