/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.util;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import xtrememp.util.LanguageBundle;

public final class Utilities {
    private static Locale systemLocale;
    private static final Locale SPANISH;
    public static final String[] PROTOCOLS;
    public static final String ZERO_TIMER = "00:00 / 00:00";
    public static final String VISUALIZATION_PANEL = "VISUALIZATION_PANEL";
    public static final String PLAYLIST_MANAGER = "PLAYLIST_MANAGER";
    public static final String DEFAULT_PLAYLIST = "default.xspf";
    public static final Icon APP_256_ICON;
    public static final Icon FOLDER_ICON;
    public static final Icon FOLDER_REMOTE_ICON;
    public static final Icon DOCUMENT_OPEN_ICON;
    public static final Icon DOCUMENT_SAVE_ICON;
    public static final Icon MEDIA_PLAY_ICON;
    public static final Icon MEDIA_PAUSE_ICON;
    public static final Icon MEDIA_STOP_ICON;
    public static final Icon MEDIA_PREVIOUS_ICON;
    public static final Icon MEDIA_NEXT_ICON;
    public static final Icon PLAYLIST_REPEAT_NONE_ICON;
    public static final Icon PLAYLIST_REPEAT_ONE_ICON;
    public static final Icon PLAYLIST_REPEAT_ALL_ICON;
    public static final Icon PLAYLIST_SHUFFLE_ICON;
    public static final Icon AUDIO_VOLUME_HIGH_ICON;
    public static final Icon AUDIO_VOLUME_MEDIUM_ICON;
    public static final Icon AUDIO_VOLUME_LOW_ICON;
    public static final Icon AUDIO_VOLUME_MUTED_ICON;
    public static final Icon LIST_ADD_ICON;
    public static final Icon LIST_REMOVE_ICON;
    public static final Icon EDIT_CLEAR_ICON;
    public static final Icon GO_UP_ICON;
    public static final Icon GO_DOWN_ICON;
    public static final Icon GO_PREVIOUS_ICON;
    public static final Icon GO_NEXT_ICON;
    public static final Icon MEDIA_INFO_ICON;
    public static final Icon VIEW_FULLSCREEN_ICON;
    public static final Icon MENU_ICON;
    public static final Icon PREFERENCES_SYSTEM_ICON;
    public static final Icon AUDIO_CARD_ICON;

    public static void closeOnEscape(final JDialog dialog) {
        JRootPane rootPane = dialog.getRootPane();
        String escape = "escape";
        InputMap inputMap = rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), escape);
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escape, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
    }

    public static String tr(String key) {
        return LanguageBundle.getString(key);
    }

    public static Locale[] getLanguages() {
        Locale[] locales = new Locale[]{Utilities.getSystemLocale(), Locale.ENGLISH, Locale.FRENCH, Locale.ITALIAN, SPANISH};
        return locales;
    }

    public static Locale getSystemLocale() {
        if (systemLocale == null) {
            systemLocale = Locale.getDefault();
        }
        return systemLocale;
    }

    public static BufferedImage getImage(String name) {
        BufferedImage image = null;
        if (name != null) {
            try {
                image = ImageIO.read(Utilities.class.getResourceAsStream("/xtrememp/resources/images/" + name));
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return image;
    }

    public static Icon getIcon(String name) {
        return new ImageIcon(Utilities.getImage(name));
    }

    public static List<Image> getIconImages() {
        ArrayList<Image> icons = new ArrayList<Image>(3);
        icons.add(Utilities.getImage("icon_32.png"));
        icons.add(Utilities.getImage("icon_48.png"));
        icons.add(Utilities.getImage("icon_64.png"));
        return icons;
    }

    public static boolean isNullOrEmpty(String value) {
        if (value != null) {
            return value.isEmpty();
        }
        return true;
    }

    public static String byteCountToDisplaySize(long size) {
        double ONE_KiB_D = 1024.0;
        double ONE_MiB_D = ONE_KiB_D * ONE_KiB_D;
        double ONE_GiB_D = ONE_KiB_D * ONE_MiB_D;
        StringBuilder sbResult = new StringBuilder();
        NumberFormat sizeFormat = NumberFormat.getNumberInstance();
        sizeFormat.setMinimumFractionDigits(0);
        sizeFormat.setMaximumFractionDigits(2);
        if ((double)size > ONE_GiB_D) {
            sbResult.append(sizeFormat.format((double)size / ONE_GiB_D)).append(" GiB");
        } else if ((double)size > ONE_MiB_D) {
            sbResult.append(sizeFormat.format((double)size / ONE_MiB_D)).append(" MiB");
        } else if ((double)size > ONE_KiB_D) {
            sbResult.append(sizeFormat.format((double)size / ONE_KiB_D)).append(" KiB");
        } else {
            sbResult.append(String.valueOf(size)).append(" bytes");
        }
        return sbResult.toString();
    }

    public static boolean startWithProtocol(String input) {
        if (input != null) {
            input = input.toLowerCase();
            for (String protocol : PROTOCOLS) {
                if (!input.startsWith(protocol)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean startWithProtocol(String input, String protocol) {
        return input != null && (input = input.toLowerCase()).startsWith(protocol);
    }

    public static int countStringOccur(String text, String word) {
        Matcher matcher = Pattern.compile(Pattern.quote(word)).matcher(text);
        int matches = 0;
        while (matcher.find()) {
            ++matches;
        }
        return matches;
    }

    public static String[] stringSplitter(String text, String pattern) {
        ArrayList<String> substrings = new ArrayList<String>(6);
        int beginIndex = 0;
        Matcher matcher = Pattern.compile(Pattern.quote(pattern)).matcher(text);
        while (matcher.find()) {
            substrings.add(text.substring(beginIndex, matcher.start()));
            beginIndex = matcher.end();
        }
        return substrings.toArray(new String[0]);
    }

    static {
        SPANISH = new Locale("es");
        PROTOCOLS = new String[]{"http:", "file:", "ftp:", "https:", "ftps:", "jar:"};
        APP_256_ICON = Utilities.getIcon("icon_256.png");
        FOLDER_ICON = Utilities.getIcon("folder.png");
        FOLDER_REMOTE_ICON = Utilities.getIcon("folder-remote.png");
        DOCUMENT_OPEN_ICON = Utilities.getIcon("document-open.png");
        DOCUMENT_SAVE_ICON = Utilities.getIcon("document-save.png");
        MEDIA_PLAY_ICON = Utilities.getIcon("media-playback-start.png");
        MEDIA_PAUSE_ICON = Utilities.getIcon("media-playback-pause.png");
        MEDIA_STOP_ICON = Utilities.getIcon("media-playback-stop.png");
        MEDIA_PREVIOUS_ICON = Utilities.getIcon("media-skip-backward.png");
        MEDIA_NEXT_ICON = Utilities.getIcon("media-skip-forward.png");
        PLAYLIST_REPEAT_NONE_ICON = Utilities.getIcon("media-playlist-repeat_none.png");
        PLAYLIST_REPEAT_ONE_ICON = Utilities.getIcon("media-playlist-repeat_one.png");
        PLAYLIST_REPEAT_ALL_ICON = Utilities.getIcon("media-playlist-repeat_all.png");
        PLAYLIST_SHUFFLE_ICON = Utilities.getIcon("media-playlist-shuffle.png");
        AUDIO_VOLUME_HIGH_ICON = Utilities.getIcon("audio-volume-high.png");
        AUDIO_VOLUME_MEDIUM_ICON = Utilities.getIcon("audio-volume-medium.png");
        AUDIO_VOLUME_LOW_ICON = Utilities.getIcon("audio-volume-low.png");
        AUDIO_VOLUME_MUTED_ICON = Utilities.getIcon("audio-volume-muted.png");
        LIST_ADD_ICON = Utilities.getIcon("list-add.png");
        LIST_REMOVE_ICON = Utilities.getIcon("list-remove.png");
        EDIT_CLEAR_ICON = Utilities.getIcon("edit-clear.png");
        GO_UP_ICON = Utilities.getIcon("go-up.png");
        GO_DOWN_ICON = Utilities.getIcon("go-down.png");
        GO_PREVIOUS_ICON = Utilities.getIcon("go-previous.png");
        GO_NEXT_ICON = Utilities.getIcon("go-next.png");
        MEDIA_INFO_ICON = Utilities.getIcon("media-info.png");
        VIEW_FULLSCREEN_ICON = Utilities.getIcon("view-fullscreen.png");
        MENU_ICON = Utilities.getIcon("menu.png");
        PREFERENCES_SYSTEM_ICON = Utilities.getIcon("preferences-system.png");
        AUDIO_CARD_ICON = Utilities.getIcon("audio-card.png");
    }
}

