/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.nio.FloatBuffer;
import javax.sound.sampled.SourceDataLine;
import xtrememp.player.dsp.DssContext;
import xtrememp.visualization.Visualization;

public final class Waveform
extends Visualization {
    public static final String NAME = "Waveform";

    @Override
    public void init(int sampleSize, SourceDataLine sourceDataLine) {
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        super.setBackgroundColor(backgroundColor);
        this.freeImage();
    }

    @Override
    public void setForegroundColor(Color foregroundColor) {
        super.setForegroundColor(foregroundColor);
        this.freeImage();
    }

    @Override
    public synchronized void render(DssContext dssContext, Graphics2D g2d, int width, int height) {
        FloatBuffer[] channelsBuffer = dssContext.getDataNormalized();
        int sampleSize = dssContext.getSampleSize();
        float leftLevel = 0.0f;
        float rightLevel = 0.0f;
        for (int i = 0; i < sampleSize; ++i) {
            leftLevel -= Math.abs(channelsBuffer[0].get(i));
            rightLevel += Math.abs(channelsBuffer[1].get(i));
        }
        int width2 = width - 1;
        int height2 = height >> 1;
        g2d.setColor(this.backgroundColor);
        g2d.drawLine(width2, 0, width2, height);
        g2d.setColor(this.foregroundColor);
        g2d.drawLine(0, height2, width2, height2);
        int tmp1 = Math.round(leftLevel / (float)sampleSize * (float)height2) + height2;
        g2d.drawLine(width2, height2, width2, tmp1);
        int tmp2 = Math.round(rightLevel / (float)sampleSize * (float)height2) + height2;
        g2d.drawLine(width2, height2, width2, tmp2);
        g2d.drawImage((Image)this.buffImage, -1, 0, null);
    }
}

