/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import net.n3.nanoxml.ContentReader;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLUtil;

public class StdXMLParser
implements IXMLParser {
    private static final char[] END_OF_PI = new char[]{'>', '?'};
    private static final char[] END_OF_CDATA = new char[]{'>', ']', ']'};
    private static final char[] END_OF_PCDATA = new char[]{'<'};
    private IXMLBuilder builder = null;
    private IXMLReader reader = null;
    private IXMLEntityResolver entityResolver = new XMLEntityResolver();
    private IXMLValidator validator = null;

    protected void finalize() throws Throwable {
        this.builder = null;
        this.reader = null;
        this.entityResolver = null;
        this.validator = null;
        super.finalize();
    }

    public void setBuilder(IXMLBuilder builder) {
        this.builder = builder;
    }

    public IXMLBuilder getBuilder() {
        return this.builder;
    }

    public void setValidator(IXMLValidator validator) {
        this.validator = validator;
    }

    public IXMLValidator getValidator() {
        return this.validator;
    }

    public void setResolver(IXMLEntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public IXMLEntityResolver getResolver() {
        return this.entityResolver;
    }

    public void setReader(IXMLReader reader) {
        this.reader = reader;
    }

    public IXMLReader getReader() {
        return this.reader;
    }

    public Object parse() throws XMLException {
        try {
            this.builder.startBuilding(this.reader.getSystemID(), this.reader.getLineNr());
            this.scanData();
            return this.builder.getResult();
        }
        catch (XMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XMLException(e);
        }
    }

    protected void scanData() throws Exception {
        block4: while (!this.reader.atEOF() && this.builder.getResult() == null) {
            char ch = XMLUtil.read(this.reader, null, '&', this.entityResolver);
            switch (ch) {
                case '<': {
                    this.scanSomeTag(false);
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
            }
            XMLUtil.errorInvalidInput(this.reader.getSystemID(), this.reader.getLineNr(), "`" + ch + "' (0x" + Integer.toHexString(ch) + ')');
        }
    }

    protected void scanSomeTag(boolean allowCDATA) throws Exception {
        char ch = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        switch (ch) {
            case '?': {
                this.processPI();
                break;
            }
            case '!': {
                this.processSpecialTag(allowCDATA);
                break;
            }
            default: {
                this.reader.unread(ch);
                this.processElement();
            }
        }
    }

    protected void processPI() throws Exception {
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        String target = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        ContentReader reader = new ContentReader(this.reader, this.entityResolver, '&', END_OF_PI, true, "");
        if (!target.equalsIgnoreCase("xml")) {
            this.builder.newProcessingInstruction(target, reader);
        }
        ((Reader)reader).close();
    }

    protected void processSpecialTag(boolean allowCDATA) throws Exception {
        char ch = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        switch (ch) {
            case '[': {
                if (allowCDATA) {
                    this.processCDATA();
                } else {
                    XMLUtil.skipTag(this.reader, '&', this.entityResolver);
                }
                return;
            }
            case 'D': {
                this.processDocType();
                return;
            }
            case '-': {
                XMLUtil.skipComment(this.reader, this.entityResolver);
                return;
            }
        }
    }

    protected void processCDATA() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, '&', this.entityResolver, "CDATA[")) {
            XMLUtil.skipTag(this.reader, '&', this.entityResolver);
            return;
        }
        this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
        ContentReader reader = new ContentReader(this.reader, this.entityResolver, '&', END_OF_CDATA, true, "");
        this.builder.addPCData(reader, this.reader.getSystemID(), this.reader.getLineNr());
        ((Reader)reader).close();
    }

    protected void processDocType() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, '&', this.entityResolver, "OCTYPE")) {
            XMLUtil.skipTag(this.reader, '&', this.entityResolver);
            return;
        }
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        String systemID = null;
        StringBuffer publicID = new StringBuffer();
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        char ch = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        if (ch == 'P') {
            systemID = XMLUtil.scanPublicID(publicID, this.reader, '&', this.entityResolver);
            XMLUtil.skipWhitespace(this.reader, '&', null, null);
            ch = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        } else if (ch == 'S') {
            systemID = XMLUtil.scanSystemID(this.reader, '&', this.entityResolver);
            XMLUtil.skipWhitespace(this.reader, '&', null, null);
            ch = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        }
        if (ch == '[') {
            this.validator.parseDTD(publicID.toString(), this.reader, this.entityResolver, false);
            XMLUtil.skipWhitespace(this.reader, '&', null, null);
            ch = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        }
        if (ch != '>') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
        }
        if (systemID != null) {
            Reader reader = this.reader.openStream(publicID.toString(), systemID);
            this.reader.startNewStream(reader);
            this.reader.setSystemID(systemID);
            this.reader.setPublicID(publicID.toString());
            this.validator.parseDTD(publicID.toString(), this.reader, this.entityResolver, true);
        }
    }

    protected void processElement() throws Exception {
        char ch;
        String name = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        String prefix = null;
        int colonIndex = name.indexOf(58);
        if (colonIndex > 0) {
            prefix = name.substring(0, colonIndex);
            name = name.substring(colonIndex + 1);
        }
        this.validator.elementStarted(name, prefix, null, this.reader.getSystemID(), this.reader.getLineNr());
        this.builder.startElement(name, prefix, null, this.reader.getSystemID(), this.reader.getLineNr());
        while ((ch = XMLUtil.read(this.reader, null, '&', this.entityResolver)) != '/' && ch != '>') {
            this.reader.unread(ch);
            this.processAttribute();
            XMLUtil.skipWhitespace(this.reader, '&', null, null);
        }
        Properties extraAttributes = new Properties();
        this.validator.elementAttributesProcessed(name, prefix, null, extraAttributes, this.reader.getSystemID(), this.reader.getLineNr());
        Enumeration<Object> enumeration = extraAttributes.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = extraAttributes.getProperty(key);
            String attPrefix = null;
            colonIndex = key.indexOf(58);
            if (colonIndex > 0) {
                attPrefix = key.substring(0, colonIndex);
                key = key.substring(colonIndex + 1);
            }
            this.builder.addAttribute(key, attPrefix, null, value, "CDATA");
        }
        this.builder.elementAttributesProcessed(name, prefix, null);
        if (ch == '/') {
            if (XMLUtil.read(this.reader, null, '&', this.entityResolver) != '>') {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
            }
            this.validator.elementEnded(name, prefix, null, this.reader.getSystemID(), this.reader.getLineNr());
            this.builder.endElement(name, prefix, null);
            return;
        }
        StringBuffer whitespaceBuffer = new StringBuffer(16);
        while (true) {
            whitespaceBuffer.setLength(0);
            boolean[] fromEntity = new boolean[1];
            XMLUtil.skipWhitespace(this.reader, '&', whitespaceBuffer, fromEntity);
            ch = XMLUtil.read(this.reader, null, '&', this.entityResolver);
            if (ch == '<' && !fromEntity[0]) {
                ch = this.reader.read();
                if (ch == '/') {
                    XMLUtil.skipWhitespace(this.reader, '&', null, null);
                    String str = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
                    if (!str.equals(name)) {
                        XMLUtil.errorWrongClosingTag(this.reader.getSystemID(), this.reader.getLineNr(), name, str);
                    }
                    XMLUtil.skipWhitespace(this.reader, '&', null, null);
                    if (XMLUtil.read(this.reader, null, '&', this.entityResolver) != '>') {
                        XMLUtil.errorClosingTagNotEmpty(this.reader.getSystemID(), this.reader.getLineNr());
                    }
                    break;
                }
                this.reader.unread(ch);
                this.scanSomeTag(true);
                continue;
            }
            this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
            this.reader.unread(ch);
            ContentReader reader = new ContentReader(this.reader, this.entityResolver, '&', END_OF_PCDATA, false, whitespaceBuffer.toString());
            this.builder.addPCData(reader, this.reader.getSystemID(), this.reader.getLineNr());
            ((Reader)reader).close();
            this.reader.unread('<');
        }
        this.validator.elementEnded(name, prefix, null, this.reader.getSystemID(), this.reader.getLineNr());
        this.builder.endElement(name, prefix, null);
    }

    protected void processAttribute() throws Exception {
        String key = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        if (XMLUtil.read(this.reader, null, '&', this.entityResolver) != '=') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
        }
        String value = XMLUtil.scanString(this.reader, '&', true, this.entityResolver);
        this.validator.attributeAdded(key, null, null, value, this.reader.getSystemID(), this.reader.getLineNr());
        this.builder.addAttribute(key, null, null, value, "CDATA");
    }
}

