/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.playlist;

import javazoom.jlgui.player.amp.tag.TagInfo;
import javazoom.jlgui.player.amp.tag.TagInfoFactory;
import javazoom.jlgui.player.amp.util.Config;
import javazoom.jlgui.player.amp.util.FileUtil;

public class PlaylistItem {
    protected String _name = null;
    protected String _displayName = null;
    protected String _location = null;
    protected boolean _isFile = true;
    protected long _seconds = -1L;
    protected boolean _isSelected = false;
    protected TagInfo _taginfo = null;

    protected PlaylistItem() {
    }

    public PlaylistItem(String string, String string2, long l, boolean bl) {
        this._name = string;
        this._seconds = l;
        this._isFile = bl;
        Config config = Config.getInstance();
        if (config.getTaginfoPolicy().equals(Config.TAGINFO_POLICY_ALL)) {
            this.setLocation(string2, true);
        } else if (config.getTaginfoPolicy().equals(Config.TAGINFO_POLICY_FILE)) {
            if (this._isFile) {
                this.setLocation(string2, true);
            } else {
                this.setLocation(string2, false);
            }
        } else {
            this.setLocation(string2, false);
        }
    }

    public String getFormattedName() {
        if (this._displayName == null) {
            if (this._seconds > 0L) {
                String string = this.getFormattedLength();
                return "(" + string + ") " + this._name;
            }
            return this._name;
        }
        return this._displayName;
    }

    public String getName() {
        return this._name;
    }

    public String getLocation() {
        return this._location;
    }

    public boolean isFile() {
        return this._isFile;
    }

    public void setFile(boolean bl) {
        this._isFile = bl;
    }

    public long getLength() {
        if (this._taginfo != null && this._taginfo.getPlayTime() > 0L) {
            return this._taginfo.getPlayTime();
        }
        return this._seconds;
    }

    public int getBitrate() {
        if (this._taginfo != null) {
            return this._taginfo.getBitRate();
        }
        return -1;
    }

    public int getSamplerate() {
        if (this._taginfo != null) {
            return this._taginfo.getSamplingRate();
        }
        return -1;
    }

    public int getChannels() {
        if (this._taginfo != null) {
            return this._taginfo.getChannels();
        }
        return -1;
    }

    public void setSelected(boolean bl) {
        this._isSelected = bl;
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setLocation(String string) {
        this.setLocation(string, false);
    }

    public void setLocation(String string, boolean bl) {
        this._location = string;
        if (bl && this._location != null && !this._location.equals("")) {
            TagInfoFactory tagInfoFactory = TagInfoFactory.getInstance();
            this._taginfo = tagInfoFactory.getTagInfo(string);
        }
        this._displayName = this.getFormattedDisplayName();
    }

    public String getFormattedLength() {
        long l = this.getLength();
        String string = "";
        if (l > -1L) {
            int n = (int)Math.floor(l / 60L);
            int n2 = (int)Math.floor(n / 60);
            int n3 = (int)(l - (long)((n -= n2 * 60) * 60) - (long)(n2 * 3600));
            if (n2 > 0) {
                string = string + FileUtil.rightPadString(n2 + "", '0', 2) + ":";
            }
            string = string + FileUtil.rightPadString(n + "", '0', 2) + ":" + FileUtil.rightPadString(n3 + "", '0', 2);
        } else {
            string = "" + l;
        }
        return string;
    }

    public String getFormattedDisplayName() {
        if (this._taginfo == null) {
            return null;
        }
        String string = this.getFormattedLength();
        if (this._taginfo.getTitle() != null && !this._taginfo.getTitle().equals("") && this._taginfo.getArtist() != null && !this._taginfo.getArtist().equals("")) {
            if (this.getLength() > 0L) {
                return "(" + string + ") " + this._taginfo.getTitle() + " - " + this._taginfo.getArtist();
            }
            return this._taginfo.getTitle() + " - " + this._taginfo.getArtist();
        }
        if (this._taginfo.getTitle() != null && !this._taginfo.getTitle().equals("")) {
            if (this.getLength() > 0L) {
                return "(" + string + ") " + this._taginfo.getTitle();
            }
            return this._taginfo.getTitle();
        }
        if (this.getLength() > 0L) {
            return "(" + string + ") " + this._name;
        }
        return this._name;
    }

    public void setFormattedDisplayName(String string) {
        this._displayName = string;
    }

    public String getM3UExtInf() {
        if (this._taginfo == null) {
            return this._seconds + "," + this._name;
        }
        if (this._taginfo.getTitle() != null && this._taginfo.getArtist() != null) {
            return this.getLength() + "," + this._taginfo.getTitle() + " - " + this._taginfo.getArtist();
        }
        if (this._taginfo.getTitle() != null) {
            return this.getLength() + "," + this._taginfo.getTitle();
        }
        return this._seconds + "," + this._name;
    }

    public TagInfo getTagInfo() {
        if (this._taginfo == null) {
            this.setLocation(this._location, true);
        }
        return this._taginfo;
    }
}

