/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.tag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.player.amp.tag.TagInfo;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class MpegInfo
implements TagInfo {
    protected int channels = -1;
    protected String channelsMode = null;
    protected String version = null;
    protected int rate = 0;
    protected String layer = null;
    protected String emphasis = null;
    protected int nominalbitrate = 0;
    protected long total = 0L;
    protected String vendor = null;
    protected String location = null;
    protected long size = 0L;
    protected boolean copyright = false;
    protected boolean crc = false;
    protected boolean original = false;
    protected boolean priv = false;
    protected boolean vbr = false;
    protected int track = -1;
    protected String year = null;
    protected String genre = null;
    protected String title = null;
    protected String artist = null;
    protected String album = null;
    protected Vector comments = null;

    public void load(File file) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.location = file.getPath();
        this.loadInfo(file);
    }

    public void load(URL uRL) throws IOException, UnsupportedAudioFileException {
        this.location = uRL.toString();
        this.loadInfo(uRL);
    }

    public void load(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        this.loadInfo(inputStream);
    }

    protected void loadInfo(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(inputStream);
        this.loadInfo(audioFileFormat);
    }

    protected void loadInfo(File file) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(file);
        this.loadInfo(audioFileFormat);
    }

    protected void loadInfo(AudioFileFormat audioFileFormat) throws UnsupportedAudioFileException {
        String string = audioFileFormat.getType().toString();
        if (!string.equalsIgnoreCase("mp3")) {
            throw new UnsupportedAudioFileException("Not MP3 audio format");
        }
        if (audioFileFormat instanceof TAudioFileFormat) {
            Map map = ((TAudioFileFormat)audioFileFormat).properties();
            if (map.containsKey("mp3.channels")) {
                this.channels = (Integer)map.get("mp3.channels");
            }
            if (map.containsKey("mp3.frequency.hz")) {
                this.rate = (Integer)map.get("mp3.frequency.hz");
            }
            if (map.containsKey("mp3.bitrate.nominal.bps")) {
                this.nominalbitrate = (Integer)map.get("mp3.bitrate.nominal.bps");
            }
            if (map.containsKey("mp3.version.layer")) {
                this.layer = "Layer " + map.get("mp3.version.layer");
            }
            if (map.containsKey("mp3.version.mpeg")) {
                this.version = (String)map.get("mp3.version.mpeg");
                if (this.version.equals("1")) {
                    this.version = "MPEG1";
                } else if (this.version.equals("2")) {
                    this.version = "MPEG2-LSF";
                } else if (this.version.equals("2.5")) {
                    this.version = "MPEG2.5-LSF";
                }
            }
            if (map.containsKey("mp3.mode")) {
                int n = (Integer)map.get("mp3.mode");
                if (n == 0) {
                    this.channelsMode = "Stereo";
                } else if (n == 1) {
                    this.channelsMode = "Joint Stereo";
                } else if (n == 2) {
                    this.channelsMode = "Dual Channel";
                } else if (n == 3) {
                    this.channelsMode = "Single Channel";
                }
            }
            if (map.containsKey("mp3.crc")) {
                this.crc = (Boolean)map.get("mp3.crc");
            }
            if (map.containsKey("mp3.vbr")) {
                this.vbr = (Boolean)map.get("mp3.vbr");
            }
            if (map.containsKey("mp3.copyright")) {
                this.copyright = (Boolean)map.get("mp3.copyright");
            }
            if (map.containsKey("mp3.original")) {
                this.original = (Boolean)map.get("mp3.original");
            }
            this.emphasis = "none";
            if (map.containsKey("title")) {
                this.title = (String)map.get("title");
            }
            if (map.containsKey("author")) {
                this.artist = (String)map.get("author");
            }
            if (map.containsKey("album")) {
                this.album = (String)map.get("album");
            }
            if (map.containsKey("date")) {
                this.year = (String)map.get("date");
            }
            if (map.containsKey("duration")) {
                this.total = Math.round((Long)map.get("duration") / 1000000L);
            }
            if (map.containsKey("mp3.id3tag.genre")) {
                this.genre = (String)map.get("mp3.id3tag.genre");
            }
            if (map.containsKey("mp3.id3tag.track")) {
                try {
                    this.track = Integer.parseInt((String)map.get("mp3.id3tag.track"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected void loadInfo(URL uRL) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(uRL);
        this.loadInfo(audioFileFormat);
        this.loadShoutastInfo(audioFileFormat);
    }

    protected void loadShoutastInfo(AudioFileFormat audioFileFormat) throws IOException, UnsupportedAudioFileException {
        String string = audioFileFormat.getType().toString();
        if (!string.equalsIgnoreCase("mp3")) {
            throw new UnsupportedAudioFileException("Not MP3 audio format");
        }
        if (audioFileFormat instanceof TAudioFileFormat) {
            Map map = ((TAudioFileFormat)audioFileFormat).properties();
            Iterator iterator = map.keySet().iterator();
            this.comments = new Vector();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.startsWith("mp3.shoutcast.metadata.")) continue;
                String string3 = (String)map.get(string2);
                if ((string2 = string2.substring(23, string2.length())).equalsIgnoreCase("icy-name")) {
                    this.title = string3;
                    continue;
                }
                if (string2.equalsIgnoreCase("icy-genre")) {
                    this.genre = string3;
                    continue;
                }
                this.comments.add(string2 + "=" + string3);
            }
        }
    }

    public boolean getVBR() {
        return this.vbr;
    }

    public int getChannels() {
        return this.channels;
    }

    public String getVersion() {
        return this.version;
    }

    public String getEmphasis() {
        return this.emphasis;
    }

    public boolean getCopyright() {
        return this.copyright;
    }

    public boolean getCRC() {
        return this.crc;
    }

    public boolean getOriginal() {
        return this.original;
    }

    public String getLayer() {
        return this.layer;
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public int getSamplingRate() {
        return this.rate;
    }

    public int getBitRate() {
        return this.nominalbitrate;
    }

    public long getPlayTime() {
        return this.total;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public int getTrack() {
        return this.track;
    }

    public String getGenre() {
        return this.genre;
    }

    public Vector getComment() {
        return this.comments;
    }

    public String getYear() {
        return this.year;
    }

    public String getChannelsMode() {
        return this.channelsMode;
    }
}

