/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javazoom.jlgui.player.amp.util.FileNameFilter;
import javazoom.jlgui.player.amp.util.FileSelector;
import javazoom.jlgui.player.amp.util.ui.PreferenceItem;

public class SkinPreference
extends PreferenceItem
implements ActionListener,
ListSelectionListener {
    public static final String DEFAULTSKIN = "<Default Skin>";
    public static final String SKINEXTENSION = "wsz";
    private DefaultListModel listModel = new DefaultListModel();
    private JList skins = null;
    private JTextArea info = null;
    private JPanel listPane = null;
    private JPanel infoPane = null;
    private JPanel browsePane = null;
    private JButton selectSkinDir = null;
    private static SkinPreference instance = null;

    private SkinPreference() {
    }

    public static SkinPreference getInstance() {
        if (instance == null) {
            instance = new SkinPreference();
        }
        return instance;
    }

    public void loadUI() {
        if (!this.loaded) {
            this.bundle = ResourceBundle.getBundle("javazoom/jlgui/player/amp/util/ui/skin");
            this.setBorder(new TitledBorder(this.getResource("title")));
            File file = null;
            if (this.player != null) {
                file = new File(this.player.getConfig().getLastSkinDir());
            }
            this.loadSkins(file);
            this.skins = new JList(this.listModel);
            this.skins.setBorder(new EmptyBorder(1, 2, 1, 1));
            this.skins.setSelectionMode(0);
            this.skins.setLayoutOrientation(0);
            this.skins.setVisibleRowCount(12);
            this.skins.addListSelectionListener(this);
            JScrollPane jScrollPane = new JScrollPane(this.skins);
            jScrollPane.setPreferredSize(new Dimension(300, 140));
            this.listPane = new JPanel();
            this.listPane.add(jScrollPane);
            this.infoPane = new JPanel();
            this.info = new JTextArea(4, 35);
            this.info.setEditable(false);
            this.info.setCursor(null);
            JScrollPane jScrollPane2 = new JScrollPane(this.info);
            jScrollPane2.setVerticalScrollBarPolicy(22);
            jScrollPane2.setHorizontalScrollBarPolicy(32);
            this.infoPane.add(jScrollPane2);
            this.browsePane = new JPanel();
            this.selectSkinDir = new JButton(this.getResource("browser.directory.button"));
            this.selectSkinDir.addActionListener(this);
            this.browsePane.add(this.selectSkinDir);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.6;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.listPane, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.infoPane, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            this.add((Component)this.browsePane, gridBagConstraints);
            this.loaded = true;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File[] fileArray;
        if (actionEvent.getActionCommand().equalsIgnoreCase(this.getResource("browser.directory.button")) && (fileArray = FileSelector.selectFile(this.player.getLoader(), 4, false, "", "Directories", new File(this.player.getConfig().getLastSkinDir()))) != null && fileArray[0].isDirectory()) {
            this.player.getConfig().setLastSkinDir(fileArray[0].getAbsolutePath());
            this.loadSkins(fileArray[0]);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && this.skins.getSelectedIndex() != -1) {
            String string = (String)this.listModel.get(this.skins.getSelectedIndex());
            String string2 = this.player.getConfig().getLastSkinDir() + string + "." + SKINEXTENSION;
            this.player.getSkin().setPath(string2);
            this.player.loadSkin();
            this.player.getConfig().setDefaultSkin(string2);
            String string3 = this.player.getSkin().getReadme();
            if (string3 == null) {
                string3 = "";
            }
            this.info.setText(string3);
            this.info.setCaretPosition(0);
        }
    }

    private void loadSkins(File file) {
        File[] fileArray;
        this.listModel.clear();
        this.listModel.addElement(DEFAULTSKIN);
        if (file != null && file.exists() && (fileArray = file.listFiles(new FileNameFilter(SKINEXTENSION, "Skins", false))) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                this.listModel.addElement(string.substring(0, string.length() - 4));
            }
        }
    }
}

