/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javazoom.jlgui.player.amp.util.ui.PreferenceItem;
import javazoom.jlgui.player.amp.visual.ui.SpectrumTimeAnalyzer;

public class VisualPreference
extends PreferenceItem
implements ActionListener,
ChangeListener {
    private JPanel modePane = null;
    private JPanel spectrumPane = null;
    private JPanel oscilloPane = null;
    private JRadioButton spectrumMode = null;
    private JRadioButton oscilloMode = null;
    private JRadioButton offMode = null;
    private JCheckBox peaksBox = null;
    private JSlider analyzerFalloff = null;
    private JSlider peaksFalloff = null;
    private static VisualPreference instance = null;

    private VisualPreference() {
    }

    public static VisualPreference getInstance() {
        if (instance == null) {
            instance = new VisualPreference();
        }
        return instance;
    }

    public void loadUI() {
        if (!this.loaded) {
            this.bundle = ResourceBundle.getBundle("javazoom/jlgui/player/amp/util/ui/visual");
            this.setBorder(new TitledBorder(this.getResource("title")));
            this.modePane = new JPanel();
            this.modePane.setBorder(new TitledBorder(this.getResource("mode.title")));
            this.modePane.setLayout(new FlowLayout());
            this.spectrumMode = new JRadioButton(this.getResource("mode.spectrum"));
            this.spectrumMode.addActionListener(this);
            this.oscilloMode = new JRadioButton(this.getResource("mode.oscilloscope"));
            this.oscilloMode.addActionListener(this);
            this.offMode = new JRadioButton(this.getResource("mode.off"));
            this.offMode.addActionListener(this);
            SpectrumTimeAnalyzer spectrumTimeAnalyzer = null;
            if (this.player != null) {
                spectrumTimeAnalyzer = this.player.getSkin().getAcAnalyzer();
                int n = 2;
                if (spectrumTimeAnalyzer != null) {
                    n = spectrumTimeAnalyzer.getDisplayMode();
                }
                if (n == 1) {
                    this.spectrumMode.setSelected(true);
                } else if (n == 0) {
                    this.oscilloMode.setSelected(true);
                } else if (n == 2) {
                    this.offMode.setSelected(true);
                }
            }
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.spectrumMode);
            buttonGroup.add(this.oscilloMode);
            buttonGroup.add(this.offMode);
            this.modePane.add(this.spectrumMode);
            this.modePane.add(this.oscilloMode);
            this.modePane.add(this.offMode);
            this.spectrumPane = new JPanel();
            this.spectrumPane.setLayout(new BoxLayout(this.spectrumPane, 1));
            this.peaksBox = new JCheckBox(this.getResource("spectrum.peaks"));
            this.peaksBox.setAlignmentX(0.0f);
            this.peaksBox.addActionListener(this);
            if (spectrumTimeAnalyzer != null && spectrumTimeAnalyzer.isPeaksEnabled()) {
                this.peaksBox.setSelected(true);
            } else {
                this.peaksBox.setSelected(false);
            }
            this.spectrumPane.add(this.peaksBox);
            JLabel jLabel = new JLabel(this.getResource("spectrum.analyzer.falloff"));
            jLabel.setAlignmentX(0.0f);
            this.spectrumPane.add(jLabel);
            int n = 2;
            int n2 = 8;
            int n3 = (n2 + n) / 2;
            if (spectrumTimeAnalyzer != null) {
                n3 = (int)(spectrumTimeAnalyzer.getSpectrumAnalyserDecay() * 100.0f);
            }
            this.analyzerFalloff = new JSlider(0, n, n2, n3);
            this.analyzerFalloff.setMajorTickSpacing(1);
            this.analyzerFalloff.setPaintTicks(true);
            this.analyzerFalloff.setMaximumSize(new Dimension(150, this.analyzerFalloff.getPreferredSize().height));
            this.analyzerFalloff.setAlignmentX(0.0f);
            this.analyzerFalloff.setSnapToTicks(true);
            this.analyzerFalloff.addChangeListener(this);
            this.spectrumPane.add(this.analyzerFalloff);
            JLabel jLabel2 = new JLabel(this.getResource("spectrum.peaks.falloff"));
            jLabel2.setAlignmentX(0.0f);
            this.spectrumPane.add(jLabel2);
            int n4 = 20;
            int n5 = 50;
            if (spectrumTimeAnalyzer != null) {
                n5 = spectrumTimeAnalyzer.getFps();
                n4 = spectrumTimeAnalyzer.getPeakDelay();
            }
            this.peaksFalloff = new JSlider(0, 0, 4, this.computeSliderValue(n4, n5));
            this.peaksFalloff.setMajorTickSpacing(1);
            this.peaksFalloff.setPaintTicks(true);
            this.peaksFalloff.setSnapToTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(new Integer(0), new JLabel("Slow"));
            hashtable.put(new Integer(4), new JLabel("Fast"));
            this.peaksFalloff.setLabelTable(hashtable);
            this.peaksFalloff.setPaintLabels(true);
            this.peaksFalloff.setMaximumSize(new Dimension(150, this.peaksFalloff.getPreferredSize().height));
            this.peaksFalloff.setAlignmentX(0.0f);
            this.peaksFalloff.addChangeListener(this);
            this.spectrumPane.add(this.peaksFalloff);
            this.spectrumPane.setBorder(new TitledBorder(this.getResource("spectrum.title")));
            if (this.getResource("oscilloscope.title") != null) {
                this.oscilloPane = new JPanel();
                this.oscilloPane.setBorder(new TitledBorder(this.getResource("oscilloscope.title")));
            }
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.weighty = 0.25;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.modePane, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.spectrumPane, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            if (this.oscilloPane != null) {
                this.add((Component)this.oscilloPane, gridBagConstraints);
            }
            if (spectrumTimeAnalyzer == null) {
                this.disablePane(this.modePane);
                this.disablePane(this.spectrumPane);
                this.disablePane(this.oscilloPane);
            }
            this.loaded = true;
        }
    }

    private void disablePane(JPanel jPanel) {
        Component[] componentArray;
        if (jPanel != null && (componentArray = jPanel.getComponents()) != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SpectrumTimeAnalyzer spectrumTimeAnalyzer;
        if (this.player != null && (spectrumTimeAnalyzer = this.player.getSkin().getAcAnalyzer()) != null) {
            if (actionEvent.getSource().equals(this.spectrumMode)) {
                spectrumTimeAnalyzer.setDisplayMode(1);
                spectrumTimeAnalyzer.startDSP(null);
            } else if (actionEvent.getSource().equals(this.oscilloMode)) {
                spectrumTimeAnalyzer.setDisplayMode(0);
                spectrumTimeAnalyzer.startDSP(null);
            } else if (actionEvent.getSource().equals(this.offMode)) {
                spectrumTimeAnalyzer.setDisplayMode(2);
                spectrumTimeAnalyzer.closeDSP();
                spectrumTimeAnalyzer.repaint();
            } else if (actionEvent.getSource().equals(this.peaksBox)) {
                if (this.peaksBox.isSelected()) {
                    spectrumTimeAnalyzer.setPeaksEnabled(true);
                } else {
                    spectrumTimeAnalyzer.setPeaksEnabled(false);
                }
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SpectrumTimeAnalyzer spectrumTimeAnalyzer;
        if (this.player != null && (spectrumTimeAnalyzer = this.player.getSkin().getAcAnalyzer()) != null) {
            if (changeEvent.getSource() == this.analyzerFalloff) {
                if (!this.analyzerFalloff.getValueIsAdjusting()) {
                    spectrumTimeAnalyzer.setSpectrumAnalyserDecay((float)this.analyzerFalloff.getValue() * 1.0f / 100.0f);
                }
            } else if (changeEvent.getSource() == this.peaksFalloff && !this.peaksFalloff.getValueIsAdjusting()) {
                spectrumTimeAnalyzer.setPeakDelay(this.computeDelay(this.peaksFalloff.getValue(), spectrumTimeAnalyzer.getFps()));
            }
        }
    }

    private int computeDelay(int n, int n2) {
        float f = 0.4f;
        float f2 = 0.1f;
        int n3 = Math.round((-f2 * (float)n * 1.0f / 2.0f + f + f2) * (float)n2);
        return n3;
    }

    private int computeSliderValue(int n, int n2) {
        float f = 0.4f;
        float f2 = 0.1f;
        int n3 = (int)Math.round(((double)f - (double)n * 1.0 / (double)n2 * 1.0) * 2.0 / (double)f2 + 2.0);
        return n3;
    }
}

