/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.decoder;

import davaguine.jmac.decoder.AntiPredictor;
import davaguine.jmac.decoder.AntiPredictorExtraHigh0000To3320;
import davaguine.jmac.decoder.AntiPredictorExtraHigh3320To3600;
import davaguine.jmac.decoder.AntiPredictorExtraHigh3600To3700;
import davaguine.jmac.decoder.AntiPredictorExtraHigh3700To3800;
import davaguine.jmac.decoder.AntiPredictorExtraHigh3800ToCurrent;
import davaguine.jmac.decoder.IAPEDecompress;
import davaguine.jmac.decoder.UnBitArrayBase;
import davaguine.jmac.decoder.UnBitArrayState;
import davaguine.jmac.tools.JMACException;
import java.io.IOException;
import java.util.Arrays;

public class APEDecompressCore {
    private long[] aryCoefficientsA = new long[64];
    private long[] aryCoefficientsB = new long[64];
    public int[] m_pTempData;
    public int[] m_pDataX;
    public int[] m_pDataY;
    public AntiPredictor m_pAntiPredictorX;
    public AntiPredictor m_pAntiPredictorY;
    public UnBitArrayBase m_pUnBitArray;
    public UnBitArrayState m_BitArrayStateX = new UnBitArrayState();
    public UnBitArrayState m_BitArrayStateY = new UnBitArrayState();
    public IAPEDecompress m_pAPEDecompress;
    public int m_nBlocksProcessed;

    public APEDecompressCore(IAPEDecompress pAPEDecompress) {
        this.m_pAPEDecompress = pAPEDecompress;
        this.m_pUnBitArray = UnBitArrayBase.CreateUnBitArray(pAPEDecompress, pAPEDecompress.getApeInfoFileVersion());
        if (pAPEDecompress.getApeInfoFileVersion() >= 3930) {
            throw new JMACException("Wrong Version");
        }
        this.m_pAntiPredictorX = AntiPredictor.CreateAntiPredictor(pAPEDecompress.getApeInfoCompressionLevel(), pAPEDecompress.getApeInfoFileVersion());
        this.m_pAntiPredictorY = AntiPredictor.CreateAntiPredictor(pAPEDecompress.getApeInfoCompressionLevel(), pAPEDecompress.getApeInfoFileVersion());
        this.m_pDataX = new int[pAPEDecompress.getApeInfoBlocksPerFrame() + 16];
        this.m_pDataY = new int[pAPEDecompress.getApeInfoBlocksPerFrame() + 16];
        this.m_pTempData = new int[pAPEDecompress.getApeInfoBlocksPerFrame() + 16];
        this.m_nBlocksProcessed = 0;
    }

    public void GenerateDecodedArrays(int nBlocks, int nSpecialCodes, int nFrameIndex) throws IOException {
        if (this.m_pAPEDecompress.getApeInfoChannels() == 2) {
            if ((nSpecialCodes & 1) > 0 && (nSpecialCodes & 2) > 0) {
                Arrays.fill(this.m_pDataX, 0, nBlocks, 0);
                Arrays.fill(this.m_pDataY, 0, nBlocks, 0);
            } else if ((nSpecialCodes & 4) > 0) {
                this.GenerateDecodedArray(this.m_pDataX, nBlocks, nFrameIndex, this.m_pAntiPredictorX);
                Arrays.fill(this.m_pDataY, 0, nBlocks, 0);
            } else {
                this.GenerateDecodedArray(this.m_pDataX, nBlocks, nFrameIndex, this.m_pAntiPredictorX);
                this.GenerateDecodedArray(this.m_pDataY, nBlocks, nFrameIndex, this.m_pAntiPredictorY);
            }
        } else if ((nSpecialCodes & 1) > 0) {
            Arrays.fill(this.m_pDataX, 0, nBlocks, 0);
        } else {
            this.GenerateDecodedArray(this.m_pDataX, nBlocks, nFrameIndex, this.m_pAntiPredictorX);
        }
    }

    public void GenerateDecodedArray(int[] Input_Array, int Number_of_Elements, int Frame_Index, AntiPredictor pAntiPredictor) throws IOException {
        int nFrameBytes = this.m_pAPEDecompress.getApeInfoFrameBytes(Frame_Index);
        switch (this.m_pAPEDecompress.getApeInfoCompressionLevel()) {
            case 1000: {
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3320) {
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, Number_of_Elements, nFrameBytes);
                    pAntiPredictor.AntiPredict(this.m_pTempData, Input_Array, Number_of_Elements);
                    break;
                }
                this.m_pUnBitArray.GenerateArray(Input_Array, Number_of_Elements, nFrameBytes);
                pAntiPredictor.AntiPredict(Input_Array, null, Number_of_Elements);
                break;
            }
            case 2000: {
                this.m_pUnBitArray.GenerateArray(this.m_pTempData, Number_of_Elements, nFrameBytes);
                pAntiPredictor.AntiPredict(this.m_pTempData, Input_Array, Number_of_Elements);
                break;
            }
            case 3000: {
                this.m_pUnBitArray.GenerateArray(this.m_pTempData, Number_of_Elements, nFrameBytes);
                pAntiPredictor.AntiPredict(this.m_pTempData, Input_Array, Number_of_Elements);
                break;
            }
            case 4000: {
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3320) {
                    long nNumberOfCoefficients = this.m_pUnBitArray.DecodeValue(2, 4);
                    int z = 0;
                    while ((long)z <= nNumberOfCoefficients) {
                        this.aryCoefficientsA[z] = this.m_pUnBitArray.DecodeValue(2, 6);
                        this.aryCoefficientsB[z] = this.m_pUnBitArray.DecodeValue(2, 6);
                        ++z;
                    }
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, Number_of_Elements, nFrameBytes);
                    ((AntiPredictorExtraHigh0000To3320)pAntiPredictor).AntiPredict(this.m_pTempData, Input_Array, Number_of_Elements, (int)nNumberOfCoefficients, this.aryCoefficientsA, this.aryCoefficientsB);
                    break;
                }
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3600) {
                    long nNumberOfCoefficients = this.m_pUnBitArray.DecodeValue(2, 3);
                    int z = 0;
                    while ((long)z <= nNumberOfCoefficients) {
                        this.aryCoefficientsA[z] = this.m_pUnBitArray.DecodeValue(2, 5);
                        this.aryCoefficientsB[z] = this.m_pUnBitArray.DecodeValue(2, 5);
                        ++z;
                    }
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, Number_of_Elements, nFrameBytes);
                    ((AntiPredictorExtraHigh3320To3600)pAntiPredictor).AntiPredict(this.m_pTempData, Input_Array, Number_of_Elements, (int)nNumberOfCoefficients, this.aryCoefficientsA, this.aryCoefficientsB);
                    break;
                }
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3700) {
                    long nNumberOfCoefficients = this.m_pUnBitArray.DecodeValue(2, 3);
                    int z = 0;
                    while ((long)z <= nNumberOfCoefficients) {
                        this.aryCoefficientsA[z] = this.m_pUnBitArray.DecodeValue(2, 6);
                        this.aryCoefficientsB[z] = this.m_pUnBitArray.DecodeValue(2, 6);
                        ++z;
                    }
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, Number_of_Elements, nFrameBytes);
                    ((AntiPredictorExtraHigh3600To3700)pAntiPredictor).AntiPredict(this.m_pTempData, Input_Array, Number_of_Elements, (int)nNumberOfCoefficients, this.aryCoefficientsA, this.aryCoefficientsB);
                    break;
                }
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3800) {
                    long nNumberOfCoefficients = this.m_pUnBitArray.DecodeValue(2, 3);
                    int z = 0;
                    while ((long)z <= nNumberOfCoefficients) {
                        this.aryCoefficientsA[z] = this.m_pUnBitArray.DecodeValue(2, 6);
                        this.aryCoefficientsB[z] = this.m_pUnBitArray.DecodeValue(2, 6);
                        ++z;
                    }
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, Number_of_Elements, nFrameBytes);
                    ((AntiPredictorExtraHigh3700To3800)pAntiPredictor).AntiPredict(this.m_pTempData, Input_Array, Number_of_Elements, (int)nNumberOfCoefficients, this.aryCoefficientsA, this.aryCoefficientsB);
                    break;
                }
                this.m_pUnBitArray.GenerateArray(this.m_pTempData, Number_of_Elements, nFrameBytes);
                ((AntiPredictorExtraHigh3800ToCurrent)pAntiPredictor).AntiPredict(this.m_pTempData, Input_Array, Number_of_Elements, this.m_pAPEDecompress.getApeInfoFileVersion());
            }
        }
    }

    public UnBitArrayBase GetUnBitArrray() {
        return this.m_pUnBitArray;
    }
}

