/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.spi.tritonus;

import davaguine.jmac.decoder.IAPEDecompress;
import davaguine.jmac.tools.File;
import davaguine.jmac.tools.InputStreamFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;

public class APEAudioInputStream
extends TAsynchronousFilteredAudioInputStream {
    private static final int BLOCKS_PER_DECODE = 9216;
    protected File file;
    protected IAPEDecompress m_decoder;
    protected byte[] buffer;
    protected byte[] skipbuffer;
    protected int nBlocksLeft;
    protected int blockAlign;
    protected int pos;
    protected int size;
    private HashMap properties;
    protected int currentBitrate;
    protected int currentBlock;
    protected int currentMs;

    public APEAudioInputStream(AudioFormat format, InputStream stream) {
        block2: {
            super(format, -1L);
            this.file = null;
            this.m_decoder = null;
            this.buffer = null;
            this.skipbuffer = null;
            this.pos = 0;
            this.size = 0;
            this.properties = null;
            try {
                this.file = new InputStreamFile(stream);
                this.m_decoder = IAPEDecompress.CreateIAPEDecompress(this.file);
                this.nBlocksLeft = this.m_decoder.getApeInfoDecompressTotalBlocks();
                this.blockAlign = this.m_decoder.getApeInfoBlockAlign();
                this.currentBitrate = this.m_decoder.getApeInfoAverageBitrate();
                this.currentBlock = 0;
                this.currentMs = 0;
                this.buffer = new byte[this.blockAlign * 9216];
                this.buffer = new byte[this.blockAlign * 9216];
                this.properties = new HashMap();
            }
            catch (IOException e) {
                if (!TDebug.TraceAudioInputStream) break block2;
                TDebug.out((Throwable)e);
            }
        }
    }

    public Map properties() {
        this.properties.put("ape.block", new Integer(this.currentBlock));
        this.properties.put("ape.bitrate", new Integer(this.currentBitrate));
        this.properties.put("ape.position.microseconds", new Integer(this.currentMs));
        return this.properties;
    }

    public void execute() {
        block8: {
            if (TDebug.TraceAudioInputStream) {
                TDebug.out((String)"execute() : begin");
            }
            try {
                if (this.m_decoder == null) {
                    throw new IOException("Stream closed");
                }
                this.pos = 0;
                if (this.nBlocksLeft > 0) {
                    int nBlocksDecoded = this.m_decoder.GetData(this.buffer, 9216);
                    this.nBlocksLeft -= nBlocksDecoded;
                    this.size = nBlocksDecoded * this.blockAlign;
                    this.currentBitrate = this.m_decoder.getApeInfoDecompressCurrentBitRate();
                    this.currentBlock = this.m_decoder.getApeInfoDecompressCurrentBlock();
                    this.currentMs = this.m_decoder.getApeInfoDecompressCurrentMS();
                    if (TDebug.TraceAudioInputStream) {
                        TDebug.out((String)("ape.block: " + this.currentBlock));
                        TDebug.out((String)("ape.bitrate: " + this.currentBitrate));
                        TDebug.out((String)("ape.position.microseconds: " + this.currentMs));
                    }
                    this.getCircularBuffer().write(this.buffer, 0, this.size);
                } else {
                    this.size = 0;
                    this.getCircularBuffer().close();
                }
            }
            catch (IOException e) {
                if (!TDebug.TraceAudioInputStream) break block8;
                TDebug.out((Throwable)e);
            }
        }
        if (TDebug.TraceAudioInputStream) {
            TDebug.out((String)"execute() : end");
        }
    }

    public void close() throws IOException {
        if (this.m_decoder == null) {
            return;
        }
        this.file.close();
        this.file = null;
        this.m_decoder = null;
        this.buffer = null;
        this.properties = null;
    }
}

