/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CollectionProperties;
import net.sourceforge.dvb.projectx.gui.CutPanel;
import net.sourceforge.dvb.projectx.gui.FileProperties;
import net.sourceforge.dvb.projectx.gui.PatchDialog;
import net.sourceforge.dvb.projectx.gui.PicturePanel;
import net.sourceforge.dvb.projectx.gui.PlayerFrame;
import net.sourceforge.dvb.projectx.gui.SubpictureFrame;
import net.sourceforge.dvb.projectx.gui.X_JFileChooser;

public class CommonGui {
    private static JFrame frame = null;
    private static Object suggestion = null;
    private static X_JFileChooser chooser;
    private static CutPanel cutpanel;
    private static PicturePanel picturepanel;
    private static FileProperties file_properties;
    private static CollectionProperties collection_properties;
    private static PatchDialog patch_dialog;
    private static PlayerFrame player_frame;
    private static SubpictureFrame subpicture_frame;

    static {
        patch_dialog = null;
        player_frame = null;
        subpicture_frame = null;
    }

    public CommonGui() {
        chooser = new X_JFileChooser();
        picturepanel = new PicturePanel();
        cutpanel = new CutPanel();
        file_properties = new FileProperties();
        collection_properties = new CollectionProperties();
    }

    public static CollectionProperties getCollectionProperties() {
        return collection_properties;
    }

    public static CutPanel getCutPanel() {
        return cutpanel;
    }

    public static FileProperties getFileProperties() {
        return file_properties;
    }

    public static X_JFileChooser getMainFileChooser() {
        return chooser;
    }

    public static PatchDialog getPatchDialog() {
        if (patch_dialog == null) {
            patch_dialog = new PatchDialog(frame);
        }
        return patch_dialog;
    }

    public static PicturePanel getPicturePanel() {
        return picturepanel;
    }

    public static PlayerFrame getPlayerFrame() {
        if (player_frame == null) {
            player_frame = new PlayerFrame();
        }
        return player_frame;
    }

    public static SubpictureFrame getSubpictureFrame() {
        if (subpicture_frame == null) {
            subpicture_frame = new SubpictureFrame();
        }
        return subpicture_frame;
    }

    public static boolean getUserConfirmation(String string) {
        int n = JOptionPane.showConfirmDialog(frame, string);
        return n == 0;
    }

    public static String getUserInput(String string) {
        return CommonGui.getUserInput(string, null);
    }

    public static String getUserInput(String string, String string2) {
        String string3 = CommonGui.getUserInput(string, string2, suggestion);
        if (string3 != null) {
            suggestion = string3;
            return string3.toString();
        }
        return null;
    }

    public static String getUserInput(String string, String string2, Object object) {
        return CommonGui.getUserInput(null, string, string2, object);
    }

    public static String getUserInput(JFrame jFrame, String string, String string2, Object object) {
        Object object2;
        if (jFrame == null) {
            jFrame = frame;
        }
        if ((object2 = JOptionPane.showInputDialog(jFrame, string, string2, 3, null, null, object)) != null) {
            return object2.toString();
        }
        return null;
    }

    public static ImageIcon loadIcon(String string) {
        return new ImageIcon(Resource.getResourceURL(string));
    }

    public static final void localize(AbstractButton abstractButton, String string) {
        String string2 = Resource.getString(string);
        int n = string2.indexOf(38);
        if (n != -1) {
            char c = string2.charAt(n + 1);
            abstractButton.setMnemonic(c);
            string2 = String.valueOf(string2.substring(0, n)) + string2.substring(n + 1);
        }
        abstractButton.setText(string2);
    }

    public static void setMainFrame(JFrame jFrame) {
        frame = jFrame;
    }

    public static void showErrorMessageDialog(Object object, String string) {
        JOptionPane.showMessageDialog(null, object, string, 0);
    }

    public static void showMessageDialog(Object object, String string) {
        JOptionPane.showMessageDialog(null, object, string, 1);
    }
}

